/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import org.apache.openejb.client.Options;

public class CommandParser {
    private final Map<String, Option> opts = new LinkedHashMap<String, Option>();

    public CommandParser() {
        this.init();
    }

    protected void init() {
    }

    protected List<String> validate(Arguments arguments) {
        return new ArrayList<String>();
    }

    protected List<String> usage() {
        return new ArrayList<String>();
    }

    public void category(String name) {
        this.opts.put("-@" + name, new Category(name));
    }

    public Option opt(String _long) {
        return this.opt(new Option(_long));
    }

    public Option opt(char _short, String _long) {
        return this.opt(new Option(_short, _long));
    }

    private Option opt(Option o) {
        this.opts.put(o.getName(), o);
        if (o.getMini() != null) {
            this.opts.put(o.getMini(), o);
        }
        return o;
    }

    private void help() {
        Iterator<String> usage = this.usage().iterator();
        if (usage.hasNext()) {
            System.out.println("Usage: " + usage.next());
        }
        while (usage.hasNext()) {
            System.out.println("  or   " + usage.next());
        }
        ArrayList<Option> seen = new ArrayList<Option>();
        for (Option option : this.opts.values()) {
            if (seen.contains(option)) continue;
            seen.add(option);
            if (option instanceof Category) {
                System.out.println("");
                System.out.println(option.getName() + ":");
                continue;
            }
            StringBuilder s = new StringBuilder();
            if (option.getMini() != null) {
                s.append(" -");
                s.append(option.getMini());
                s.append(",  ");
            } else {
                s.append("      ");
            }
            s.append("--");
            s.append(option.getName());
            if (option.getType() != null) {
                s.append("=");
                s.append(option.getType().getSimpleName());
            }
            if (option.getDescription() != null || option.getValue() != null) {
                for (int i = s.length(); i < 29; ++i) {
                    s.append(' ');
                }
                s.append(' ');
                s.append(' ');
                if (option.getDescription() != null) {
                    s.append(option.getDescription());
                }
                if (option.getValue() != null) {
                    if (option.getDescription() != null) {
                        s.append(" ");
                    }
                    s.append("Default is ");
                    s.append(option.getValue());
                }
            }
            System.out.println(s.toString());
        }
    }

    public Arguments parse(String[] args) throws HelpException, InvalidOptionsException {
        String arg;
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(args));
        ListIterator<String> items = list.listIterator();
        Properties props = new Properties();
        while (items.hasNext() && (arg = (String)items.next()).startsWith("-")) {
            items.remove();
            boolean longOption = arg.startsWith("--");
            arg = arg.replaceFirst("-+", "");
            if (longOption) {
                Option option;
                String value;
                String name;
                if (arg.equals("help")) {
                    props.put("help", "");
                    continue;
                }
                if (arg.contains("=")) {
                    name = arg.substring(0, arg.indexOf("="));
                    value = arg.substring(arg.indexOf("=") + 1);
                } else {
                    name = arg;
                    option = this.opts.get(name);
                    value = this.value(items, option);
                }
                option = this.opts.get(name);
                this.checkOption("--" + name, option);
                this.checkValue("--" + name, value, option);
                props.put(option.getName(), value);
                continue;
            }
            char[] chars = new char[arg.length()];
            arg.getChars(0, chars.length, chars, 0);
            for (int i = 0; i < chars.length; ++i) {
                char c = chars[i];
                String name = c + "";
                Option option = this.opts.get(name);
                this.checkOption("-" + name, option);
                String value = "";
                if (i + 1 >= chars.length) {
                    value = this.value(items, option);
                }
                this.checkValue("-" + c, value, option);
                props.put(option.getName(), value);
            }
        }
        Arguments arguments = new Arguments(new Options(props), list);
        if (arguments.options().has("help")) {
            this.help();
            throw new HelpException();
        }
        List<String> issues = this.validate(arguments);
        if (issues.size() > 0) {
            for (String issue : issues) {
                System.err.println(issue);
            }
            System.err.println();
            this.help();
            throw new InvalidOptionsException();
        }
        return arguments;
    }

    private void checkValue(String optString, String value, Option option) {
        this.checkOption(optString, option);
        if (option.getType() == null) {
            return;
        }
        if (value == null || value.equals("")) {
            System.err.println("Missing param " + optString + " <" + option.getType().getSimpleName() + ">");
            System.exit(1);
        }
    }

    private void checkOption(String invalid, Option option) {
        if (option != null) {
            return;
        }
        System.err.println("Unknown option: " + invalid);
        this.help();
        System.exit(1);
    }

    private String value(ListIterator<String> items, Option option) {
        if (option.getType() != null && items.hasNext()) {
            String possibleValue = items.next();
            if (!possibleValue.startsWith("-")) {
                items.remove();
                return possibleValue;
            }
            items.previous();
        }
        return "";
    }

    public static class InvalidOptionsException
    extends Exception {
    }

    public static class HelpException
    extends Exception {
    }

    public static class Option {
        private final String mini;
        private final String name;
        private String description;
        private Class type;
        private Object value;

        Option(char mini, String name) {
            this(mini + "", name);
        }

        Option(String name) {
            this(null, name);
        }

        Option(String mini, String name) {
            this.mini = mini;
            this.name = name;
        }

        public Option description(String description) {
            if (!description.endsWith(".")) {
                description = description + ".";
            }
            this.setDescription(description);
            return this;
        }

        public Option type(Class type) {
            this.setType(type);
            return this;
        }

        public Option value(Object value) {
            this.setValue(value);
            if (this.getType() == null) {
                this.setType(value.getClass());
            }
            return this;
        }

        public String getMini() {
            return this.mini;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public Class getType() {
            return this.type;
        }

        public void setType(Class type) {
            this.type = type;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }
    }

    public static class Category
    extends Option {
        public Category(String name) {
            super(name);
        }
    }

    public static final class Arguments {
        private final Options options;
        private final List<String> args;

        public Arguments(Options options, List<String> args) {
            this.options = options;
            this.args = args;
        }

        public Options options() {
            return this.options;
        }

        public List<String> get() {
            return this.args;
        }
    }
}

