/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.component;

import java.lang.reflect.Method;
import javax.enterprise.context.spi.CreationalContext;
import org.apache.webbeans.component.AbstractProducerBean;
import org.apache.webbeans.component.BeanAttributesImpl;
import org.apache.webbeans.component.InjectionTargetBean;
import org.apache.webbeans.component.WebBeansType;
import org.apache.webbeans.component.creation.MethodProducerFactory;
import org.apache.webbeans.exception.WebBeansConfigurationException;

public class ProducerMethodBean<T>
extends AbstractProducerBean<T> {
    protected Method creatorMethod;
    protected Method disposalMethod;

    public <P> ProducerMethodBean(InjectionTargetBean<P> ownerComponent, BeanAttributesImpl<T> beanAttributes, Class<T> returnType, MethodProducerFactory<P> producerFactory) {
        super(ownerComponent, WebBeansType.PRODUCERMETHOD, beanAttributes, returnType, producerFactory);
    }

    public Method getCreatorMethod() {
        return this.creatorMethod;
    }

    public Method getDisposalMethod() {
        return this.disposalMethod;
    }

    public void setCreatorMethod(Method creatorMethod) {
        this.creatorMethod = creatorMethod;
    }

    public void setDisposalMethod(Method disposalMethod) {
        if (this.disposalMethod != null) {
            throw new WebBeansConfigurationException("There are multiple disposal method for producer method component with name : " + this.getName() + " with implementation class " + this.getBeanClass().getName() + " with disposal method name : " + disposalMethod.getName());
        }
        this.disposalMethod = disposalMethod;
    }

    @Override
    public String getId() {
        if (this.passivatingId == null) {
            String id = super.getId();
            this.passivatingId = id + "#" + this.creatorMethod.toGenericString();
        }
        return this.passivatingId;
    }

    @Override
    public T create(CreationalContext<T> creationalContext) {
        T instance = super.create(creationalContext);
        this.checkNullInstance(instance, this.creatorMethod.getName());
        this.checkScopeType(this.creatorMethod.getName());
        return instance;
    }

    @Override
    public boolean isPassivationCapable() {
        return this.isPassivationCapable(this.creatorMethod.getReturnType(), this.creatorMethod.getModifiers());
    }
}

