/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.catalina;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.catalina.ContainerEvent;
import org.apache.catalina.ContainerListener;
import org.apache.catalina.core.StandardContext;
import org.apache.tomee.catalina.LegacyAnnotationProcessorListener;
import org.apache.tomee.common.LegacyAnnotationProcessor;

public class ProcessAnnotatedListenersListener
extends LegacyAnnotationProcessorListener
implements ContainerListener {
    private Object[] applicationLifecycleListeners;
    private Set<Object> destroyed;

    public ProcessAnnotatedListenersListener(LegacyAnnotationProcessor annotationProcessor) {
        super(annotationProcessor);
    }

    public void containerEvent(ContainerEvent event) {
        String type = event.getType();
        if ("beforeContextInitialized".equals(type)) {
            this.listenerStart(event);
        } else if ("afterContextDestroyed".equals(type)) {
            this.listenerStop(event);
        }
    }

    private void listenerStart(ContainerEvent event) {
        if (!this.isFirstBeforeContextInitializedEvent(event)) {
            return;
        }
        StandardContext standardContext = (StandardContext)event.getContainer();
        for (Object listener : this.getListeners(standardContext)) {
            this.processAnnotations(listener);
            this.postConstruct(listener);
        }
    }

    private boolean isFirstBeforeContextInitializedEvent(ContainerEvent event) {
        if (this.applicationLifecycleListeners != null) {
            return false;
        }
        StandardContext standardContext = (StandardContext)event.getContainer();
        this.applicationLifecycleListeners = standardContext.getApplicationLifecycleListeners();
        this.destroyed = new HashSet<Object>();
        return true;
    }

    private void listenerStop(ContainerEvent event) {
        if (!this.isLastAfterContextDestroyedEvent(event)) {
            return;
        }
        StandardContext standardContext = (StandardContext)event.getContainer();
        for (Object listener : this.getListeners(standardContext)) {
            this.preDestroy(listener);
        }
    }

    private boolean isLastAfterContextDestroyedEvent(ContainerEvent event) {
        if (this.destroyed == null || this.applicationLifecycleListeners == null) {
            return false;
        }
        if (this.destroyed.size() == this.applicationLifecycleListeners.length) {
            return false;
        }
        Object listener = event.getData();
        this.destroyed.add(listener);
        return this.destroyed.size() == this.applicationLifecycleListeners.length;
    }

    private List<Object> getListeners(StandardContext standardContext) {
        ArrayList<Object> listeners = new ArrayList<Object>();
        listeners.addAll(Arrays.asList(standardContext.getApplicationEventListeners()));
        listeners.addAll(Arrays.asList(standardContext.getApplicationLifecycleListeners()));
        return listeners;
    }
}

