/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.catalina;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.deploy.ContextEjb;
import org.apache.catalina.deploy.ContextEnvironment;
import org.apache.catalina.deploy.ContextLocalEjb;
import org.apache.catalina.deploy.ContextResource;
import org.apache.catalina.deploy.ContextResourceEnvRef;
import org.apache.catalina.deploy.ContextResourceLink;
import org.apache.catalina.deploy.NamingResources;
import org.apache.catalina.deploy.ResourceBase;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.assembler.classic.Assembler;
import org.apache.openejb.assembler.classic.ResourceInfo;
import org.apache.openejb.assembler.classic.ServiceInfo;
import org.apache.openejb.assembler.dynamic.PassthroughFactory;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

public class OpenEJBNamingContextListener
implements LifecycleListener,
PropertyChangeListener {
    private static final Logger logger = Logger.getInstance((LogCategory)LogCategory.OPENEJB.createChild("tomcat"), (String)"org.apache.openejb.util.resources");
    private final StandardServer standardServer;
    private boolean running;
    private final NamingResources namingResources;

    public OpenEJBNamingContextListener(StandardServer standardServer) {
        this.standardServer = standardServer;
        this.namingResources = standardServer.getGlobalNamingResources();
    }

    public void lifecycleEvent(LifecycleEvent event) {
        if (event.getLifecycle() != this.standardServer) {
            return;
        }
        if ("start".equals(event.getType())) {
            this.start();
        } else if ("stop".equals(event.getType())) {
            this.stop();
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public void start() {
        if (this.running) {
            return;
        }
        this.namingResources.addPropertyChangeListener((PropertyChangeListener)this);
        this.processInitialNamingResources();
        this.running = true;
    }

    public void stop() {
        if (!this.running) {
            return;
        }
        this.namingResources.removePropertyChangeListener((PropertyChangeListener)this);
        this.running = false;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (!this.running) {
            return;
        }
        Object source = event.getSource();
        if (source == this.namingResources) {
            this.processGlobalResourcesChange(event.getPropertyName(), event.getOldValue(), event.getNewValue());
        }
    }

    private void processGlobalResourcesChange(String name, Object oldValue, Object newValue) {
        if (name.equals("ejb")) {
            ContextEjb ejb;
            if (oldValue != null && (ejb = (ContextEjb)oldValue).getName() != null) {
                this.removeEjb(ejb.getName());
            }
            if (newValue != null && (ejb = (ContextEjb)newValue).getName() != null) {
                this.addEjb(ejb);
            }
        } else if (name.equals("environment")) {
            ContextEnvironment env;
            if (oldValue != null && (env = (ContextEnvironment)oldValue).getName() != null) {
                this.removeEnvironment(env.getName());
            }
            if (newValue != null && (env = (ContextEnvironment)newValue).getName() != null) {
                this.addEnvironment(env);
            }
        } else if (name.equals("localEjb")) {
            ContextLocalEjb ejb;
            if (oldValue != null && (ejb = (ContextLocalEjb)oldValue).getName() != null) {
                this.removeLocalEjb(ejb.getName());
            }
            if (newValue != null && (ejb = (ContextLocalEjb)newValue).getName() != null) {
                this.addLocalEjb(ejb);
            }
        } else if (name.equals("resource")) {
            ContextResource resource;
            if (oldValue != null && (resource = (ContextResource)oldValue).getName() != null) {
                this.removeResource(resource.getName());
            }
            if (newValue != null && (resource = (ContextResource)newValue).getName() != null) {
                this.addResource(resource);
            }
        } else if (name.equals("resourceEnvRef")) {
            ContextResourceEnvRef resourceEnvRef;
            if (oldValue != null && (resourceEnvRef = (ContextResourceEnvRef)oldValue).getName() != null) {
                this.removeResourceEnvRef(resourceEnvRef.getName());
            }
            if (newValue != null && (resourceEnvRef = (ContextResourceEnvRef)newValue).getName() != null) {
                this.addResourceEnvRef(resourceEnvRef);
            }
        } else if (name.equals("resourceLink")) {
            ContextResourceLink rl;
            if (oldValue != null && (rl = (ContextResourceLink)oldValue).getName() != null) {
                this.removeResourceLink(rl.getName());
            }
            if (newValue != null && (rl = (ContextResourceLink)newValue).getName() != null) {
                this.addResourceLink(rl);
            }
        }
    }

    private void processInitialNamingResources() {
        ContextEjb[] ejbs;
        ContextEnvironment[] contextEnvironments;
        ContextResourceEnvRef[] resourceEnvRefs;
        ContextResource[] resources;
        ContextResourceLink[] resourceLinks;
        for (ContextResourceLink resourceLink : resourceLinks = this.namingResources.findResourceLinks()) {
            this.addResourceLink(resourceLink);
        }
        for (ContextResource resource : resources = this.namingResources.findResources()) {
            this.addResource(resource);
        }
        for (ContextResourceEnvRef resourceEnvRef : resourceEnvRefs = this.namingResources.findResourceEnvRefs()) {
            this.addResourceEnvRef(resourceEnvRef);
        }
        for (ContextEnvironment contextEnvironment : contextEnvironments = this.namingResources.findEnvironments()) {
            this.addEnvironment(contextEnvironment);
        }
        for (ContextEjb ejb : ejbs = this.namingResources.findEjbs()) {
            this.addEjb(ejb);
        }
    }

    public void addEjb(ContextEjb ejb) {
    }

    public void addEnvironment(ContextEnvironment env) {
        this.bindResource((ResourceBase)env);
    }

    public void addLocalEjb(ContextLocalEjb localEjb) {
    }

    public void addResource(ContextResource resource) {
        this.bindResource((ResourceBase)resource);
    }

    public void addResourceEnvRef(ContextResourceEnvRef resourceEnvRef) {
        this.bindResource((ResourceBase)resourceEnvRef);
    }

    private void bindResource(ResourceBase res) {
        try {
            Context globalNamingContext = this.standardServer.getGlobalNamingContext();
            Object value = globalNamingContext.lookup(res.getName());
            String type = res.getType();
            this.bindResource(res.getName(), value, type);
        }
        catch (NamingException e) {
            logger.error("Unable to lookup Global Tomcat resource " + res.getName(), (Throwable)e);
        }
    }

    private void bindResource(String name, Object value, String type) {
        Assembler assembler = (Assembler)SystemInstance.get().getComponent(org.apache.openejb.spi.Assembler.class);
        try {
            assembler.getContainerSystem().getJNDIContext().lookup("openejb/Resource/" + name);
            return;
        }
        catch (NamingException namingException) {
            ResourceInfo resourceInfo = new ResourceInfo();
            resourceInfo.id = name;
            resourceInfo.service = "Resource";
            resourceInfo.types.add(type);
            PassthroughFactory.add((ServiceInfo)resourceInfo, (Object)value);
            logger.info("Importing a Tomcat Resource with id '" + resourceInfo.id + "' of type '" + type + "'.");
            try {
                assembler.createResource(resourceInfo);
            }
            catch (OpenEJBException e) {
                logger.error("Unable to bind Global Tomcat resource " + name + " into OpenEJB", (Throwable)e);
            }
            return;
        }
    }

    public void addResourceLink(ContextResourceLink resourceLink) {
    }

    public void removeEjb(String name) {
    }

    public void removeEnvironment(String name) {
    }

    public void removeLocalEjb(String name) {
    }

    public void removeResource(String name) {
    }

    public void removeResourceEnvRef(String name) {
    }

    public void removeResourceLink(String name) {
    }
}

