/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.client.event.message;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.Message;
import org.apache.oozie.AppType;
import org.apache.oozie.client.event.Event;
import org.apache.oozie.client.event.JobEvent;
import org.apache.oozie.client.event.message.EventMessage;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public class JobMessage
extends EventMessage {
    @JsonProperty
    private String id;
    @JsonProperty
    private String parentId;
    @JsonProperty
    private Date startTime;
    @JsonProperty
    private Date endTime;
    private Map<String, String> jmsMessageProperties = new HashMap<String, String>();
    private JobEvent.EventStatus eventStatus;
    private String appName;
    private String user;

    public JobMessage() {
    }

    public JobMessage(JobEvent.EventStatus eventStatus, AppType appType, String id, String parentId, Date startTime, Date endTime, String user, String appName) {
        super(Event.MessageType.JOB, appType);
        this.eventStatus = eventStatus;
        this.id = id;
        this.parentId = parentId;
        this.startTime = startTime;
        this.appName = appName;
        this.user = user;
        this.endTime = endTime;
        this.jmsMessageProperties = new HashMap<String, String>();
        this.jmsMessageProperties.put("appType", appType.toString());
        this.jmsMessageProperties.put("msgType", Event.MessageType.JOB.toString());
        this.jmsMessageProperties.put("eventStatus", eventStatus.toString());
        this.jmsMessageProperties.put("appName", appName);
        this.jmsMessageProperties.put("user", user);
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    @JsonIgnore
    public String getAppName() {
        return this.appName;
    }

    void setMessageProperties(Map<String, String> properties) {
        this.jmsMessageProperties = properties;
    }

    @JsonIgnore
    public Map<String, String> getMessageProperties() {
        return this.jmsMessageProperties;
    }

    public void setUser(String user) {
        this.user = user;
    }

    @JsonIgnore
    public String getUser() {
        return this.user;
    }

    public void setEventStatus(JobEvent.EventStatus eventStatus) {
        this.eventStatus = eventStatus;
    }

    @JsonIgnore
    public JobEvent.EventStatus getEventStatus() {
        return this.eventStatus;
    }

    @Override
    public void setProperties(Message message) throws JMSException {
        super.setProperties(message);
        this.setEventStatus(JobEvent.EventStatus.valueOf(message.getStringProperty("eventStatus")));
        this.setAppName(message.getStringProperty("appName"));
        this.setUser(message.getStringProperty("user"));
    }
}

