/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oltu.oauth2.jwt;

import java.util.Map;
import org.apache.oltu.commons.json.CustomizableEntity;

public final class ClaimsSet
extends CustomizableEntity {
    private final String issuer;
    private final String subject;
    private final String audience;
    private final long expirationTime;
    private final String notBefore;
    private final long issuedAt;
    private final String jwdId;
    private final String type;

    ClaimsSet(String issuer, String subject, String audience, long expirationTime, String notBefore, long issuedAt, String jwdId, String type, Map<String, Object> customFields) {
        super(customFields);
        this.issuer = issuer;
        this.subject = subject;
        this.audience = audience;
        this.expirationTime = expirationTime;
        this.notBefore = notBefore;
        this.issuedAt = issuedAt;
        this.jwdId = jwdId;
        this.type = type;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getAudience() {
        return this.audience;
    }

    public long getExpirationTime() {
        return this.expirationTime;
    }

    public String getNotBefore() {
        return this.notBefore;
    }

    public long getIssuedAt() {
        return this.issuedAt;
    }

    public String getJwdId() {
        return this.jwdId;
    }

    public String getType() {
        return this.type;
    }

    public String toString() {
        return String.format("{\"iss\": \"%s\", \"sub\": \"%s\", \"aud\": \"%s\", \"exp\": %s, \"nbf\": \"%s\", \"iat\": %s, \"jti\": \"%s\", \"typ\": \"%s\" }", this.issuer, this.subject, this.audience, this.expirationTime, this.notBefore, this.issuedAt, this.jwdId, this.type, super.toString());
    }
}

