/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oltu.oauth2.common.utils;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonString;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.json.stream.JsonGenerator;
import javax.json.stream.JsonGeneratorFactory;

public final class JSONUtils {
    private static final JsonGeneratorFactory GENERATOR_FACTORY = Json.createGeneratorFactory(null);

    public static String buildJSON(Map<String, Object> params) {
        StringWriter stringWriter = new StringWriter();
        JsonGenerator generator = GENERATOR_FACTORY.createGenerator((Writer)stringWriter);
        generator.writeStartObject();
        for (Map.Entry<String, Object> param : params.entrySet()) {
            String key = param.getKey();
            Object value = param.getValue();
            if (key == null || value == null) continue;
            if (value instanceof Boolean) {
                generator.write(key, ((Boolean)value).booleanValue());
                continue;
            }
            if (value instanceof Double) {
                generator.write(key, ((Double)value).doubleValue());
                continue;
            }
            if (value instanceof Integer) {
                generator.write(key, ((Integer)value).intValue());
                continue;
            }
            if (value instanceof BigDecimal) {
                generator.write(key, (BigDecimal)value);
                continue;
            }
            if (value instanceof BigInteger) {
                generator.write(key, (BigInteger)value);
                continue;
            }
            if (value instanceof Long) {
                generator.write(key, ((Long)value).longValue());
                continue;
            }
            if (value instanceof String) {
                String string = (String)value;
                if (string.isEmpty()) continue;
                generator.write(key, string);
                continue;
            }
            if (value.getClass().isArray()) {
                generator.writeStartArray(key);
                for (int i = 0; i < Array.getLength(value); ++i) {
                    JSONUtils.witeItem(generator, Array.get(value, i));
                }
                generator.writeEnd();
                continue;
            }
            if (!(value instanceof Collection)) continue;
            generator.writeStartArray(key);
            Collection collection = (Collection)value;
            for (Object item : collection) {
                JSONUtils.witeItem(generator, item);
            }
            generator.writeEnd();
        }
        generator.writeEnd().close();
        return stringWriter.toString();
    }

    private static <T> void witeItem(JsonGenerator generator, T item) {
        if (item != null) {
            if (item instanceof Boolean) {
                generator.write(((Boolean)item).booleanValue());
            } else if (item instanceof Double) {
                generator.write(((Double)item).doubleValue());
            } else if (item instanceof Integer) {
                generator.write(((Integer)item).intValue());
            } else if (item instanceof BigDecimal) {
                generator.write((BigDecimal)item);
            } else if (item instanceof BigInteger) {
                generator.write((BigInteger)item);
            } else if (item instanceof Long) {
                generator.write(((Long)item).longValue());
            } else if (item instanceof String) {
                generator.write((String)item);
            }
        }
    }

    public static Map<String, Object> parseJSON(String jsonBody) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        StringReader reader = new StringReader(jsonBody);
        JsonReader jsonReader = Json.createReader((Reader)reader);
        JsonStructure structure = jsonReader.read();
        if (structure == null || structure instanceof JsonArray) {
            throw new IllegalArgumentException(String.format("String '%s' is not a valid JSON object representation", jsonBody));
        }
        JsonObject object = (JsonObject)structure;
        for (Map.Entry entry : object.entrySet()) {
            JsonValue jsonValue;
            String key = (String)entry.getKey();
            if (key == null || key.isEmpty() || (jsonValue = (JsonValue)entry.getValue()) == null) continue;
            Object value = JSONUtils.toJavaObject(jsonValue);
            params.put(key, value);
        }
        jsonReader.close();
        return params;
    }

    private static Object toJavaObject(JsonValue jsonValue) {
        Object[] value = null;
        switch (jsonValue.getValueType()) {
            case ARRAY: {
                JsonArray array = (JsonArray)jsonValue;
                Object[] values = new Object[array.size()];
                for (int i = 0; i < array.size(); ++i) {
                    JsonValue current = (JsonValue)array.get(i);
                    values[i] = JSONUtils.toJavaObject(current);
                }
                value = values;
                break;
            }
            case FALSE: {
                value = false;
                break;
            }
            case NULL: {
                value = null;
                break;
            }
            case NUMBER: {
                JsonNumber jsonNumber = (JsonNumber)jsonValue;
                value = jsonNumber.numberValue();
                break;
            }
            case OBJECT: {
                break;
            }
            case STRING: {
                JsonString jsonString = (JsonString)jsonValue;
                value = jsonString.getString();
                break;
            }
            case TRUE: {
                value = true;
                break;
            }
        }
        return value;
    }
}

