/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.api.edm;

import org.apache.olingo.commons.api.edm.FullQualifiedName;

public enum EdmPrimitiveTypeKind {
    Binary,
    Boolean,
    Byte,
    SByte,
    Date,
    DateTimeOffset,
    TimeOfDay,
    Duration,
    Decimal,
    Single,
    Double,
    Guid,
    Int16,
    Int32,
    Int64,
    String,
    Stream,
    Geography,
    GeographyPoint,
    GeographyLineString,
    GeographyPolygon,
    GeographyMultiPoint,
    GeographyMultiLineString,
    GeographyMultiPolygon,
    GeographyCollection,
    Geometry,
    GeometryPoint,
    GeometryLineString,
    GeometryPolygon,
    GeometryMultiPoint,
    GeometryMultiLineString,
    GeometryMultiPolygon,
    GeometryCollection;


    public boolean isGeospatial() {
        return this.name().startsWith("Geo");
    }

    public FullQualifiedName getFullQualifiedName() {
        return new FullQualifiedName("Edm", this.toString());
    }

    public static EdmPrimitiveTypeKind valueOfFQN(FullQualifiedName fqn) {
        if ("Edm".equals(fqn.getNamespace())) {
            return EdmPrimitiveTypeKind.valueOf(fqn.getName());
        }
        throw new IllegalArgumentException(fqn + " does not look like an EDM primitive type.");
    }

    public static EdmPrimitiveTypeKind valueOfFQN(String fqn) {
        if (!fqn.startsWith("Edm.")) {
            throw new IllegalArgumentException(fqn + " does not look like an Edm primitive type");
        }
        return EdmPrimitiveTypeKind.valueOf(fqn.substring(4));
    }
}

