/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple.form;

import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.odftoolkit.odfdom.dom.element.form.FormFormElement;
import org.odftoolkit.odfdom.dom.element.office.OfficeFormsElement;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.simple.form.Form;
import org.odftoolkit.simple.form.FormContainer;
import org.odftoolkit.simple.form.FormProvider;
import org.odftoolkit.simple.form.OOFormProvider;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

public abstract class AbstractFormContainer
implements FormContainer {
    private FormProvider provider = null;

    @Override
    public abstract OfficeFormsElement getFormContainerElement();

    @Override
    public Form createForm(String name) {
        return this.getProvider().createForm(name, this.getFormContainerElement());
    }

    @Override
    public boolean removeForm(Form form) {
        if (form == null) {
            return true;
        }
        OfficeFormsElement containerElement = this.getFormContainerElement();
        FormFormElement formElement = form.getOdfElement();
        try {
            containerElement.removeChild((Node)formElement);
        }
        catch (DOMException exception) {
            Logger.getLogger(AbstractFormContainer.class.getName()).log(Level.WARNING, exception.getMessage());
            return false;
        }
        return true;
    }

    @Override
    public Form getFormByName(String name) {
        if (name == null) {
            return null;
        }
        OfficeFormsElement container = this.getFormContainerElement();
        FormFormElement element = (FormFormElement)OdfElement.findFirstChildNode(FormFormElement.class, (Node)container);
        while (element != null) {
            if (name.equals(element.getFormNameAttribute())) {
                Form form = this.getProvider().getInstanceOf(element);
                return form;
            }
            element = (FormFormElement)OdfElement.findNextChildNode(FormFormElement.class, (Node)element);
        }
        return null;
    }

    @Override
    public Iterator<Form> getFormIterator() {
        return new SimpleFormIterator(this);
    }

    @Override
    public boolean getApplyDesignMode() {
        return this.getFormContainerElement().getFormApplyDesignModeAttribute();
    }

    @Override
    public boolean getAutomaticFocus() {
        return this.getFormContainerElement().getFormAutomaticFocusAttribute();
    }

    @Override
    public void setApplyDesignMode(boolean isDesignMode) {
        this.getFormContainerElement().setFormApplyDesignModeAttribute(Boolean.valueOf(isDesignMode));
    }

    @Override
    public void setAutomaticFocus(boolean isAutoFocus) {
        this.getFormContainerElement().setFormAutomaticFocusAttribute(Boolean.valueOf(isAutoFocus));
    }

    public void setProvider(FormProvider provider) {
        this.provider = provider;
    }

    public FormProvider getProvider() {
        if (this.provider == null) {
            this.provider = new OOFormProvider();
        }
        return this.provider;
    }

    private class SimpleFormIterator
    implements Iterator<Form> {
        private OdfElement containerElement;
        private Form nextElement = null;
        private Form tempElement = null;

        private SimpleFormIterator(FormContainer container) {
            this.containerElement = container.getFormContainerElement();
        }

        @Override
        public boolean hasNext() {
            this.tempElement = this.findNext(this.nextElement);
            return this.tempElement != null;
        }

        @Override
        public Form next() {
            if (this.tempElement != null) {
                this.nextElement = this.tempElement;
                this.tempElement = null;
            } else {
                this.nextElement = this.findNext(this.nextElement);
            }
            if (this.nextElement == null) {
                return null;
            }
            return this.nextElement;
        }

        @Override
        public void remove() {
            if (this.nextElement == null) {
                throw new IllegalStateException("please call next() first.");
            }
            this.containerElement.removeChild((Node)this.nextElement.getOdfElement());
        }

        private Form findNext(Form thisForm) {
            FormFormElement nextForm = null;
            nextForm = thisForm == null ? (FormFormElement)OdfElement.findFirstChildNode(FormFormElement.class, (Node)this.containerElement) : (FormFormElement)OdfElement.findNextChildNode(FormFormElement.class, (Node)thisForm.getOdfElement());
            if (nextForm != null) {
                return AbstractFormContainer.this.getProvider().getInstanceOf(nextForm);
            }
            return null;
        }
    }
}

