/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.web.security.authorization;

import java.util.EnumSet;
import java.util.Set;
import org.apache.nifi.registry.web.security.authorization.HttpMethodAuthorizationRules;
import org.springframework.http.HttpMethod;

public class StandardHttpMethodAuthorizationRules
implements HttpMethodAuthorizationRules {
    private final Set<HttpMethod> methodsRequiringAuthorization;

    public StandardHttpMethodAuthorizationRules() {
        this(EnumSet.allOf(HttpMethod.class));
    }

    public StandardHttpMethodAuthorizationRules(Set<HttpMethod> methodsRequiringAuthorization) {
        this.methodsRequiringAuthorization = methodsRequiringAuthorization;
    }

    public boolean requiresAuthorization(HttpMethod httpMethod) {
        return this.methodsRequiringAuthorization.contains(httpMethod);
    }
}

