/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.web.security.authentication.x509;

import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.registry.security.authentication.AuthenticationRequest;
import org.apache.nifi.registry.security.authentication.AuthenticationResponse;
import org.apache.nifi.registry.security.authentication.IdentityProvider;
import org.apache.nifi.registry.security.authorization.Authorizer;
import org.apache.nifi.registry.security.authorization.user.NiFiUser;
import org.apache.nifi.registry.security.authorization.user.NiFiUserDetails;
import org.apache.nifi.registry.security.authorization.user.StandardNiFiUser;
import org.apache.nifi.registry.security.identity.IdentityMapper;
import org.apache.nifi.registry.security.util.ProxiedEntitiesUtils;
import org.apache.nifi.registry.web.security.authentication.AuthenticationRequestToken;
import org.apache.nifi.registry.web.security.authentication.AuthenticationSuccessToken;
import org.apache.nifi.registry.web.security.authentication.IdentityAuthenticationProvider;
import org.apache.nifi.registry.web.security.authentication.x509.X509AuthenticationRequestDetails;
import org.springframework.security.core.userdetails.UserDetails;

/*
 * Exception performing whole class analysis ignored.
 */
public class X509IdentityAuthenticationProvider
extends IdentityAuthenticationProvider {
    public X509IdentityAuthenticationProvider(Authorizer authorizer, IdentityProvider identityProvider, IdentityMapper identityMapper) {
        super(authorizer, identityProvider, identityMapper);
    }

    protected AuthenticationSuccessToken buildAuthenticatedToken(AuthenticationRequestToken requestToken, AuthenticationResponse response) {
        AuthenticationRequest authenticationRequest = requestToken.getAuthenticationRequest();
        Object requestDetails = authenticationRequest.getDetails();
        if (requestDetails == null || !(requestDetails instanceof X509AuthenticationRequestDetails)) {
            throw new IllegalStateException("Invalid request details specified");
        }
        X509AuthenticationRequestDetails x509RequestDetails = (X509AuthenticationRequestDetails)authenticationRequest.getDetails();
        String proxiedEntitiesChain = x509RequestDetails.getProxiedEntitiesChain();
        if (StringUtils.isBlank((CharSequence)proxiedEntitiesChain)) {
            return super.buildAuthenticatedToken(requestToken, response);
        }
        List proxyChain = ProxiedEntitiesUtils.tokenizeProxiedEntitiesChain((String)proxiedEntitiesChain);
        proxyChain.add(response.getIdentity());
        NiFiUser proxy = null;
        ListIterator chainIter = proxyChain.listIterator(proxyChain.size());
        while (chainIter.hasPrevious()) {
            String identity = (String)chainIter.previous();
            boolean isAnonymous = StringUtils.isBlank((CharSequence)identity);
            identity = isAnonymous ? "anonymous" : this.mapIdentity(identity);
            Set groups = this.getUserGroups(identity);
            String clientAddress = proxy == null ? requestToken.getClientAddress() : null;
            proxy = X509IdentityAuthenticationProvider.createUser((String)identity, (Set)groups, proxy, (String)clientAddress, (boolean)isAnonymous);
        }
        return new AuthenticationSuccessToken((UserDetails)new NiFiUserDetails(proxy));
    }

    private static NiFiUser createUser(String identity, Set<String> groups, NiFiUser chain, String clientAddress, boolean isAnonymous) {
        if (isAnonymous) {
            return StandardNiFiUser.populateAnonymousUser((NiFiUser)chain, (String)clientAddress);
        }
        return new StandardNiFiUser.Builder().identity(identity).groups(groups).chain(chain).clientAddress(clientAddress).build();
    }
}

