/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.web.security.authentication.kerberos;

import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.registry.security.authentication.AuthenticationRequest;
import org.apache.nifi.registry.security.authentication.AuthenticationResponse;
import org.apache.nifi.registry.security.authentication.BasicAuthIdentityProvider;
import org.apache.nifi.registry.security.authentication.IdentityProviderConfigurationContext;
import org.apache.nifi.registry.security.authentication.exception.IdentityAccessException;
import org.apache.nifi.registry.security.authentication.exception.InvalidCredentialsException;
import org.apache.nifi.registry.security.exception.SecurityProviderCreationException;
import org.apache.nifi.registry.security.exception.SecurityProviderDestructionException;
import org.apache.nifi.registry.security.util.kerberos.KerberosPrincipalParser;
import org.apache.nifi.registry.util.FormatUtils;
import org.apache.nifi.registry.web.security.authentication.kerberos.KerberosUserDetailsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.kerberos.authentication.KerberosAuthenticationProvider;
import org.springframework.security.kerberos.authentication.KerberosClient;
import org.springframework.security.kerberos.authentication.sun.SunJaasKerberosClient;

public class KerberosIdentityProvider
extends BasicAuthIdentityProvider {
    private static final Logger logger = LoggerFactory.getLogger(KerberosIdentityProvider.class);
    private static final String issuer = KerberosIdentityProvider.class.getSimpleName();
    private static final String default_expiration = "12 hours";
    private KerberosAuthenticationProvider provider;
    private String defaultRealm;
    private long expiration;

    public void onConfigured(IdentityProviderConfigurationContext configurationContext) throws SecurityProviderCreationException {
        String rawDebug = configurationContext.getProperty("Enable Debug");
        boolean enableDebug = rawDebug != null && rawDebug.equalsIgnoreCase("true");
        String rawExpiration = configurationContext.getProperty("Authentication Expiration");
        if (StringUtils.isBlank((CharSequence)rawExpiration)) {
            rawExpiration = default_expiration;
            logger.info("No Authentication Expiration specified, defaulting to 12 hours");
        }
        try {
            this.expiration = FormatUtils.getTimeDuration((String)rawExpiration, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        catch (IllegalArgumentException iae) {
            throw new SecurityProviderCreationException(String.format("The Expiration Duration '%s' is not a valid time duration", rawExpiration));
        }
        this.defaultRealm = configurationContext.getProperty("Default Realm");
        if (StringUtils.isNotBlank((CharSequence)this.defaultRealm) && this.defaultRealm.contains("@")) {
            throw new SecurityProviderCreationException(String.format("The Default Realm '%s' must not contain \"@\"", this.defaultRealm));
        }
        this.provider = new KerberosAuthenticationProvider();
        SunJaasKerberosClient client = new SunJaasKerberosClient();
        client.setDebug(enableDebug);
        this.provider.setKerberosClient((KerberosClient)client);
        this.provider.setUserDetailsService((UserDetailsService)new KerberosUserDetailsService());
    }

    public AuthenticationResponse authenticate(AuthenticationRequest authenticationRequest) throws InvalidCredentialsException, IdentityAccessException {
        if (this.provider == null) {
            throw new IdentityAccessException("The Kerberos authentication provider is not initialized.");
        }
        try {
            String identity;
            String rawPrincipal = authenticationRequest.getUsername();
            Object credentials = authenticationRequest.getCredentials();
            String parsedRealm = KerberosPrincipalParser.getRealm((String)rawPrincipal);
            boolean realmInRawPrincipal = StringUtils.isNotBlank((CharSequence)parsedRealm);
            if (realmInRawPrincipal) {
                identity = rawPrincipal;
                logger.debug("Realm was specified in principal {}, default realm was not added to the identity being authenticated", (Object)rawPrincipal);
            } else if (StringUtils.isNotBlank((CharSequence)this.defaultRealm)) {
                identity = StringUtils.joinWith((String)"@", (Object[])new Object[]{rawPrincipal, this.defaultRealm});
                logger.debug("Realm was not specified in principal {}, default realm {} was added to the identity being authenticated", (Object)rawPrincipal, (Object)this.defaultRealm);
            } else {
                identity = rawPrincipal;
                logger.debug("Realm was not specified in principal {}, default realm is blank and was not added to the identity being authenticated", (Object)rawPrincipal);
            }
            UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)identity, credentials);
            if (logger.isDebugEnabled()) {
                logger.debug("Created authentication token " + token.toString());
            }
            Authentication authentication = this.provider.authenticate((Authentication)token);
            if (logger.isDebugEnabled()) {
                logger.debug("Ran provider.authenticate(token) and returned authentication for principal={} with name={} and isAuthenticated={}", new Object[]{authentication.getPrincipal(), authentication.getName(), authentication.isAuthenticated()});
            }
            return new AuthenticationResponse(authentication.getName(), identity, this.expiration, issuer);
        }
        catch (AuthenticationException e) {
            throw new InvalidCredentialsException(e.getMessage(), (Throwable)e);
        }
    }

    public void preDestruction() throws SecurityProviderDestructionException {
    }
}

