/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.web.security.authentication.jwt;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.JwtException;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.SignatureException;
import io.jsonwebtoken.SigningKeyResolver;
import io.jsonwebtoken.UnsupportedJwtException;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.registry.security.authentication.AuthenticationResponse;
import org.apache.nifi.registry.security.key.Key;
import org.apache.nifi.registry.security.key.KeyService;
import org.apache.nifi.registry.web.security.authentication.exception.InvalidAuthenticationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class JwtService {
    private static final Logger logger = LoggerFactory.getLogger(JwtService.class);
    private static final SignatureAlgorithm SIGNATURE_ALGORITHM = SignatureAlgorithm.HS256;
    private static final String KEY_ID_CLAIM = "kid";
    private static final String USERNAME_CLAIM = "preferred_username";
    private static final Pattern tokenPattern = Pattern.compile("^Bearer (\\S*\\.\\S*\\.\\S*)$");
    public static final String AUTHORIZATION = "Authorization";
    private final KeyService keyService;

    @Autowired
    public JwtService(KeyService keyService) {
        this.keyService = keyService;
    }

    public String getAuthenticationFromToken(String base64EncodedToken) throws JwtException {
        try {
            Jws jws = this.parseTokenFromBase64EncodedString(base64EncodedToken);
            if (jws == null) {
                throw new JwtException("Unable to parse token");
            }
            if (StringUtils.isEmpty((CharSequence)((Claims)jws.getBody()).getSubject())) {
                throw new JwtException("No subject available in token");
            }
            if (StringUtils.isEmpty((CharSequence)((Claims)jws.getBody()).getIssuer())) {
                throw new JwtException("No issuer available in token");
            }
            return ((Claims)jws.getBody()).getSubject();
        }
        catch (JwtException e) {
            logger.debug("The Base64 encoded JWT: " + base64EncodedToken);
            String errorMessage = "There was an error validating the JWT";
            logger.error("There was an error validating the JWT", (Throwable)e);
            throw e;
        }
    }

    private Jws<Claims> parseTokenFromBase64EncodedString(String base64EncodedToken) throws JwtException {
        try {
            return Jwts.parser().setSigningKeyResolver((SigningKeyResolver)new /* Unavailable Anonymous Inner Class!! */).parseClaimsJws(base64EncodedToken);
        }
        catch (ExpiredJwtException | MalformedJwtException | SignatureException | UnsupportedJwtException | IllegalArgumentException e) {
            String errorMessage = "Unable to validate the access token.";
            throw new JwtException("Unable to validate the access token.", e);
        }
    }

    public String generateSignedToken(AuthenticationResponse authenticationResponse) throws JwtException {
        if (authenticationResponse == null) {
            throw new IllegalArgumentException("Cannot generate a JWT for a null authenticationResponse");
        }
        return this.generateSignedToken(authenticationResponse.getIdentity(), authenticationResponse.getUsername(), authenticationResponse.getIssuer(), authenticationResponse.getIssuer(), authenticationResponse.getExpiration());
    }

    public String generateSignedToken(String identity, String preferredUsername, String issuer, String audience, long expirationMillis) throws JwtException {
        if (identity == null || StringUtils.isEmpty((CharSequence)identity)) {
            String errorMessage = "Cannot generate a JWT for a token with an empty identity";
            errorMessage = issuer != null ? errorMessage + " issued by " + issuer + "." : ".";
            logger.error(errorMessage);
            throw new IllegalArgumentException(errorMessage);
        }
        Calendar now = Calendar.getInstance();
        long expirationMillisRelativeToNow = JwtService.validateTokenExpiration((long)expirationMillis, (String)identity);
        long expirationMillisSinceEpoch = now.getTimeInMillis() + expirationMillisRelativeToNow;
        Calendar expiration = new Calendar.Builder().setInstant(expirationMillisSinceEpoch).build();
        try {
            Key key = this.keyService.getOrCreateKey(identity);
            byte[] keyBytes = key.getKey().getBytes(StandardCharsets.UTF_8);
            return Jwts.builder().setSubject(identity).setIssuer(issuer).setAudience(audience).claim("preferred_username", (Object)preferredUsername).claim("kid", (Object)key.getId()).setIssuedAt(now.getTime()).setExpiration(expiration.getTime()).signWith(SIGNATURE_ALGORITHM, keyBytes).compact();
        }
        catch (NullPointerException e) {
            String errorMessage = "Could not retrieve the signing key for JWT for " + identity;
            logger.error(errorMessage, (Throwable)e);
            throw new JwtException(errorMessage, (Throwable)e);
        }
    }

    public void logOut(String userIdentity) {
        if (userIdentity == null || userIdentity.isEmpty()) {
            throw new JwtException("Log out failed: The user identity was not present in the request token to log out user.");
        }
        try {
            this.keyService.deleteKey(userIdentity);
            logger.info("Deleted token from database.");
        }
        catch (Exception e) {
            logger.error("Unable to log out user: " + userIdentity + ". Failed to remove their token from database.");
            throw e;
        }
    }

    private static long validateTokenExpiration(long proposedTokenExpiration, String identity) {
        long maxExpiration = TimeUnit.MILLISECONDS.convert(12L, TimeUnit.HOURS);
        long minExpiration = TimeUnit.MILLISECONDS.convert(1L, TimeUnit.MINUTES);
        if (proposedTokenExpiration > maxExpiration) {
            logger.warn(String.format("Max token expiration exceeded. Setting expiration to %s from %s for %s", maxExpiration, proposedTokenExpiration, identity));
            proposedTokenExpiration = maxExpiration;
        } else if (proposedTokenExpiration < minExpiration) {
            logger.warn(String.format("Min token expiration not met. Setting expiration to %s from %s for %s", minExpiration, proposedTokenExpiration, identity));
            proposedTokenExpiration = minExpiration;
        }
        return proposedTokenExpiration;
    }

    private static String describe(AuthenticationResponse authenticationResponse) {
        Calendar expirationTime = Calendar.getInstance();
        expirationTime.setTimeInMillis(authenticationResponse.getExpiration());
        long remainingTime = expirationTime.getTimeInMillis() - Calendar.getInstance().getTimeInMillis();
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss.SSS");
        dateFormat.setTimeZone(expirationTime.getTimeZone());
        String expirationTimeString = dateFormat.format(expirationTime.getTime());
        return "LoginAuthenticationToken for " + authenticationResponse.getUsername() + " issued by " + authenticationResponse.getIssuer() + " expiring at " + expirationTimeString + " [" + authenticationResponse.getExpiration() + " ms, " + remainingTime + " ms remaining]";
    }

    public void logOutUsingAuthHeader(String authorizationHeader) {
        String base64EncodedToken = JwtService.getTokenFromHeader((String)authorizationHeader);
        this.logOut(this.getAuthenticationFromToken(base64EncodedToken));
    }

    public static String getTokenFromHeader(String authenticationHeader) {
        Matcher matcher = tokenPattern.matcher(authenticationHeader);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        throw new InvalidAuthenticationException("JWT did not match expected pattern.");
    }

    static /* synthetic */ KeyService access$000(JwtService x0) {
        return x0.keyService;
    }
}

