/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.web.security;

import javax.servlet.ServletContext;
import org.apache.nifi.registry.security.crypto.CryptoKeyProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.context.ServletContextAware;

@Configuration
public class NiFiRegistryMasterKeyProviderFactory
implements ServletContextAware {
    private static final Logger logger = LoggerFactory.getLogger(NiFiRegistryMasterKeyProviderFactory.class);
    private CryptoKeyProvider masterKeyProvider = null;

    @Bean
    public CryptoKeyProvider getNiFiRegistryMasterKeyProvider() {
        return this.masterKeyProvider;
    }

    public void setServletContext(ServletContext servletContext) {
        Object rawKeyProviderObject = servletContext.getAttribute("nifi-registry.key");
        if (rawKeyProviderObject == null) {
            logger.warn("Value of {} was null. {} bean will not be available in Application Context, so any attempt to load protected property values may fail.", (Object)"nifi-registry.key", (Object)CryptoKeyProvider.class.getSimpleName());
            return;
        }
        if (!(rawKeyProviderObject instanceof CryptoKeyProvider)) {
            logger.warn("Expected value of {} to be of type {}, but instead got {}. {} bean will NOT be available in Application Context, so any attempt to load protected property values may fail.", new Object[]{"nifi-registry.key", CryptoKeyProvider.class.getName(), rawKeyProviderObject.getClass().getName(), CryptoKeyProvider.class.getSimpleName()});
            return;
        }
        logger.info("Updating Application Context with {} bean for obtaining NiFi Registry master key.", (Object)CryptoKeyProvider.class.getSimpleName());
        this.masterKeyProvider = (CryptoKeyProvider)rawKeyProviderObject;
    }
}

