/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.web.mapper;

import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationCredentialsNotFoundException;
import org.springframework.stereotype.Component;

@Component
@Provider
public class AuthenticationCredentialsNotFoundExceptionMapper
implements ExceptionMapper<AuthenticationCredentialsNotFoundException> {
    private static final Logger logger = LoggerFactory.getLogger(AuthenticationCredentialsNotFoundExceptionMapper.class);

    public Response toResponse(AuthenticationCredentialsNotFoundException exception) {
        logger.info(String.format("No valid credentials were found in the request: %s. Returning %s response.", exception, Response.Status.FORBIDDEN));
        if (logger.isDebugEnabled()) {
            logger.debug("", (Throwable)exception);
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"Access is denied.").type("text/plain").build();
    }
}

