/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.web.api;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import io.swagger.annotations.Extension;
import io.swagger.annotations.ExtensionProperty;
import java.net.URI;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.nifi.registry.authorization.User;
import org.apache.nifi.registry.authorization.UserGroup;
import org.apache.nifi.registry.event.EventFactory;
import org.apache.nifi.registry.event.EventService;
import org.apache.nifi.registry.revision.entity.RevisionInfo;
import org.apache.nifi.registry.revision.web.ClientIdParameter;
import org.apache.nifi.registry.revision.web.LongParameter;
import org.apache.nifi.registry.web.api.ApplicationResource;
import org.apache.nifi.registry.web.service.ServiceFacade;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Path(value="tenants")
@Api(value="tenants", description="Endpoint for managing users and user groups.", authorizations={@Authorization(value="Authorization")})
public class TenantResource
extends ApplicationResource {
    @Autowired
    public TenantResource(ServiceFacade serviceFacade, EventService eventService) {
        super(serviceFacade, eventService);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="users")
    @ApiOperation(value="Create user", notes="\n\nNOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.", response=User.class, extensions={@Extension(name="access-policy", properties={@ExtensionProperty(name="action", value="write"), @ExtensionProperty(name="resource", value="/tenants")})})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi Registry was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="NiFi Registry was unable to complete the request because it assumes a server state that is not valid.")})
    public Response createUser(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The user configuration details.", required=true) User requestUser) {
        User createdUser = this.serviceFacade.createUser(requestUser);
        this.publish(EventFactory.userCreated((User)createdUser));
        String locationUri = this.generateUserUri(createdUser);
        return this.generateCreatedResponse(URI.create(locationUri), (Object)createdUser).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="users")
    @ApiOperation(value="Get all users", notes="\n\nNOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.", response=User.class, responseContainer="List", extensions={@Extension(name="access-policy", properties={@ExtensionProperty(name="action", value="read"), @ExtensionProperty(name="resource", value="/tenants")})})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi Registry was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=409, message="NiFi Registry was unable to complete the request because it assumes a server state that is not valid.")})
    public Response getUsers() {
        List users = this.serviceFacade.getUsers();
        return this.generateOkResponse((Object)users).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="users/{id}")
    @ApiOperation(value="Get user", notes="\n\nNOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.", response=User.class, extensions={@Extension(name="access-policy", properties={@ExtensionProperty(name="action", value="read"), @ExtensionProperty(name="resource", value="/tenants")})})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi Registry was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="NiFi Registry was unable to complete the request because it assumes a server state that is not valid.")})
    public Response getUser(@ApiParam(value="The user id.", required=true) @PathParam(value="id") String identifier) {
        User user = this.serviceFacade.getUser(identifier);
        return this.generateOkResponse((Object)user).build();
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="users/{id}")
    @ApiOperation(value="Update user", notes="\n\nNOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.", response=User.class, extensions={@Extension(name="access-policy", properties={@ExtensionProperty(name="action", value="write"), @ExtensionProperty(name="resource", value="/tenants")})})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi Registry was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="NiFi Registry was unable to complete the request because it assumes a server state that is not valid.")})
    public Response updateUser(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The user id.", required=true) @PathParam(value="id") String identifier, @ApiParam(value="The user configuration details.", required=true) User requestUser) {
        if (requestUser == null) {
            throw new IllegalArgumentException("User details must be specified when updating a user.");
        }
        if (!identifier.equals(requestUser.getIdentifier())) {
            throw new IllegalArgumentException(String.format("The user id in the request body (%s) does not equal the user id of the requested resource (%s).", requestUser.getIdentifier(), identifier));
        }
        User updatedUser = this.serviceFacade.updateUser(requestUser);
        this.publish(EventFactory.userUpdated((User)updatedUser));
        return this.generateOkResponse((Object)updatedUser).build();
    }

    @DELETE
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="users/{id}")
    @ApiOperation(value="Delete user", notes="\n\nNOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.", response=User.class, extensions={@Extension(name="access-policy", properties={@ExtensionProperty(name="action", value="delete"), @ExtensionProperty(name="resource", value="/tenants")})})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi Registry was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="NiFi Registry was unable to complete the request because it assumes a server state that is not valid.")})
    public Response removeUser(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The version is used to verify the client is working with the latest version of the entity.", required=true) @QueryParam(value="version") LongParameter version, @ApiParam(value="If the client id is not specified, new one will be generated. This value (whether specified or generated) is included in the response.") @QueryParam(value="clientId") @DefaultValue(value="") ClientIdParameter clientId, @ApiParam(value="The user id.", required=true) @PathParam(value="id") String identifier) {
        RevisionInfo revisionInfo = this.getRevisionInfo(version, clientId);
        User user = this.serviceFacade.deleteUser(identifier, revisionInfo);
        this.publish(EventFactory.userDeleted((User)user));
        return this.generateOkResponse((Object)user).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="user-groups")
    @ApiOperation(value="Create user group", notes="\n\nNOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.", response=UserGroup.class, extensions={@Extension(name="access-policy", properties={@ExtensionProperty(name="action", value="write"), @ExtensionProperty(name="resource", value="/tenants")})})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi Registry was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="NiFi Registry was unable to complete the request because it assumes a server state that is not valid.")})
    public Response createUserGroup(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The user group configuration details.", required=true) UserGroup requestUserGroup) {
        UserGroup createdGroup = this.serviceFacade.createUserGroup(requestUserGroup);
        this.publish(EventFactory.userGroupCreated((UserGroup)createdGroup));
        String locationUri = this.generateUserGroupUri(createdGroup);
        return this.generateCreatedResponse(URI.create(locationUri), (Object)createdGroup).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="user-groups")
    @ApiOperation(value="Get user groups", notes="\n\nNOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.", response=UserGroup.class, responseContainer="List", extensions={@Extension(name="access-policy", properties={@ExtensionProperty(name="action", value="read"), @ExtensionProperty(name="resource", value="/tenants")})})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi Registry was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="NiFi Registry was unable to complete the request because it assumes a server state that is not valid.")})
    public Response getUserGroups() {
        List userGroups = this.serviceFacade.getUserGroups();
        return this.generateOkResponse((Object)userGroups).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="user-groups/{id}")
    @ApiOperation(value="Get user group", notes="\n\nNOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.", response=UserGroup.class, extensions={@Extension(name="access-policy", properties={@ExtensionProperty(name="action", value="read"), @ExtensionProperty(name="resource", value="/tenants")})})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi Registry was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="NiFi Registry was unable to complete the request because it assumes a server state that is not valid.")})
    public Response getUserGroup(@ApiParam(value="The user group id.", required=true) @PathParam(value="id") String identifier) {
        UserGroup userGroup = this.serviceFacade.getUserGroup(identifier);
        return this.generateOkResponse((Object)userGroup).build();
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="user-groups/{id}")
    @ApiOperation(value="Update user group", notes="\n\nNOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.", response=UserGroup.class, extensions={@Extension(name="access-policy", properties={@ExtensionProperty(name="action", value="write"), @ExtensionProperty(name="resource", value="/tenants")})})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi Registry was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="NiFi Registry was unable to complete the request because it assumes a server state that is not valid.")})
    public Response updateUserGroup(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The user group id.", required=true) @PathParam(value="id") String identifier, @ApiParam(value="The user group configuration details.", required=true) UserGroup requestUserGroup) {
        if (requestUserGroup == null) {
            throw new IllegalArgumentException("User group details must be specified to update a user group.");
        }
        if (!identifier.equals(requestUserGroup.getIdentifier())) {
            throw new IllegalArgumentException(String.format("The user group id in the request body (%s) does not equal the user group id of the requested resource (%s).", requestUserGroup.getIdentifier(), identifier));
        }
        UserGroup updatedUserGroup = this.serviceFacade.updateUserGroup(requestUserGroup);
        this.publish(EventFactory.userGroupUpdated((UserGroup)updatedUserGroup));
        return this.generateOkResponse((Object)updatedUserGroup).build();
    }

    @DELETE
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="user-groups/{id}")
    @ApiOperation(value="Delete user group", notes="\n\nNOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.", response=UserGroup.class, extensions={@Extension(name="access-policy", properties={@ExtensionProperty(name="action", value="delete"), @ExtensionProperty(name="resource", value="/tenants")})})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi Registry was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="NiFi Registry was unable to complete the request because it assumes a server state that is not valid.")})
    public Response removeUserGroup(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The version is used to verify the client is working with the latest version of the entity.", required=true) @QueryParam(value="version") LongParameter version, @ApiParam(value="If the client id is not specified, new one will be generated. This value (whether specified or generated) is included in the response.") @QueryParam(value="clientId") @DefaultValue(value="") ClientIdParameter clientId, @ApiParam(value="The user group id.", required=true) @PathParam(value="id") String identifier) {
        RevisionInfo revisionInfo = this.getRevisionInfo(version, clientId);
        UserGroup userGroup = this.serviceFacade.deleteUserGroup(identifier, revisionInfo);
        this.publish(EventFactory.userGroupDeleted((UserGroup)userGroup));
        return this.generateOkResponse((Object)userGroup).build();
    }

    private String generateUserUri(User user) {
        return this.generateResourceUri(new String[]{"tenants", "users", user.getIdentifier()});
    }

    private String generateUserGroupUri(UserGroup userGroup) {
        return this.generateResourceUri(new String[]{"tenants", "user-groups", userGroup.getIdentifier()});
    }
}

