/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.web.api;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import io.swagger.annotations.Extension;
import io.swagger.annotations.ExtensionProperty;
import java.util.Set;
import java.util.SortedSet;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.nifi.registry.event.EventService;
import org.apache.nifi.registry.field.Fields;
import org.apache.nifi.registry.flow.VersionedFlow;
import org.apache.nifi.registry.flow.VersionedFlowSnapshot;
import org.apache.nifi.registry.flow.VersionedFlowSnapshotMetadata;
import org.apache.nifi.registry.web.api.ApplicationResource;
import org.apache.nifi.registry.web.service.ServiceFacade;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Path(value="/flows")
@Api(value="flows", description="Gets metadata about flows.", authorizations={@Authorization(value="Authorization")})
public class FlowResource
extends ApplicationResource {
    @Autowired
    public FlowResource(ServiceFacade serviceFacade, EventService eventService) {
        super(serviceFacade, eventService);
    }

    @GET
    @Path(value="fields")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Get flow fields", notes="Retrieves the flow field names that can be used for searching or sorting on flows.", response=Fields.class)
    public Response getAvailableFlowFields() {
        Set flowFields = this.serviceFacade.getFlowFields();
        Fields fields = new Fields(flowFields);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)fields).build();
    }

    @GET
    @Path(value="{flowId}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Get flow", notes="Gets a flow by id.", nickname="globalGetFlow", response=VersionedFlow.class, extensions={@Extension(name="access-policy", properties={@ExtensionProperty(name="action", value="read"), @ExtensionProperty(name="resource", value="/buckets/{bucketId}")})})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi Registry was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="NiFi Registry was unable to complete the request because it assumes a server state that is not valid.")})
    public Response getFlow(@PathParam(value="flowId") @ApiParam(value="The flow identifier") String flowId) {
        VersionedFlow flow = this.serviceFacade.getFlow(flowId);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)flow).build();
    }

    @GET
    @Path(value="{flowId}/versions")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Get flow versions", notes="Gets summary information for all versions of a given flow. Versions are ordered newest->oldest.", nickname="globalGetFlowVersions", response=VersionedFlowSnapshotMetadata.class, responseContainer="List", extensions={@Extension(name="access-policy", properties={@ExtensionProperty(name="action", value="read"), @ExtensionProperty(name="resource", value="/buckets/{bucketId}")})})
    @ApiResponses(value={@ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="NiFi Registry was unable to complete the request because it assumes a server state that is not valid.")})
    public Response getFlowVersions(@PathParam(value="flowId") @ApiParam(value="The flow identifier") String flowId) {
        SortedSet snapshots = this.serviceFacade.getFlowSnapshots(flowId);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)snapshots).build();
    }

    @GET
    @Path(value="{flowId}/versions/{versionNumber: \\d+}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Get flow version", notes="Gets the given version of a flow, including metadata and flow content.", nickname="globalGetFlowVersion", response=VersionedFlowSnapshot.class, extensions={@Extension(name="access-policy", properties={@ExtensionProperty(name="action", value="read"), @ExtensionProperty(name="resource", value="/buckets/{bucketId}")})})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi Registry was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="NiFi Registry was unable to complete the request because it assumes a server state that is not valid.")})
    public Response getFlowVersion(@PathParam(value="flowId") @ApiParam(value="The flow identifier") String flowId, @PathParam(value="versionNumber") @ApiParam(value="The version number") Integer versionNumber) {
        VersionedFlowSnapshot snapshot = this.serviceFacade.getFlowSnapshot(flowId, versionNumber);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)snapshot).build();
    }

    @GET
    @Path(value="{flowId}/versions/latest")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Get latest flow version", notes="Gets the latest version of a flow, including metadata and flow content.", nickname="globalGetLatestFlowVersion", response=VersionedFlowSnapshot.class, extensions={@Extension(name="access-policy", properties={@ExtensionProperty(name="action", value="read"), @ExtensionProperty(name="resource", value="/buckets/{bucketId}")})})
    @ApiResponses(value={@ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="NiFi Registry was unable to complete the request because it assumes a server state that is not valid.")})
    public Response getLatestFlowVersion(@PathParam(value="flowId") @ApiParam(value="The flow identifier") String flowId) {
        VersionedFlowSnapshot lastSnapshot = this.serviceFacade.getLatestFlowSnapshot(flowId);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)lastSnapshot).build();
    }

    @GET
    @Path(value="{flowId}/versions/latest/metadata")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Get latest flow version metadata", notes="Gets the metadata for the latest version of a flow.", nickname="globalGetLatestFlowVersionMetadata", response=VersionedFlowSnapshotMetadata.class, extensions={@Extension(name="access-policy", properties={@ExtensionProperty(name="action", value="read"), @ExtensionProperty(name="resource", value="/buckets/{bucketId}")})})
    @ApiResponses(value={@ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="NiFi Registry was unable to complete the request because it assumes a server state that is not valid.")})
    public Response getLatestFlowVersionMetadata(@PathParam(value="flowId") @ApiParam(value="The flow identifier") String flowId) {
        VersionedFlowSnapshotMetadata latestMetadata = this.serviceFacade.getLatestFlowSnapshotMetadata(flowId);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)latestMetadata).build();
    }
}

