/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.web.api;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.Collections;
import java.util.Set;
import java.util.SortedSet;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.nifi.extension.ExtensionFilterParams;
import org.apache.nifi.extension.ExtensionMetadataContainer;
import org.apache.nifi.extension.TagCount;
import org.apache.nifi.extension.manifest.ExtensionType;
import org.apache.nifi.extension.manifest.ProvidedServiceAPI;
import org.apache.nifi.registry.event.EventService;
import org.apache.nifi.registry.extension.bundle.BundleType;
import org.apache.nifi.registry.web.api.ApplicationResource;
import org.apache.nifi.registry.web.service.ServiceFacade;
import org.springframework.stereotype.Component;

@Component
@Path(value="/extensions")
@Api(value="extensions", description="Find and retrieve extensions. ", authorizations={@Authorization(value="Authorization")})
public class ExtensionResource
extends ApplicationResource {
    public ExtensionResource(ServiceFacade serviceFacade, EventService eventService) {
        super(serviceFacade, eventService);
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Get all extensions", notes="Gets the metadata for all extensions that match the filter params and are part of bundles located in buckets the current user is authorized for. If the user is not authorized to any buckets, an empty result set will be returned.\n\nNOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.", response=ExtensionMetadataContainer.class)
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi Registry was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="NiFi Registry was unable to complete the request because it assumes a server state that is not valid.")})
    public Response getExtensions(@QueryParam(value="bundleType") @ApiParam(value="The type of bundles to return", allowableValues="nifi-nar, minifi-cpp") BundleType bundleType, @QueryParam(value="extensionType") @ApiParam(value="The type of extensions to return") ExtensionType extensionType, @QueryParam(value="tag") @ApiParam(value="The tags to filter on, will be used in an OR statement") Set<String> tags) {
        ExtensionFilterParams filterParams = new ExtensionFilterParams.Builder().bundleType(bundleType).extensionType(extensionType).addTags(tags == null ? Collections.emptyList() : tags).build();
        SortedSet extensionMetadata = this.serviceFacade.getExtensionMetadata(filterParams);
        ExtensionMetadataContainer container = new ExtensionMetadataContainer();
        container.setExtensions(extensionMetadata);
        container.setNumResults(extensionMetadata.size());
        container.setFilterParams(filterParams);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)container).build();
    }

    @GET
    @Path(value="provided-service-api")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Get extensions providing service API", notes="Gets the metadata for extensions that provide the specified API and are part of bundles located in buckets the current user is authorized for. If the user is not authorized to any buckets, an empty result set will be returned.\n\nNOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.", response=ExtensionMetadataContainer.class)
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi Registry was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="NiFi Registry was unable to complete the request because it assumes a server state that is not valid.")})
    public Response getExtensionsProvidingServiceAPI(@QueryParam(value="className") @ApiParam(value="The name of the service API class", required=true) String className, @QueryParam(value="groupId") @ApiParam(value="The groupId of the bundle containing the service API class", required=true) String groupId, @QueryParam(value="artifactId") @ApiParam(value="The artifactId of the bundle containing the service API class", required=true) String artifactId, @QueryParam(value="version") @ApiParam(value="The version of the bundle containing the service API class", required=true) String version) {
        ProvidedServiceAPI serviceAPI = new ProvidedServiceAPI();
        serviceAPI.setClassName(className);
        serviceAPI.setGroupId(groupId);
        serviceAPI.setArtifactId(artifactId);
        serviceAPI.setVersion(version);
        SortedSet extensionMetadata = this.serviceFacade.getExtensionMetadata(serviceAPI);
        ExtensionMetadataContainer container = new ExtensionMetadataContainer();
        container.setExtensions(extensionMetadata);
        container.setNumResults(extensionMetadata.size());
        return Response.status((Response.Status)Response.Status.OK).entity((Object)container).build();
    }

    @GET
    @Path(value="/tags")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Get extension tags", notes="Gets all the extension tags known to this NiFi Registry instance, along with the number of extensions that have the given tag.\n\nNOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.", response=TagCount.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi Registry was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="NiFi Registry was unable to complete the request because it assumes a server state that is not valid.")})
    public Response getTags() {
        SortedSet tags = this.serviceFacade.getExtensionTags();
        return Response.status((Response.Status)Response.Status.OK).entity((Object)tags).build();
    }
}

