/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.web.api;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import io.swagger.annotations.Extension;
import io.swagger.annotations.ExtensionProperty;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.nifi.registry.event.EventFactory;
import org.apache.nifi.registry.event.EventService;
import org.apache.nifi.registry.extension.bundle.Bundle;
import org.apache.nifi.registry.extension.bundle.BundleType;
import org.apache.nifi.registry.extension.bundle.BundleVersion;
import org.apache.nifi.registry.web.api.ApplicationResource;
import org.apache.nifi.registry.web.service.ServiceFacade;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Path(value="/buckets/{bucketId}/bundles")
@Api(value="bucket bundles", description="Create extension bundles scoped to an existing bucket in the registry. ", authorizations={@Authorization(value="Authorization")})
public class BucketBundleResource
extends ApplicationResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(BucketBundleResource.class);

    @Autowired
    public BucketBundleResource(ServiceFacade serviceFacade, EventService eventService) {
        super(serviceFacade, eventService);
    }

    @POST
    @Path(value="{bundleType}")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Create extension bundle version", notes="Creates a version of an extension bundle by uploading a binary artifact. If an extension bundle already exists in the given bucket with the same group id and artifact id as that of the bundle being uploaded, then it will be added as a new version to the existing bundle. If an extension bundle does not already exist in the given bucket with the same group id and artifact id, then a new extension bundle will be created and this version will be added to the new bundle. Client's may optionally supply a SHA-256 in hex format through the multi-part form field 'sha256'. If supplied, then this value will be compared against the SHA-256 computed by the server, and the bundle will be rejected if the values do not match. If not supplied, the bundle will be accepted, but will be marked to indicate that the client did not supply a SHA-256 during creation. \n\nNOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.", response=BundleVersion.class, extensions={@Extension(name="access-policy", properties={@ExtensionProperty(name="action", value="write"), @ExtensionProperty(name="resource", value="/buckets/{bucketId}")})})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi Registry was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="NiFi Registry was unable to complete the request because it assumes a server state that is not valid.")})
    public Response createExtensionBundleVersion(@PathParam(value="bucketId") @ApiParam(value="The bucket identifier", required=true) String bucketId, @PathParam(value="bundleType") @ApiParam(value="The type of the bundle", required=true, allowableValues="nifi-nar, minifi-cpp") BundleType bundleType, @FormDataParam(value="file") InputStream fileInputStream, @FormDataParam(value="file") FormDataContentDisposition fileMetaData, @FormDataParam(value="sha256") String clientSha256) throws IOException {
        LOGGER.debug("Creating extension bundle version for bundle type {}", new Object[]{bundleType});
        BundleVersion createdBundleVersion = this.serviceFacade.createBundleVersion(bucketId, bundleType, fileInputStream, clientSha256);
        this.publish(EventFactory.extensionBundleCreated((Bundle)createdBundleVersion.getBundle()));
        this.publish(EventFactory.extensionBundleVersionCreated((BundleVersion)createdBundleVersion));
        return Response.status((Response.Status)Response.Status.OK).entity((Object)createdBundleVersion).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Get extension bundles by bucket", notes="\n\nNOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.", response=Bundle.class, responseContainer="List", extensions={@Extension(name="access-policy", properties={@ExtensionProperty(name="action", value="read"), @ExtensionProperty(name="resource", value="/buckets/{bucketId}")})})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi Registry was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="NiFi Registry was unable to complete the request because it assumes a server state that is not valid.")})
    public Response getExtensionBundles(@PathParam(value="bucketId") @ApiParam(value="The bucket identifier", required=true) String bucketId) {
        List bundles = this.serviceFacade.getBundlesByBucket(bucketId);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)bundles).build();
    }
}

