/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.web.api;

import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriBuilderException;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.nifi.registry.event.EventService;
import org.apache.nifi.registry.hook.Event;
import org.apache.nifi.registry.revision.entity.RevisionInfo;
import org.apache.nifi.registry.revision.web.ClientIdParameter;
import org.apache.nifi.registry.revision.web.LongParameter;
import org.apache.nifi.registry.web.service.ServiceFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationResource {
    public static final String CLIENT_ID = "clientId";
    public static final String VERSION = "version";
    public static final String PROXY_SCHEME_HTTP_HEADER = "X-ProxyScheme";
    public static final String PROXY_HOST_HTTP_HEADER = "X-ProxyHost";
    public static final String PROXY_PORT_HTTP_HEADER = "X-ProxyPort";
    public static final String PROXY_CONTEXT_PATH_HTTP_HEADER = "X-ProxyContextPath";
    public static final String FORWARDED_PROTO_HTTP_HEADER = "X-Forwarded-Proto";
    public static final String FORWARDED_HOST_HTTP_HEADER = "X-Forwarded-Server";
    public static final String FORWARDED_PORT_HTTP_HEADER = "X-Forwarded-Port";
    public static final String FORWARDED_CONTEXT_HTTP_HEADER = "X-Forwarded-Context";
    public static final String NON_GUARANTEED_ENDPOINT = "\n\nNOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.";
    private static final Logger logger = LoggerFactory.getLogger(ApplicationResource.class);
    @Context
    private HttpServletRequest httpServletRequest;
    @Context
    private UriInfo uriInfo;
    protected final ServiceFacade serviceFacade;
    private final EventService eventService;

    public ApplicationResource(ServiceFacade serviceFacade, EventService eventService) {
        this.serviceFacade = serviceFacade;
        this.eventService = eventService;
        Validate.notNull((Object)this.serviceFacade);
        Validate.notNull((Object)this.eventService);
    }

    protected void publish(Event event) {
        try {
            this.eventService.publish(event);
        }
        catch (Throwable t) {
            logger.error("Unable to publish event: " + t.getMessage(), t);
        }
    }

    protected URI getBaseUri() {
        UriBuilder uriBuilder = this.uriInfo.getBaseUriBuilder();
        URI uri = uriBuilder.build(new Object[0]);
        try {
            String scheme = this.getFirstHeaderValue(new String[]{PROXY_SCHEME_HTTP_HEADER, FORWARDED_PROTO_HTTP_HEADER});
            String host = this.getFirstHeaderValue(new String[]{PROXY_HOST_HTTP_HEADER, FORWARDED_HOST_HTTP_HEADER});
            String port = this.getFirstHeaderValue(new String[]{PROXY_PORT_HTTP_HEADER, FORWARDED_PORT_HTTP_HEADER});
            String baseContextPath = this.getFirstHeaderValue(new String[]{PROXY_CONTEXT_PATH_HTTP_HEADER, FORWARDED_CONTEXT_HTTP_HEADER});
            String resourcePath = uri.getPath();
            if (baseContextPath != null) {
                if (!baseContextPath.startsWith("/")) {
                    baseContextPath = "/" + baseContextPath;
                }
                if (baseContextPath.endsWith("/")) {
                    baseContextPath = StringUtils.substringBeforeLast((String)baseContextPath, (String)"/");
                }
                resourcePath = baseContextPath + resourcePath;
            }
            int uriPort = uri.getPort();
            if (port != null) {
                if (StringUtils.isWhitespace((CharSequence)port)) {
                    uriPort = -1;
                } else {
                    try {
                        uriPort = Integer.parseInt(port);
                    }
                    catch (NumberFormatException nfe) {
                        logger.warn(String.format("Unable to parse proxy port HTTP header '%s'. Using port from request URI '%s'.", port, uriPort));
                    }
                }
            }
            uri = new URI(StringUtils.isBlank((CharSequence)scheme) ? uri.getScheme() : scheme, uri.getUserInfo(), StringUtils.isBlank((CharSequence)host) ? uri.getHost() : host, uriPort, resourcePath, uri.getQuery(), uri.getFragment());
        }
        catch (URISyntaxException use) {
            throw new UriBuilderException((Throwable)use);
        }
        return uri;
    }

    protected String generateResourceUri(String ... path) {
        URI baseUri = this.getBaseUri();
        URI fullUri = UriBuilder.fromUri((URI)baseUri).segment(path).build(new Object[0]);
        return fullUri.toString();
    }

    protected Response.ResponseBuilder noCache(Response.ResponseBuilder response) {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setPrivate(true);
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        return response.cacheControl(cacheControl);
    }

    protected Response.ResponseBuilder generateOkResponse(Object entity) {
        Response.ResponseBuilder response = Response.ok((Object)entity);
        return this.noCache(response);
    }

    protected Response.ResponseBuilder generateOkResponse() {
        return this.noCache(Response.ok());
    }

    protected Response.ResponseBuilder generateCreatedResponse(URI uri, Object entity) {
        return Response.created((URI)uri).entity(entity);
    }

    private String getFirstHeaderValue(String ... keys) {
        if (keys == null) {
            return null;
        }
        for (String key : keys) {
            String value = this.httpServletRequest.getHeader(key);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    protected RevisionInfo getRevisionInfo(LongParameter version, ClientIdParameter clientId) {
        RevisionInfo revisionInfo = new RevisionInfo();
        revisionInfo.setVersion(version == null ? null : version.getLong());
        revisionInfo.setClientId(clientId.getClientId());
        return revisionInfo;
    }
}

