/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.web.api;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import io.swagger.annotations.Extension;
import io.swagger.annotations.ExtensionProperty;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.nifi.registry.authorization.AccessPolicy;
import org.apache.nifi.registry.authorization.AccessPolicySummary;
import org.apache.nifi.registry.authorization.Resource;
import org.apache.nifi.registry.event.EventService;
import org.apache.nifi.registry.revision.entity.RevisionInfo;
import org.apache.nifi.registry.revision.web.ClientIdParameter;
import org.apache.nifi.registry.revision.web.LongParameter;
import org.apache.nifi.registry.security.authorization.RequestAction;
import org.apache.nifi.registry.web.api.ApplicationResource;
import org.apache.nifi.registry.web.service.ServiceFacade;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Path(value="/policies")
@Api(value="policies", description="Endpoint for managing access policies.", authorizations={@Authorization(value="Authorization")})
public class AccessPolicyResource
extends ApplicationResource {
    @Autowired
    public AccessPolicyResource(ServiceFacade serviceFacade, EventService eventService) {
        super(serviceFacade, eventService);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Create access policy", response=AccessPolicy.class, extensions={@Extension(name="access-policy", properties={@ExtensionProperty(name="action", value="write"), @ExtensionProperty(name="resource", value="/policies")})})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi Registry was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=409, message="NiFi Registry was unable to complete the request because it assumes a server state that is not valid. The NiFi Registry might not be configured to use a ConfigurableAccessPolicyProvider.")})
    public Response createAccessPolicy(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The access policy configuration details.", required=true) AccessPolicy requestAccessPolicy) {
        AccessPolicy createdPolicy = this.serviceFacade.createAccessPolicy(requestAccessPolicy);
        String locationUri = this.generateAccessPolicyUri((AccessPolicySummary)createdPolicy);
        return this.generateCreatedResponse(URI.create(locationUri), (Object)createdPolicy).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Get all access policies", response=AccessPolicy.class, responseContainer="List", extensions={@Extension(name="access-policy", properties={@ExtensionProperty(name="action", value="read"), @ExtensionProperty(name="resource", value="/policies")})})
    @ApiResponses(value={@ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=409, message="NiFi Registry was unable to complete the request because it assumes a server state that is not valid.")})
    public Response getAccessPolicies() {
        List accessPolicies = this.serviceFacade.getAccessPolicies();
        if (accessPolicies == null) {
            accessPolicies = Collections.emptyList();
        }
        return this.generateOkResponse(accessPolicies).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}")
    @ApiOperation(value="Get access policy", response=AccessPolicy.class, extensions={@Extension(name="access-policy", properties={@ExtensionProperty(name="action", value="read"), @ExtensionProperty(name="resource", value="/policies")})})
    @ApiResponses(value={@ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="NiFi Registry was unable to complete the request because it assumes a server state that is not valid.")})
    public Response getAccessPolicy(@ApiParam(value="The access policy id.", required=true) @PathParam(value="id") String identifier) {
        AccessPolicy accessPolicy = this.serviceFacade.getAccessPolicy(identifier);
        return this.generateOkResponse((Object)accessPolicy).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{action}/{resource: .+}")
    @ApiOperation(value="Get access policy for resource", notes="Gets an access policy for the specified action and resource", response=AccessPolicy.class, extensions={@Extension(name="access-policy", properties={@ExtensionProperty(name="action", value="read"), @ExtensionProperty(name="resource", value="/policies")})})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi Registry was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="NiFi Registry was unable to complete the request because it assumes a server state that is not valid.")})
    public Response getAccessPolicyForResource(@ApiParam(value="The request action.", allowableValues="read, write, delete", required=true) @PathParam(value="action") String action, @ApiParam(value="The resource of the policy.", required=true) @PathParam(value="resource") String rawResource) {
        RequestAction requestAction = RequestAction.valueOfValue((String)action);
        String resource = "/" + rawResource;
        AccessPolicy accessPolicy = this.serviceFacade.getAccessPolicy(resource, requestAction);
        return this.generateOkResponse((Object)accessPolicy).build();
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="{id}")
    @ApiOperation(value="Update access policy", response=AccessPolicy.class, extensions={@Extension(name="access-policy", properties={@ExtensionProperty(name="action", value="write"), @ExtensionProperty(name="resource", value="/policies")})})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi Registry was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="NiFi Registry was unable to complete the request because it assumes a server state that is not valid. The NiFi Registry might not be configured to use a ConfigurableAccessPolicyProvider.")})
    public Response updateAccessPolicy(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The access policy id.", required=true) @PathParam(value="id") String identifier, @ApiParam(value="The access policy configuration details.", required=true) AccessPolicy requestAccessPolicy) {
        if (requestAccessPolicy == null) {
            throw new IllegalArgumentException("Access policy details must be specified when updating a policy.");
        }
        if (!identifier.equals(requestAccessPolicy.getIdentifier())) {
            throw new IllegalArgumentException(String.format("The policy id in the request body (%s) does not equal the policy id of the requested resource (%s).", requestAccessPolicy.getIdentifier(), identifier));
        }
        AccessPolicy createdPolicy = this.serviceFacade.updateAccessPolicy(requestAccessPolicy);
        return this.generateOkResponse((Object)createdPolicy).build();
    }

    @DELETE
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}")
    @ApiOperation(value="Delete access policy", response=AccessPolicy.class, extensions={@Extension(name="access-policy", properties={@ExtensionProperty(name="action", value="delete"), @ExtensionProperty(name="resource", value="/policies")})})
    @ApiResponses(value={@ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="NiFi Registry was unable to complete the request because it assumes a server state that is not valid. The NiFi Registry might not be configured to use a ConfigurableAccessPolicyProvider.")})
    public Response removeAccessPolicy(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The version is used to verify the client is working with the latest version of the entity.", required=true) @QueryParam(value="version") LongParameter version, @ApiParam(value="If the client id is not specified, new one will be generated. This value (whether specified or generated) is included in the response.") @QueryParam(value="clientId") @DefaultValue(value="") ClientIdParameter clientId, @ApiParam(value="The access policy id.", required=true) @PathParam(value="id") String identifier) {
        RevisionInfo revisionInfo = this.getRevisionInfo(version, clientId);
        AccessPolicy deletedPolicy = this.serviceFacade.deleteAccessPolicy(identifier, revisionInfo);
        return this.generateOkResponse((Object)deletedPolicy).build();
    }

    @GET
    @Path(value="/resources")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Get available resources", notes="Gets the available resources that support access/authorization policies", response=Resource.class, responseContainer="List", extensions={@Extension(name="access-policy", properties={@ExtensionProperty(name="action", value="read"), @ExtensionProperty(name="resource", value="/policies")})})
    @ApiResponses(value={@ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request.")})
    public Response getResources() {
        List resources = this.serviceFacade.getResources();
        return this.generateOkResponse((Object)resources).build();
    }

    private String generateAccessPolicyUri(AccessPolicySummary accessPolicy) {
        return this.generateResourceUri(new String[]{"policies", accessPolicy.getIdentifier()});
    }
}

