/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.security.ldap;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.registry.security.authentication.AuthenticationRequest;
import org.apache.nifi.registry.security.authentication.AuthenticationResponse;
import org.apache.nifi.registry.security.authentication.BasicAuthIdentityProvider;
import org.apache.nifi.registry.security.authentication.IdentityProvider;
import org.apache.nifi.registry.security.authentication.IdentityProviderConfigurationContext;
import org.apache.nifi.registry.security.authentication.exception.IdentityAccessException;
import org.apache.nifi.registry.security.authentication.exception.InvalidCredentialsException;
import org.apache.nifi.registry.security.exception.SecurityProviderCreationException;
import org.apache.nifi.registry.security.exception.SecurityProviderDestructionException;
import org.apache.nifi.registry.security.ldap.IdentityStrategy;
import org.apache.nifi.registry.security.ldap.LdapAuthenticationStrategy;
import org.apache.nifi.registry.security.ldap.LdapsSocketFactory;
import org.apache.nifi.registry.security.ldap.ReferralStrategy;
import org.apache.nifi.registry.util.FormatUtils;
import org.apache.nifi.security.ssl.StandardKeyStoreBuilder;
import org.apache.nifi.security.ssl.StandardSslContextBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ldap.AuthenticationException;
import org.springframework.ldap.core.support.BaseLdapPathContextSource;
import org.springframework.ldap.core.support.DefaultTlsDirContextAuthenticationStrategy;
import org.springframework.ldap.core.support.DirContextAuthenticationStrategy;
import org.springframework.ldap.core.support.LdapContextSource;
import org.springframework.ldap.core.support.SimpleDirContextAuthenticationStrategy;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.ldap.authentication.AbstractLdapAuthenticationProvider;
import org.springframework.security.ldap.authentication.BindAuthenticator;
import org.springframework.security.ldap.authentication.LdapAuthenticationProvider;
import org.springframework.security.ldap.authentication.LdapAuthenticator;
import org.springframework.security.ldap.search.FilterBasedLdapUserSearch;
import org.springframework.security.ldap.search.LdapUserSearch;
import org.springframework.security.ldap.userdetails.LdapUserDetails;

public class LdapIdentityProvider
extends BasicAuthIdentityProvider
implements IdentityProvider {
    private static final Logger logger = LoggerFactory.getLogger(LdapIdentityProvider.class);
    private static final String issuer = LdapIdentityProvider.class.getSimpleName();
    private AbstractLdapAuthenticationProvider ldapAuthenticationProvider;
    private long expiration;
    private IdentityStrategy identityStrategy;

    public final void onConfigured(IdentityProviderConfigurationContext configurationContext) throws SecurityProviderCreationException {
        ReferralStrategy referralStrategy;
        LdapAuthenticationStrategy authenticationStrategy;
        String rawExpiration = configurationContext.getProperty("Authentication Expiration");
        if (StringUtils.isBlank((CharSequence)rawExpiration)) {
            throw new SecurityProviderCreationException("The Authentication Expiration must be specified.");
        }
        try {
            this.expiration = Math.round(FormatUtils.getPreciseTimeDuration((String)rawExpiration, (TimeUnit)TimeUnit.MILLISECONDS));
        }
        catch (IllegalArgumentException iae) {
            throw new SecurityProviderCreationException(String.format("The Expiration Duration '%s' is not a valid time duration", rawExpiration));
        }
        LdapContextSource context = new LdapContextSource();
        HashMap<String, Object> baseEnvironment = new HashMap<String, Object>();
        this.setTimeout(configurationContext, baseEnvironment, "Connect Timeout", "com.sun.jndi.ldap.connect.timeout");
        this.setTimeout(configurationContext, baseEnvironment, "Read Timeout", "com.sun.jndi.ldap.read.timeout");
        String rawAuthenticationStrategy = configurationContext.getProperty("Authentication Strategy");
        try {
            authenticationStrategy = LdapAuthenticationStrategy.valueOf(rawAuthenticationStrategy);
        }
        catch (IllegalArgumentException iae) {
            throw new SecurityProviderCreationException(String.format("Unrecognized authentication strategy '%s'. Possible values are [%s]", rawAuthenticationStrategy, StringUtils.join((Object[])LdapAuthenticationStrategy.values(), (String)", ")));
        }
        block5 : switch (authenticationStrategy) {
            case ANONYMOUS: {
                context.setAnonymousReadOnly(true);
                break;
            }
            default: {
                String userDn = configurationContext.getProperty("Manager DN");
                String password = configurationContext.getProperty("Manager Password");
                context.setUserDn(userDn);
                context.setPassword(password);
                switch (authenticationStrategy) {
                    case SIMPLE: {
                        context.setAuthenticationStrategy((DirContextAuthenticationStrategy)new SimpleDirContextAuthenticationStrategy());
                        break block5;
                    }
                    case LDAPS: {
                        context.setAuthenticationStrategy((DirContextAuthenticationStrategy)new SimpleDirContextAuthenticationStrategy());
                        baseEnvironment.put("java.naming.security.protocol", "ssl");
                        SSLContext ldapsSslContext = this.getConfiguredSslContext(configurationContext);
                        if (ldapsSslContext == null) break block5;
                        LdapsSocketFactory.initialize(ldapsSslContext.getSocketFactory());
                        baseEnvironment.put("java.naming.ldap.factory.socket", LdapsSocketFactory.class.getName());
                        break block5;
                    }
                    case START_TLS: {
                        SSLContext startTlsSslContext;
                        DefaultTlsDirContextAuthenticationStrategy tlsAuthenticationStrategy = new DefaultTlsDirContextAuthenticationStrategy();
                        String rawShutdownGracefully = configurationContext.getProperty("TLS - Shutdown Gracefully");
                        if (StringUtils.isNotBlank((CharSequence)rawShutdownGracefully)) {
                            boolean shutdownGracefully = Boolean.TRUE.toString().equalsIgnoreCase(rawShutdownGracefully);
                            tlsAuthenticationStrategy.setShutdownTlsGracefully(shutdownGracefully);
                        }
                        if ((startTlsSslContext = this.getConfiguredSslContext(configurationContext)) != null) {
                            tlsAuthenticationStrategy.setSslSocketFactory(startTlsSslContext.getSocketFactory());
                        }
                        context.setAuthenticationStrategy((DirContextAuthenticationStrategy)tlsAuthenticationStrategy);
                    }
                }
            }
        }
        String rawReferralStrategy = configurationContext.getProperty("Referral Strategy");
        try {
            referralStrategy = ReferralStrategy.valueOf(rawReferralStrategy);
        }
        catch (IllegalArgumentException iae) {
            throw new SecurityProviderCreationException(String.format("Unrecognized referral strategy '%s'. Possible values are [%s]", rawReferralStrategy, StringUtils.join((Object[])ReferralStrategy.values(), (String)", ")));
        }
        context.setReferral(referralStrategy.getValue());
        String urls = configurationContext.getProperty("Url");
        if (StringUtils.isBlank((CharSequence)urls)) {
            throw new SecurityProviderCreationException("LDAP identity provider 'Url' must be specified.");
        }
        context.setUrls(StringUtils.split((String)urls));
        String userSearchBase = configurationContext.getProperty("User Search Base");
        String userSearchFilter = configurationContext.getProperty("User Search Filter");
        if (StringUtils.isBlank((CharSequence)userSearchBase) || StringUtils.isBlank((CharSequence)userSearchFilter)) {
            throw new SecurityProviderCreationException("LDAP identity provider 'User Search Base' and 'User Search Filter' must be specified.");
        }
        FilterBasedLdapUserSearch userSearch = new FilterBasedLdapUserSearch(userSearchBase, userSearchFilter, (BaseLdapPathContextSource)context);
        BindAuthenticator authenticator = new BindAuthenticator((BaseLdapPathContextSource)context);
        authenticator.setUserSearch((LdapUserSearch)userSearch);
        String rawIdentityStrategy = configurationContext.getProperty("Identity Strategy");
        if (StringUtils.isBlank((CharSequence)rawIdentityStrategy)) {
            logger.info("Identity Strategy is not configured, defaulting strategy to {}.", (Object)IdentityStrategy.USE_DN);
            this.identityStrategy = IdentityStrategy.USE_DN;
        } else {
            try {
                this.identityStrategy = IdentityStrategy.valueOf(rawIdentityStrategy);
            }
            catch (IllegalArgumentException iae) {
                throw new SecurityProviderCreationException(String.format("Unrecognized identity strategy '%s'. Possible values are [%s]", rawIdentityStrategy, StringUtils.join((Object[])IdentityStrategy.values(), (String)", ")));
            }
        }
        if (!baseEnvironment.isEmpty()) {
            context.setBaseEnvironmentProperties(baseEnvironment);
        }
        try {
            context.afterPropertiesSet();
            authenticator.afterPropertiesSet();
        }
        catch (Exception e) {
            throw new SecurityProviderCreationException(e.getMessage(), (Throwable)e);
        }
        this.ldapAuthenticationProvider = new LdapAuthenticationProvider((LdapAuthenticator)authenticator);
    }

    public AuthenticationResponse authenticate(AuthenticationRequest authenticationRequest) throws InvalidCredentialsException, IdentityAccessException {
        if (authenticationRequest == null || StringUtils.isEmpty((CharSequence)authenticationRequest.getUsername())) {
            logger.debug("Call to authenticate method with null or empty authenticationRequest, returning null without attempting to authenticate");
            return null;
        }
        if (this.ldapAuthenticationProvider == null) {
            throw new IdentityAccessException("The LDAP authentication provider is not initialized.");
        }
        try {
            String username = authenticationRequest.getUsername();
            Object credentials = authenticationRequest.getCredentials();
            UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)username, credentials);
            Authentication authentication = this.ldapAuthenticationProvider.authenticate((Authentication)token);
            logger.debug("Created authentication token: {}", (Object)token);
            if (IdentityStrategy.USE_DN.equals((Object)this.identityStrategy)) {
                if (authentication.getPrincipal() instanceof LdapUserDetails) {
                    LdapUserDetails userDetails = (LdapUserDetails)authentication.getPrincipal();
                    return new AuthenticationResponse(userDetails.getDn(), username, this.expiration, issuer);
                }
                logger.warn("Unable to determine user DN for {}, using username.", (Object)authentication.getName());
                return new AuthenticationResponse(authentication.getName(), username, this.expiration, issuer);
            }
            return new AuthenticationResponse(authentication.getName(), username, this.expiration, issuer);
        }
        catch (AuthenticationException | BadCredentialsException | UsernameNotFoundException e) {
            throw new InvalidCredentialsException(e.getMessage(), e);
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            if (cause instanceof AuthenticationException) {
                throw new InvalidCredentialsException(e.getMessage(), (Throwable)e);
            }
            logger.error(e.getMessage());
            if (logger.isDebugEnabled()) {
                logger.debug("", (Throwable)e);
            }
            throw new IdentityAccessException("Unable to validate the supplied credentials. Please contact the system administrator.", (Throwable)e);
        }
    }

    public final void preDestruction() throws SecurityProviderDestructionException {
    }

    private void setTimeout(IdentityProviderConfigurationContext configurationContext, Map<String, Object> baseEnvironment, String configurationProperty, String environmentKey) {
        String rawTimeout = configurationContext.getProperty(configurationProperty);
        if (StringUtils.isNotBlank((CharSequence)rawTimeout)) {
            try {
                long timeout = Math.round(FormatUtils.getPreciseTimeDuration((String)rawTimeout, (TimeUnit)TimeUnit.MILLISECONDS));
                baseEnvironment.put(environmentKey, Long.toString(timeout));
            }
            catch (IllegalArgumentException iae) {
                throw new SecurityProviderCreationException(String.format("The %s '%s' is not a valid time duration", configurationProperty, rawTimeout));
            }
        }
    }

    private SSLContext getConfiguredSslContext(IdentityProviderConfigurationContext configurationContext) {
        SSLContext sslContext;
        block16: {
            String rawKeystore = configurationContext.getProperty("TLS - Keystore");
            String rawKeystorePassword = configurationContext.getProperty("TLS - Keystore Password");
            String rawKeystoreType = configurationContext.getProperty("TLS - Keystore Type");
            String rawTruststore = configurationContext.getProperty("TLS - Truststore");
            String rawTruststorePassword = configurationContext.getProperty("TLS - Truststore Password");
            String rawTruststoreType = configurationContext.getProperty("TLS - Truststore Type");
            String rawProtocol = configurationContext.getProperty("TLS - Protocol");
            try {
                if (StringUtils.isBlank((CharSequence)rawKeystore) && StringUtils.isBlank((CharSequence)rawTruststore)) {
                    sslContext = null;
                    break block16;
                }
                if (StringUtils.isBlank((CharSequence)rawProtocol)) {
                    throw new SecurityProviderCreationException("TLS - Protocol must be specified.");
                }
                StandardSslContextBuilder sslContextBuilder = new StandardSslContextBuilder().protocol(rawProtocol);
                if (StringUtils.isNotBlank((CharSequence)rawTruststore)) {
                    try (FileInputStream trustStoreStream = new FileInputStream(rawTruststore);){
                        KeyStore trustStore = new StandardKeyStoreBuilder().type(rawTruststoreType).password(rawTruststorePassword.toCharArray()).inputStream((InputStream)trustStoreStream).build();
                        sslContextBuilder.trustStore(trustStore);
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)rawKeystore)) {
                    try (FileInputStream keyStoreStream = new FileInputStream(rawKeystore);){
                        KeyStore keyStore = new StandardKeyStoreBuilder().type(rawKeystoreType).password(rawKeystorePassword.toCharArray()).inputStream((InputStream)keyStoreStream).build();
                        sslContextBuilder.keyStore(keyStore);
                        sslContextBuilder.keyPassword(rawKeystorePassword.toCharArray());
                    }
                }
                sslContext = sslContextBuilder.build();
            }
            catch (IOException | RuntimeException e) {
                throw new SecurityProviderCreationException(e.getMessage(), (Throwable)e);
            }
        }
        return sslContext;
    }
}

