/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.websocket.jetty;

import java.util.List;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.migration.PropertyConfiguration;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.websocket.AbstractWebSocketService;

public abstract class AbstractJettyWebSocketService
extends AbstractWebSocketService {
    public static final PropertyDescriptor INPUT_BUFFER_SIZE = new PropertyDescriptor.Builder().name("Input Buffer Size").description("The size of the input (read from network layer) buffer size.").required(true).defaultValue("4 kb").addValidator(StandardValidators.DATA_SIZE_VALIDATOR).build();
    public static final PropertyDescriptor MAX_TEXT_MESSAGE_SIZE = new PropertyDescriptor.Builder().name("Max Text Message Size").description("The maximum size of a text message during parsing/generating.").required(true).defaultValue("64 kb").addValidator(StandardValidators.DATA_SIZE_VALIDATOR).build();
    public static final PropertyDescriptor MAX_BINARY_MESSAGE_SIZE = new PropertyDescriptor.Builder().name("Max Binary Message Size").description("The maximum size of a binary message during parsing/generating.").required(true).defaultValue("64 kb").addValidator(StandardValidators.DATA_SIZE_VALIDATOR).build();
    public static final PropertyDescriptor IDLE_TIMEOUT = new PropertyDescriptor.Builder().name("Idle Timeout").description("The maximum amount of time that a WebSocket connection may remain idle before it is closed. A value of 0 sec disables the timeout.").required(true).defaultValue("0 sec").addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).build();
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(INPUT_BUFFER_SIZE, MAX_TEXT_MESSAGE_SIZE, MAX_BINARY_MESSAGE_SIZE, IDLE_TIMEOUT);

    static List<PropertyDescriptor> getAbstractPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public void migrateProperties(PropertyConfiguration propertyConfiguration) {
        super.migrateProperties(propertyConfiguration);
        propertyConfiguration.renameProperty("input-buffer-size", INPUT_BUFFER_SIZE.getName());
        propertyConfiguration.renameProperty("max-text-message-size", MAX_TEXT_MESSAGE_SIZE.getName());
        propertyConfiguration.renameProperty("max-binary-message-size", MAX_BINARY_MESSAGE_SIZE.getName());
    }
}

