/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.servlet.shared;

import jakarta.servlet.http.HttpServletRequest;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.nifi.web.servlet.shared.ProxyHeader;
import org.apache.nifi.web.servlet.shared.RequestUriProvider;

public class StandardRequestUriProvider
implements RequestUriProvider {
    private static final Pattern HOST_PATTERN = Pattern.compile("^([^:]+):?([1-9][0-9]{2,4})?$");
    private static final Pattern HOST_PORT_REQUIRED_PATTERN = Pattern.compile("^[^:]+:([1-9][0-9]{2,4})$");
    private static final Pattern SCHEME_PATTERN = Pattern.compile("^https?$");
    private static final int FIRST_GROUP = 1;
    private static final int MINIMUM_PORT_NUMBER = 100;
    private static final int MAXIMUM_PORT_NUMBER = 65535;
    private static final String EMPTY_PATH = "";
    private static final String ROOT_PATH = "/";
    private final List<String> allowedContextPaths;

    public StandardRequestUriProvider(List<String> allowedContextPaths) {
        this.allowedContextPaths = Objects.requireNonNull(allowedContextPaths);
    }

    @Override
    public URI getRequestUri(HttpServletRequest request) {
        Objects.requireNonNull(request, "HTTP Servlet Request required");
        String scheme = this.getScheme(request);
        String host = this.getHost(request);
        int port = this.getPort(request);
        String path = this.getPath(request);
        try {
            return new URI(scheme, null, host, port, path, null, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Request URI construction failed", e);
        }
    }

    private String getScheme(HttpServletRequest request) {
        Matcher matcher;
        String requestScheme = request.getScheme();
        String headerScheme = this.getFirstHeader(request, ProxyHeader.PROXY_SCHEME, ProxyHeader.FORWARDED_PROTO);
        String scheme = headerScheme == null ? requestScheme : ((matcher = SCHEME_PATTERN.matcher(headerScheme)).matches() ? headerScheme : requestScheme);
        return scheme;
    }

    private String getHost(HttpServletRequest request) {
        Matcher matcher;
        String serverName = request.getServerName();
        String headerHost = this.getFirstHeader(request, ProxyHeader.PROXY_HOST, ProxyHeader.FORWARDED_HOST, ProxyHeader.HOST);
        String host = headerHost == null ? serverName : ((matcher = HOST_PATTERN.matcher(headerHost)).matches() ? matcher.group(1) : serverName);
        return host;
    }

    private int getPort(HttpServletRequest request) {
        int port;
        int serverPort = request.getServerPort();
        String headerHost = this.getFirstHeader(request, ProxyHeader.PROXY_HOST, ProxyHeader.FORWARDED_HOST);
        if (headerHost == null) {
            port = this.getProxyPort(request);
        } else {
            Matcher matcher = HOST_PORT_REQUIRED_PATTERN.matcher(headerHost);
            if (matcher.matches()) {
                String headerPort = matcher.group(1);
                port = this.getParsedPort(headerPort, serverPort);
            } else {
                port = this.getProxyPort(request);
            }
        }
        return port;
    }

    private int getProxyPort(HttpServletRequest request) {
        int serverPort = request.getServerPort();
        String headerPort = this.getFirstHeader(request, ProxyHeader.PROXY_PORT, ProxyHeader.FORWARDED_PORT);
        int port = headerPort == null ? serverPort : this.getParsedPort(headerPort, serverPort);
        return port;
    }

    private int getParsedPort(String headerPort, int serverPort) {
        int port;
        try {
            int parsedPort = Integer.parseInt(headerPort);
            port = parsedPort < 100 || parsedPort > 65535 ? serverPort : parsedPort;
        }
        catch (Exception e) {
            port = serverPort;
        }
        return port;
    }

    private String getPath(HttpServletRequest request) {
        String path;
        String headerPath = this.getFirstHeader(request, ProxyHeader.PROXY_CONTEXT_PATH, ProxyHeader.FORWARDED_CONTEXT, ProxyHeader.FORWARDED_PREFIX);
        if (headerPath == null) {
            path = EMPTY_PATH;
        } else if (ROOT_PATH.equals(headerPath)) {
            path = ROOT_PATH;
        } else if (this.allowedContextPaths.contains(headerPath)) {
            path = headerPath;
        } else {
            throw new IllegalArgumentException("Request Header Context Path not allowed based on properties [nifi.web.proxy.context.path]");
        }
        return path;
    }

    private String getFirstHeader(HttpServletRequest request, ProxyHeader ... proxyHeaders) {
        return Arrays.stream(proxyHeaders).map(ProxyHeader::getHeader).map(arg_0 -> ((HttpServletRequest)request).getHeader(arg_0)).filter(Objects::nonNull).filter(Predicate.not(String::isBlank)).findFirst().orElse(null);
    }
}

