/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.servlet.filter;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URI;
import org.apache.nifi.web.servlet.shared.RequestUriBuilder;

public class QueryStringToFragmentFilter
implements Filter {
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        String queryString = httpServletRequest.getQueryString();
        if (queryString != null) {
            String contextPath = httpServletRequest.getContextPath() + "/";
            RequestUriBuilder requestUriBuilder = RequestUriBuilder.fromHttpServletRequest(httpServletRequest).path(contextPath).fragment("/?" + queryString);
            URI redirectUri = requestUriBuilder.build();
            HttpServletResponse httpServletResponse = (HttpServletResponse)response;
            httpServletResponse.sendRedirect(redirectUri.toString());
        } else {
            filterChain.doFilter(request, response);
        }
    }
}

