/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.servlet.shared;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.nifi.web.servlet.shared.StandardRequestUriProvider;

public class RequestUriBuilder {
    private static final String ALLOWED_CONTEXT_PATHS_PARAMETER = "allowedContextPaths";
    private static final String COMMA_SEPARATOR = ",";
    private final String scheme;
    private final String host;
    private final int port;
    private final String contextPath;
    private String path;
    private String fragment = null;

    private RequestUriBuilder(String scheme, String host, int port, String contextPath) {
        this.scheme = scheme;
        this.host = host;
        this.port = port;
        this.contextPath = contextPath;
    }

    public static RequestUriBuilder fromHttpServletRequest(HttpServletRequest httpServletRequest) {
        List<String> allowedContextPaths = RequestUriBuilder.getAllowedContextPathsConfigured(httpServletRequest);
        StandardRequestUriProvider requestUriProvider = new StandardRequestUriProvider(allowedContextPaths);
        URI requestUri = requestUriProvider.getRequestUri(httpServletRequest);
        return new RequestUriBuilder(requestUri.getScheme(), requestUri.getHost(), requestUri.getPort(), requestUri.getPath());
    }

    public RequestUriBuilder path(String path) {
        this.path = path;
        return this;
    }

    public RequestUriBuilder fragment(String fragment) {
        this.fragment = fragment;
        return this;
    }

    public URI build() {
        String resourcePath = this.getResourcePath();
        try {
            return new URI(this.scheme, null, this.host, this.port, resourcePath, null, this.fragment);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Build URI Failed", e);
        }
    }

    private static List<String> getAllowedContextPathsConfigured(HttpServletRequest httpServletRequest) {
        List<String> allowedContextPathsConfigured;
        ServletContext servletContext = httpServletRequest.getServletContext();
        String allowedContextPathsParameter = servletContext.getInitParameter(ALLOWED_CONTEXT_PATHS_PARAMETER);
        if (allowedContextPathsParameter == null) {
            allowedContextPathsConfigured = Collections.emptyList();
        } else {
            String[] allowedContextPathsParsed = allowedContextPathsParameter.split(COMMA_SEPARATOR);
            allowedContextPathsConfigured = Arrays.asList(allowedContextPathsParsed);
        }
        return allowedContextPathsConfigured;
    }

    private String getResourcePath() {
        Object resourcePath = this.path == null ? this.contextPath : this.contextPath + this.path;
        return resourcePath;
    }
}

