/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.authorization.user.NiFiUserUtils;
import org.apache.nifi.security.proxied.entity.ProxiedEntityEncoder;
import org.apache.nifi.security.proxied.entity.StandardProxiedEntityEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.AuthenticationException;

public class ProxiedEntitiesUtils {
    private static final Logger logger = LoggerFactory.getLogger(ProxiedEntitiesUtils.class);
    public static final String PROXY_ENTITIES_CHAIN = "X-ProxiedEntitiesChain";
    public static final String PROXY_ENTITIES_ACCEPTED = "X-ProxiedEntitiesAccepted";
    public static final String PROXY_ENTITIES_DETAILS = "X-ProxiedEntitiesDetails";
    public static final String PROXY_ENTITY_GROUPS = "X-ProxiedEntityGroups";
    public static final String PROXY_ENTITY_GROUPS_EMPTY = "<>";
    private static final String GT = ">";
    private static final String ESCAPED_GT = "\\\\>";
    private static final String LT = "<";
    private static final String ESCAPED_LT = "\\\\<";
    private static final String ANONYMOUS_CHAIN = "<>";
    private static final String ANONYMOUS_IDENTITY = "";
    private static final ProxiedEntityEncoder proxiedEntityEncoder = StandardProxiedEntityEncoder.getInstance();

    public static List<String> tokenizeProxiedEntitiesChain(String rawProxyChain) {
        ArrayList<String> proxyChain = new ArrayList<String>();
        if (!StringUtils.isEmpty((CharSequence)rawProxyChain)) {
            if (!ProxiedEntitiesUtils.isValidChainFormat(rawProxyChain)) {
                throw new IllegalArgumentException("Proxy chain format is not recognized and can not safely be converted to a list.");
            }
            if (rawProxyChain.equals("<>")) {
                proxyChain.add(ANONYMOUS_IDENTITY);
            } else {
                String[] elements = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)rawProxyChain.substring(1, rawProxyChain.length() - 1), (String)"><");
                Arrays.stream(elements).map(ProxiedEntitiesUtils::unsanitizeDn).forEach(proxyChain::add);
            }
        }
        return proxyChain;
    }

    public static Set<String> tokenizeProxiedEntityGroups(String rawProxyEntityGroups) {
        List<String> elements = ProxiedEntitiesUtils.tokenizeProxiedEntitiesChain(rawProxyEntityGroups);
        if (elements.isEmpty()) {
            return Collections.emptySet();
        }
        return elements.stream().filter(e -> !StringUtils.isBlank((CharSequence)e)).collect(Collectors.toSet());
    }

    public static String buildProxiedEntitiesChainString(NiFiUser user) {
        List proxyChain = NiFiUserUtils.buildProxiedEntitiesChain((NiFiUser)user);
        if (proxyChain.isEmpty()) {
            return "<>";
        }
        proxyChain = proxyChain.stream().map(arg_0 -> ((ProxiedEntityEncoder)proxiedEntityEncoder).getEncodedEntity(arg_0)).collect(Collectors.toList());
        return StringUtils.join(proxyChain, (String)ANONYMOUS_IDENTITY);
    }

    public static String buildProxiedEntityGroupsString(Set<String> groups) {
        if (groups == null || groups.isEmpty()) {
            return "<>";
        }
        List formattedGroups = groups.stream().map(arg_0 -> ((ProxiedEntityEncoder)proxiedEntityEncoder).getEncodedEntity(arg_0)).collect(Collectors.toList());
        return StringUtils.join(formattedGroups, (String)ANONYMOUS_IDENTITY);
    }

    public static void successfulAuthentication(HttpServletRequest request, HttpServletResponse response) {
        if (StringUtils.isNotBlank((CharSequence)request.getHeader(PROXY_ENTITIES_CHAIN))) {
            response.setHeader(PROXY_ENTITIES_ACCEPTED, Boolean.TRUE.toString());
        }
    }

    public static void unsuccessfulAuthentication(HttpServletRequest request, HttpServletResponse response, AuthenticationException failed) {
        if (StringUtils.isNotBlank((CharSequence)request.getHeader(PROXY_ENTITIES_CHAIN))) {
            response.setHeader(PROXY_ENTITIES_DETAILS, failed.getMessage());
        }
    }

    private static String unsanitizeDn(String sanitizedDn) {
        String decodedDn;
        if (StringUtils.isEmpty((CharSequence)sanitizedDn)) {
            return sanitizedDn;
        }
        if (ProxiedEntitiesUtils.isBase64Encoded(sanitizedDn)) {
            decodedDn = ProxiedEntitiesUtils.base64Decode(sanitizedDn);
            logger.debug("The provided DN [{}] had been encoded, and was reconstituted to the original DN [{}]", (Object)sanitizedDn, (Object)decodedDn);
        } else {
            decodedDn = sanitizedDn;
        }
        String unsanitizedDn = decodedDn.replaceAll(ESCAPED_GT, GT).replaceAll(ESCAPED_LT, LT);
        if (!unsanitizedDn.equals(decodedDn)) {
            logger.warn("The provided DN [{}] had been escaped, and was reconstituted to the dangerous DN [{}]", (Object)sanitizedDn, (Object)unsanitizedDn);
        }
        return unsanitizedDn;
    }

    private static String base64Decode(String encodedValue) {
        String base64String = encodedValue.substring(1, encodedValue.length() - 1);
        return new String(Base64.getDecoder().decode(base64String), StandardCharsets.UTF_8);
    }

    private static boolean isValidChainFormat(String rawProxiedEntitiesChain) {
        return ProxiedEntitiesUtils.isWrappedInAngleBrackets(rawProxiedEntitiesChain);
    }

    private static boolean isBase64Encoded(String token) {
        return ProxiedEntitiesUtils.isWrappedInAngleBrackets(token);
    }

    private static boolean isWrappedInAngleBrackets(String string) {
        return string.startsWith(LT) && string.endsWith(GT);
    }
}

