/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.saml2.service.web;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.apache.nifi.web.security.cookie.ApplicationCookieName;
import org.apache.nifi.web.security.cookie.ApplicationCookieService;
import org.apache.nifi.web.security.cookie.StandardApplicationCookieService;
import org.apache.nifi.web.servlet.shared.RequestUriBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;
import org.springframework.security.saml2.provider.service.authentication.AbstractSaml2AuthenticationRequest;
import org.springframework.security.saml2.provider.service.web.Saml2AuthenticationRequestRepository;

public class StandardSaml2AuthenticationRequestRepository
implements Saml2AuthenticationRequestRepository<AbstractSaml2AuthenticationRequest> {
    private static final Logger logger = LoggerFactory.getLogger(StandardSaml2AuthenticationRequestRepository.class);
    private static final ApplicationCookieService applicationCookieService = new StandardApplicationCookieService();
    private final Cache cache;

    public StandardSaml2AuthenticationRequestRepository(Cache cache) {
        this.cache = Objects.requireNonNull(cache, "Cache required");
    }

    public AbstractSaml2AuthenticationRequest loadAuthenticationRequest(HttpServletRequest request) {
        AbstractSaml2AuthenticationRequest authenticationRequest;
        Optional<String> requestIdentifier = applicationCookieService.getCookieValue(request, ApplicationCookieName.SAML_REQUEST_IDENTIFIER);
        if (requestIdentifier.isPresent()) {
            String identifier = requestIdentifier.get();
            authenticationRequest = (AbstractSaml2AuthenticationRequest)this.cache.get((Object)identifier, AbstractSaml2AuthenticationRequest.class);
            if (authenticationRequest == null) {
                logger.warn("SAML Authentication Request [{}] not found", (Object)identifier);
            }
        } else {
            logger.warn("SAML Authentication Request Identifier cookie not found");
            authenticationRequest = null;
        }
        return authenticationRequest;
    }

    public void saveAuthenticationRequest(AbstractSaml2AuthenticationRequest authenticationRequest, HttpServletRequest request, HttpServletResponse response) {
        if (authenticationRequest == null) {
            this.removeAuthenticationRequest(request, response);
        } else {
            String identifier = UUID.randomUUID().toString();
            this.cache.put((Object)identifier, (Object)authenticationRequest);
            URI resourceUri = RequestUriBuilder.fromHttpServletRequest((HttpServletRequest)request).build();
            applicationCookieService.addCookie(resourceUri, response, ApplicationCookieName.SAML_REQUEST_IDENTIFIER, identifier);
            logger.debug("SAML Authentication Request [{}] saved", (Object)identifier);
        }
    }

    public AbstractSaml2AuthenticationRequest removeAuthenticationRequest(HttpServletRequest request, HttpServletResponse response) {
        AbstractSaml2AuthenticationRequest authenticationRequest = this.loadAuthenticationRequest(request);
        if (authenticationRequest == null) {
            logger.warn("SAML Authentication Request not found");
        } else {
            URI resourceUri = RequestUriBuilder.fromHttpServletRequest((HttpServletRequest)request).build();
            applicationCookieService.removeCookie(resourceUri, response, ApplicationCookieName.SAML_REQUEST_IDENTIFIER);
            Optional<String> requestIdentifier = applicationCookieService.getCookieValue(request, ApplicationCookieName.SAML_REQUEST_IDENTIFIER);
            requestIdentifier.ifPresent(arg_0 -> ((Cache)this.cache).evict(arg_0));
        }
        return authenticationRequest;
    }
}

