/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.oidc.revocation;

import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import org.apache.nifi.web.security.oidc.client.web.OidcRegistrationProperty;
import org.apache.nifi.web.security.oidc.revocation.TokenRevocationRequest;
import org.apache.nifi.web.security.oidc.revocation.TokenRevocationResponse;
import org.apache.nifi.web.security.oidc.revocation.TokenRevocationResponseClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestOperations;

public class StandardTokenRevocationResponseClient
implements TokenRevocationResponseClient {
    static final String REVOCATION_ENDPOINT = "revocation_endpoint";
    private static final Logger logger = LoggerFactory.getLogger(StandardTokenRevocationResponseClient.class);
    private final RestOperations restOperations;
    private final ClientRegistrationRepository clientRegistrationRepository;

    public StandardTokenRevocationResponseClient(RestOperations restOperations, ClientRegistrationRepository clientRegistrationRepository) {
        this.restOperations = Objects.requireNonNull(restOperations, "REST Operations required");
        this.clientRegistrationRepository = Objects.requireNonNull(clientRegistrationRepository, "Client Registry Repository required");
    }

    @Override
    public TokenRevocationResponse getRevocationResponse(TokenRevocationRequest revocationRequest) {
        Objects.requireNonNull(revocationRequest, "Revocation Request required");
        ClientRegistration clientRegistration = this.clientRegistrationRepository.findByRegistrationId(OidcRegistrationProperty.REGISTRATION_ID.getProperty());
        ResponseEntity<?> responseEntity = this.getResponseEntity(revocationRequest, clientRegistration);
        HttpStatusCode statusCode = responseEntity.getStatusCode();
        return new TokenRevocationResponse(statusCode.is2xxSuccessful(), statusCode.value());
    }

    private ResponseEntity<?> getResponseEntity(TokenRevocationRequest revocationRequest, ClientRegistration clientRegistration) {
        RequestEntity<?> requestEntity = this.getRequestEntity(revocationRequest, clientRegistration);
        if (requestEntity == null) {
            return ResponseEntity.ok(null);
        }
        try {
            ResponseEntity responseEntity = this.restOperations.exchange(requestEntity, String.class);
            logger.debug("Token Revocation Request processing completed [HTTP {}]", (Object)responseEntity.getStatusCode());
            return responseEntity;
        }
        catch (Exception e) {
            logger.warn("Token Revocation Request processing failed", (Throwable)e);
            return ResponseEntity.internalServerError().build();
        }
    }

    private RequestEntity<?> getRequestEntity(TokenRevocationRequest revocationRequest, ClientRegistration clientRegistration) {
        RequestEntity requestEntity;
        URI revocationEndpoint = this.getRevocationEndpoint(clientRegistration);
        if (revocationEndpoint == null) {
            requestEntity = null;
            logger.info("OIDC Revocation Endpoint not found");
        } else {
            LinkedMultiValueMap parameters = new LinkedMultiValueMap();
            parameters.add((Object)"token", (Object)revocationRequest.getToken());
            String tokenTypeHint = revocationRequest.getTokenTypeHint();
            if (StringUtils.hasLength((String)tokenTypeHint)) {
                parameters.add((Object)"token_type_hint", (Object)tokenTypeHint);
            }
            HttpHeaders headers = new HttpHeaders();
            String clientId = clientRegistration.getClientId();
            String clientSecret = clientRegistration.getClientSecret();
            headers.setBasicAuth(clientId, clientSecret, StandardCharsets.UTF_8);
            requestEntity = ((RequestEntity.BodyBuilder)RequestEntity.post((URI)revocationEndpoint).headers(headers)).contentType(MediaType.APPLICATION_FORM_URLENCODED).body((Object)parameters);
        }
        return requestEntity;
    }

    private URI getRevocationEndpoint(ClientRegistration clientRegistration) {
        ClientRegistration.ProviderDetails providerDetails = clientRegistration.getProviderDetails();
        Map configurationMetadata = providerDetails.getConfigurationMetadata();
        Object revocationEndpoint = configurationMetadata.get(REVOCATION_ENDPOINT);
        return revocationEndpoint == null ? null : URI.create(revocationEndpoint.toString());
    }
}

