/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.jwt.key;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.KeyTypeException;
import com.nimbusds.jose.crypto.RSASSAVerifier;
import com.nimbusds.jose.jca.JCAContext;
import com.nimbusds.jose.proc.JWSVerifierFactory;
import java.security.Key;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Set;
import org.apache.nifi.web.security.jwt.key.Ed25519Verifier;

public class StandardJWSVerifierFactory
implements JWSVerifierFactory {
    private static final Set<JWSAlgorithm> SUPPORTED_ALGORITHMS = Set.of(JWSAlgorithm.EdDSA, JWSAlgorithm.PS512);
    private final JCAContext jcaContext = new JCAContext();

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JWSVerifier createJWSVerifier(JWSHeader jwsHeader, Key key) throws JOSEException {
        void var4_7;
        JWSAlgorithm algorithm = jwsHeader.getAlgorithm();
        if (!SUPPORTED_ALGORITHMS.contains(algorithm)) throw new JOSEException("JWS Algorithm [%s] not supported".formatted(algorithm));
        if (key instanceof RSAPublicKey) {
            RSAPublicKey rsaPublicKey = (RSAPublicKey)key;
            RSASSAVerifier rSASSAVerifier = new RSASSAVerifier(rsaPublicKey);
        } else {
            if (!(key instanceof PublicKey)) throw new KeyTypeException(PublicKey.class);
            PublicKey publicKey = (PublicKey)key;
            Ed25519Verifier ed25519Verifier = new Ed25519Verifier(publicKey);
        }
        var4_7.getJCAContext().setProvider(this.jcaContext.getProvider());
        return var4_7;
    }

    public Set<JWSAlgorithm> supportedJWSAlgorithms() {
        return SUPPORTED_ALGORITHMS;
    }

    public JCAContext getJCAContext() {
        return this.jcaContext;
    }
}

