/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.csrf;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.function.Supplier;
import org.springframework.security.web.csrf.CsrfToken;
import org.springframework.security.web.csrf.CsrfTokenRequestAttributeHandler;
import org.springframework.security.web.csrf.XorCsrfTokenRequestAttributeHandler;
import org.springframework.util.StringUtils;

public class StandardCsrfTokenRequestAttributeHandler
extends CsrfTokenRequestAttributeHandler {
    private final XorCsrfTokenRequestAttributeHandler handler = new XorCsrfTokenRequestAttributeHandler();

    public void handle(HttpServletRequest request, HttpServletResponse response, Supplier<CsrfToken> csrfTokenSupplier) {
        this.handler.handle(request, response, csrfTokenSupplier);
    }

    public String resolveCsrfTokenValue(HttpServletRequest request, CsrfToken csrfToken) {
        String headerTokenValue = request.getHeader(csrfToken.getHeaderName());
        String resolvedToken = StringUtils.hasText((String)headerTokenValue) ? super.resolveCsrfTokenValue(request, csrfToken) : null;
        return resolvedToken;
    }
}

