/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.configuration;

import jakarta.servlet.http.HttpServletRequest;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.security.NiFiWebAuthenticationDetails;
import org.apache.nifi.web.security.NiFiWebAuthenticationDetailsSource;
import org.apache.nifi.web.security.anonymous.NiFiAnonymousAuthenticationFilter;
import org.apache.nifi.web.security.anonymous.NiFiAnonymousAuthenticationProvider;
import org.apache.nifi.web.security.configuration.ClientRegistrationConfiguration;
import org.apache.nifi.web.security.configuration.JwtAuthenticationSecurityConfiguration;
import org.apache.nifi.web.security.configuration.JwtDecoderConfiguration;
import org.apache.nifi.web.security.configuration.KeyPairGeneratorConfiguration;
import org.apache.nifi.web.security.configuration.OidcSecurityConfiguration;
import org.apache.nifi.web.security.configuration.SamlAuthenticationSecurityConfiguration;
import org.apache.nifi.web.security.configuration.X509AuthenticationSecurityConfiguration;
import org.apache.nifi.web.security.logout.LogoutRequestManager;
import org.apache.nifi.web.security.spring.LoginIdentityProviderFactoryBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.security.authentication.AuthenticationDetailsSource;
import org.springframework.security.authentication.AuthenticationManager;

@Configuration
@Import(value={ClientRegistrationConfiguration.class, KeyPairGeneratorConfiguration.class, JwtAuthenticationSecurityConfiguration.class, JwtDecoderConfiguration.class, OidcSecurityConfiguration.class, SamlAuthenticationSecurityConfiguration.class, X509AuthenticationSecurityConfiguration.class})
public class AuthenticationSecurityConfiguration {
    private final NiFiProperties niFiProperties;
    private final ExtensionManager extensionManager;

    @Autowired
    public AuthenticationSecurityConfiguration(NiFiProperties niFiProperties, ExtensionManager extensionManager) {
        this.niFiProperties = niFiProperties;
        this.extensionManager = extensionManager;
    }

    @Bean
    public NiFiAnonymousAuthenticationFilter anonymousAuthenticationFilter(AuthenticationManager authenticationManager) {
        NiFiAnonymousAuthenticationFilter anonymousAuthenticationFilter = new NiFiAnonymousAuthenticationFilter();
        anonymousAuthenticationFilter.setProperties(this.niFiProperties);
        anonymousAuthenticationFilter.setAuthenticationManager(authenticationManager);
        anonymousAuthenticationFilter.setAuthenticationDetailsSource(this.authenticationDetailsSource());
        return anonymousAuthenticationFilter;
    }

    @Bean
    public LoginIdentityProviderFactoryBean loginIdentityProviderFactoryBean() {
        LoginIdentityProviderFactoryBean loginIdentityProviderFactoryBean = new LoginIdentityProviderFactoryBean();
        loginIdentityProviderFactoryBean.setProperties(this.niFiProperties);
        loginIdentityProviderFactoryBean.setExtensionManager(this.extensionManager);
        return loginIdentityProviderFactoryBean;
    }

    @Bean
    public Object loginIdentityProvider() throws Exception {
        return this.loginIdentityProviderFactoryBean().getObject();
    }

    @Bean
    public LogoutRequestManager logoutRequestManager() {
        return new LogoutRequestManager();
    }

    @Bean
    public NiFiAnonymousAuthenticationProvider anonymousAuthenticationProvider(Authorizer authorizer) {
        return new NiFiAnonymousAuthenticationProvider(this.niFiProperties, authorizer);
    }

    @Bean
    public AuthenticationDetailsSource<HttpServletRequest, NiFiWebAuthenticationDetails> authenticationDetailsSource() {
        return new NiFiWebAuthenticationDetailsSource();
    }
}

