/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.x509;

import java.security.cert.X509Certificate;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.web.security.NiFiAuthenticationRequestToken;
import org.springframework.security.web.authentication.preauth.x509.X509PrincipalExtractor;

public class X509AuthenticationRequestToken
extends NiFiAuthenticationRequestToken {
    private final String proxiedEntitiesChain;
    private final String proxiedEntityGroups;
    private final X509PrincipalExtractor principalExtractor;
    private final X509Certificate[] certificates;

    public X509AuthenticationRequestToken(String proxiedEntitiesChain, String proxiedEntityGroups, X509PrincipalExtractor principalExtractor, X509Certificate[] certificates, String clientAddress, Object authenticationDetails) {
        super(clientAddress, authenticationDetails);
        this.setAuthenticated(false);
        this.proxiedEntitiesChain = proxiedEntitiesChain;
        this.proxiedEntityGroups = proxiedEntityGroups;
        this.principalExtractor = principalExtractor;
        this.certificates = certificates;
    }

    public Object getCredentials() {
        return null;
    }

    public Object getPrincipal() {
        if (StringUtils.isBlank((CharSequence)this.proxiedEntitiesChain)) {
            return this.principalExtractor.extractPrincipal(this.certificates[0]);
        }
        return String.format("%s<%s>", this.proxiedEntitiesChain, this.principalExtractor.extractPrincipal(this.certificates[0]));
    }

    public String getProxiedEntitiesChain() {
        return this.proxiedEntitiesChain;
    }

    public String getProxiedEntityGroups() {
        return this.proxiedEntityGroups;
    }

    public X509Certificate[] getCertificates() {
        return this.certificates;
    }

    public String toString() {
        return this.getName();
    }
}

