/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.saml2.service.web;

import jakarta.servlet.http.HttpServletRequest;
import java.net.URI;
import java.util.HashMap;
import java.util.Objects;
import org.apache.nifi.web.security.saml2.registration.Saml2RegistrationProperty;
import org.apache.nifi.web.servlet.shared.RequestUriBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistration;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistrationRepository;
import org.springframework.security.saml2.provider.service.web.RelyingPartyRegistrationResolver;
import org.springframework.web.util.UriComponentsBuilder;

public class StandardRelyingPartyRegistrationResolver
implements Converter<HttpServletRequest, RelyingPartyRegistration>,
RelyingPartyRegistrationResolver {
    private static final String BASE_URL_KEY = "baseUrl";
    private static final String REGISTRATION_ID_KEY = "registrationId";
    private static final Logger logger = LoggerFactory.getLogger(StandardRelyingPartyRegistrationResolver.class);
    private final RelyingPartyRegistrationRepository repository;

    public StandardRelyingPartyRegistrationResolver(RelyingPartyRegistrationRepository repository) {
        this.repository = Objects.requireNonNull(repository, "Repository required");
    }

    public RelyingPartyRegistration convert(HttpServletRequest request) {
        return this.resolve(request, Saml2RegistrationProperty.REGISTRATION_ID.getProperty());
    }

    public RelyingPartyRegistration resolve(HttpServletRequest request, String relyingPartyRegistrationId) {
        RelyingPartyRegistration resolved;
        Objects.requireNonNull(request, "Request required");
        RelyingPartyRegistration registration = this.repository.findByRegistrationId(relyingPartyRegistrationId);
        if (registration == null) {
            resolved = null;
            logger.warn("Relying Party Registration [{}] not found", (Object)relyingPartyRegistrationId);
        } else {
            String baseUrl = this.getBaseUrl(request);
            String assertionConsumerServiceLocation = this.resolveUrl(registration.getAssertionConsumerServiceLocation(), baseUrl, registration);
            String singleLogoutServiceLocation = this.resolveUrl(registration.getSingleLogoutServiceLocation(), baseUrl, registration);
            String singleLogoutServiceResponseLocation = this.resolveUrl(registration.getSingleLogoutServiceResponseLocation(), baseUrl, registration);
            resolved = registration.mutate().assertionConsumerServiceLocation(assertionConsumerServiceLocation).singleLogoutServiceLocation(singleLogoutServiceLocation).singleLogoutServiceResponseLocation(singleLogoutServiceResponseLocation).build();
        }
        return resolved;
    }

    private String resolveUrl(String templateUrl, String baseUrl, RelyingPartyRegistration registration) {
        String resolved;
        if (templateUrl == null) {
            resolved = null;
        } else {
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put(BASE_URL_KEY, baseUrl);
            uriVariables.put(REGISTRATION_ID_KEY, registration.getRegistrationId());
            resolved = UriComponentsBuilder.fromUriString((String)templateUrl).buildAndExpand(uriVariables).toUriString();
        }
        return resolved;
    }

    private String getBaseUrl(HttpServletRequest request) {
        URI requestUri = RequestUriBuilder.fromHttpServletRequest((HttpServletRequest)request).build();
        String httpUrl = requestUri.toString();
        String contextPath = request.getContextPath();
        return UriComponentsBuilder.fromUriString((String)httpUrl).path(contextPath).replaceQuery(null).fragment(null).build().toString();
    }
}

