/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.oidc.client.web;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.apache.nifi.web.security.cookie.ApplicationCookieName;
import org.apache.nifi.web.security.cookie.ApplicationCookieService;
import org.apache.nifi.web.security.cookie.StandardApplicationCookieService;
import org.apache.nifi.web.servlet.shared.RequestUriBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;
import org.springframework.security.oauth2.client.web.AuthorizationRequestRepository;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationRequest;

public class StandardAuthorizationRequestRepository
implements AuthorizationRequestRepository<OAuth2AuthorizationRequest> {
    private static final Logger logger = LoggerFactory.getLogger(StandardAuthorizationRequestRepository.class);
    private static final ApplicationCookieService applicationCookieService = new StandardApplicationCookieService();
    private final Cache cache;

    public StandardAuthorizationRequestRepository(Cache cache) {
        this.cache = Objects.requireNonNull(cache, "Cache required");
    }

    public OAuth2AuthorizationRequest loadAuthorizationRequest(HttpServletRequest request) {
        OAuth2AuthorizationRequest authorizationRequest;
        Optional<String> requestIdentifier = applicationCookieService.getCookieValue(request, ApplicationCookieName.OIDC_REQUEST_IDENTIFIER);
        if (requestIdentifier.isPresent()) {
            String identifier = requestIdentifier.get();
            authorizationRequest = (OAuth2AuthorizationRequest)this.cache.get((Object)identifier, OAuth2AuthorizationRequest.class);
            if (authorizationRequest == null) {
                logger.warn("OIDC Authentication Request [{}] not found", (Object)identifier);
            }
        } else {
            logger.warn("OIDC Authorization Request Identifier cookie not found");
            authorizationRequest = null;
        }
        return authorizationRequest;
    }

    public void saveAuthorizationRequest(OAuth2AuthorizationRequest authorizationRequest, HttpServletRequest request, HttpServletResponse response) {
        if (authorizationRequest == null) {
            this.removeAuthorizationRequest(request, response);
        } else {
            String identifier = UUID.randomUUID().toString();
            this.cache.put((Object)identifier, (Object)authorizationRequest);
            URI resourceUri = RequestUriBuilder.fromHttpServletRequest((HttpServletRequest)request).build();
            applicationCookieService.addCookie(resourceUri, response, ApplicationCookieName.OIDC_REQUEST_IDENTIFIER, identifier);
            logger.debug("OIDC Authentication Request [{}] saved", (Object)identifier);
        }
    }

    public OAuth2AuthorizationRequest removeAuthorizationRequest(HttpServletRequest request, HttpServletResponse response) {
        OAuth2AuthorizationRequest authorizationRequest = this.loadAuthorizationRequest(request);
        if (authorizationRequest == null) {
            logger.warn("OIDC Authentication Request not removed");
        } else {
            if (response == null) {
                logger.warn("HTTP Servlet Response not specified");
            } else {
                URI resourceUri = RequestUriBuilder.fromHttpServletRequest((HttpServletRequest)request).build();
                applicationCookieService.removeCookie(resourceUri, response, ApplicationCookieName.OIDC_REQUEST_IDENTIFIER);
            }
            Optional<String> requestIdentifier = applicationCookieService.getCookieValue(request, ApplicationCookieName.OIDC_REQUEST_IDENTIFIER);
            requestIdentifier.ifPresent(arg_0 -> ((Cache)this.cache).evict(arg_0));
        }
        return authorizationRequest;
    }
}

