/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.jwt.key.command;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.crypto.RSASSASigner;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.util.Objects;
import java.util.UUID;
import org.apache.nifi.web.security.jwt.jws.JwsSignerContainer;
import org.apache.nifi.web.security.jwt.jws.SignerListener;
import org.apache.nifi.web.security.jwt.key.Ed25519Signer;
import org.apache.nifi.web.security.jwt.key.VerificationKeyListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyGenerationCommand
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(KeyGenerationCommand.class);
    private static final String RSA_KEY_ALGORITHM = "RSA";
    private static final JWSAlgorithm RSA_JWS_ALGORITHM = JWSAlgorithm.PS512;
    private static final JWSAlgorithm DEFAULT_JWS_ALGORITHM = JWSAlgorithm.EdDSA;
    private final KeyPairGenerator keyPairGenerator;
    private final JWSAlgorithm jwsAlgorithm;
    private final SignerListener signerListener;
    private final VerificationKeyListener verificationKeyListener;

    public KeyGenerationCommand(SignerListener signerListener, VerificationKeyListener verificationKeyListener, KeyPairGenerator keyPairGenerator) {
        this.signerListener = Objects.requireNonNull(signerListener, "Signer Listener required");
        this.verificationKeyListener = Objects.requireNonNull(verificationKeyListener, "Verification Key Listener required");
        this.keyPairGenerator = Objects.requireNonNull(keyPairGenerator, "Key Pair Generator required");
        String keyPairAlgorithm = keyPairGenerator.getAlgorithm();
        this.jwsAlgorithm = RSA_KEY_ALGORITHM.equals(keyPairAlgorithm) ? RSA_JWS_ALGORITHM : DEFAULT_JWS_ALGORITHM;
    }

    @Override
    public void run() {
        KeyPair keyPair = this.keyPairGenerator.generateKeyPair();
        String keyIdentifier = UUID.randomUUID().toString();
        LOGGER.debug("Generated Key Pair [{}] Key Identifier [{}]", (Object)this.keyPairGenerator.getAlgorithm(), (Object)keyIdentifier);
        this.verificationKeyListener.onVerificationKeyGenerated(keyIdentifier, keyPair.getPublic());
        PrivateKey privateKey = keyPair.getPrivate();
        JWSSigner jwsSigner = this.getJwsSigner(privateKey);
        this.signerListener.onSignerUpdated(new JwsSignerContainer(keyIdentifier, this.jwsAlgorithm, jwsSigner));
    }

    private JWSSigner getJwsSigner(PrivateKey privateKey) {
        Object jwsSigner = RSA_JWS_ALGORITHM.equals((Object)this.jwsAlgorithm) ? new RSASSASigner(privateKey) : new Ed25519Signer(privateKey);
        return jwsSigner;
    }
}

