/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.anonymous;

import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.authorization.user.NiFiUserDetails;
import org.apache.nifi.authorization.user.StandardNiFiUser;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.security.InvalidAuthenticationException;
import org.apache.nifi.web.security.NiFiAuthenticationProvider;
import org.apache.nifi.web.security.anonymous.NiFiAnonymousAuthenticationRequestToken;
import org.apache.nifi.web.security.token.NiFiAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetails;

public class NiFiAnonymousAuthenticationProvider
extends NiFiAuthenticationProvider {
    final NiFiProperties properties;

    public NiFiAnonymousAuthenticationProvider(NiFiProperties nifiProperties, Authorizer authorizer) {
        super(nifiProperties, authorizer);
        this.properties = nifiProperties;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        NiFiAnonymousAuthenticationRequestToken request = (NiFiAnonymousAuthenticationRequestToken)authentication;
        if (request.isSecureRequest() && !this.properties.isAnonymousAuthenticationAllowed().booleanValue()) {
            throw new InvalidAuthenticationException("Anonymous authentication has not been configured.");
        }
        return new NiFiAuthenticationToken((UserDetails)new NiFiUserDetails((NiFiUser)StandardNiFiUser.populateAnonymousUser(null, (String)request.getClientAddress())), null, request.getDetails());
    }

    public boolean supports(Class<?> authentication) {
        return NiFiAnonymousAuthenticationRequestToken.class.isAssignableFrom(authentication);
    }
}

