/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.nifi.authorization.user.NiFiUserUtils;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.security.InvalidAuthenticationException;
import org.apache.nifi.web.security.NiFiWebAuthenticationDetails;
import org.apache.nifi.web.security.ProxiedEntitiesUtils;
import org.apache.nifi.web.security.UntrustedProxyException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationDetailsSource;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.filter.GenericFilterBean;

public abstract class NiFiAuthenticationFilter
extends GenericFilterBean {
    private static final Logger log = LoggerFactory.getLogger(NiFiAuthenticationFilter.class);
    protected AuthenticationDetailsSource<HttpServletRequest, NiFiWebAuthenticationDetails> authenticationDetailsSource;
    private AuthenticationManager authenticationManager;
    private NiFiProperties properties;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        log.debug("Authenticating [{}]", (Object)authentication);
        if (this.requiresAuthentication()) {
            this.authenticate((HttpServletRequest)request, (HttpServletResponse)response, chain);
        } else {
            chain.doFilter(request, response);
        }
    }

    private boolean requiresAuthentication() {
        return NiFiUserUtils.getNiFiUser() == null;
    }

    private void authenticate(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            Authentication authenticationRequest = this.attemptAuthentication(request);
            if (authenticationRequest != null) {
                log.info("Authentication Started {} [{}] {} {}", new Object[]{request.getRemoteAddr(), authenticationRequest, request.getMethod(), request.getRequestURL()});
                Authentication authenticated = this.authenticationManager.authenticate(authenticationRequest);
                this.successfulAuthentication(request, response, authenticated);
            }
        }
        catch (AuthenticationException ae) {
            this.unsuccessfulAuthentication(request, response, ae);
            return;
        }
        catch (Exception e) {
            log.error("Authentication Failed [{}]", (Object)e.getMessage(), (Object)e);
            response.setContentType("text/plain");
            response.setStatus(500);
            PrintWriter out = response.getWriter();
            out.println("Failed to authenticate request. Please contact the system administrator.");
            return;
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public abstract Authentication attemptAuthentication(HttpServletRequest var1);

    protected void successfulAuthentication(HttpServletRequest request, HttpServletResponse response, Authentication authResult) {
        log.info("Authentication Success [{}] {} {} {}", new Object[]{authResult, request.getRemoteAddr(), request.getMethod(), request.getRequestURL()});
        SecurityContextHolder.getContext().setAuthentication(authResult);
        ProxiedEntitiesUtils.successfulAuthentication(request, response);
    }

    protected void unsuccessfulAuthentication(HttpServletRequest request, HttpServletResponse response, AuthenticationException ae) throws IOException {
        ProxiedEntitiesUtils.unsuccessfulAuthentication(request, response, ae);
        response.setContentType("text/plain");
        PrintWriter out = response.getWriter();
        if (ae instanceof InvalidAuthenticationException) {
            response.setStatus(401);
            out.println("Authentication credentials invalid");
        } else if (ae instanceof UntrustedProxyException) {
            response.setStatus(403);
            out.println("Authentication Proxy Server not trusted");
        } else if (ae instanceof AuthenticationServiceException) {
            log.error("Authentication Service Failed: {}", (Object)ae.getMessage(), (Object)ae);
            response.setStatus(500);
            out.println("Authentication service processing failed");
        } else {
            log.error("Authentication Exception: {}", (Object)ae.getMessage(), (Object)ae);
            response.setStatus(403);
            out.println("Access is denied.");
        }
        log.warn("Authentication Failed {} {} {} [{}]", new Object[]{request.getRemoteAddr(), request.getMethod(), request.getRequestURL(), ae.getMessage()});
        log.debug("Authentication Failed", (Throwable)ae);
    }

    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public void setAuthenticationDetailsSource(AuthenticationDetailsSource<HttpServletRequest, NiFiWebAuthenticationDetails> authenticationDetailsSource) {
        this.authenticationDetailsSource = authenticationDetailsSource;
    }

    public void setProperties(NiFiProperties properties) {
        this.properties = properties;
    }

    public NiFiProperties getProperties() {
        return this.properties;
    }
}

