/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.token;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.apache.nifi.security.util.CertificateUtils;
import org.springframework.security.authentication.AbstractAuthenticationToken;

public class LoginAuthenticationToken
extends AbstractAuthenticationToken {
    private final String identity;
    private final String username;
    private final long expiration;
    private final String issuer;

    public LoginAuthenticationToken(String identity, long expiration, String issuer) {
        this(identity, null, expiration, issuer);
    }

    public LoginAuthenticationToken(String identity, String username, long expiration, String issuer) {
        super(null);
        this.setAuthenticated(true);
        this.identity = identity;
        this.username = username;
        this.issuer = issuer;
        Calendar now = Calendar.getInstance();
        this.expiration = now.getTimeInMillis() + expiration;
    }

    public Object getCredentials() {
        return null;
    }

    public Object getPrincipal() {
        return this.identity;
    }

    public long getExpiration() {
        return this.expiration;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public String getName() {
        if (this.username == null) {
            return CertificateUtils.extractUsername((String)this.identity);
        }
        return this.username;
    }

    public String toString() {
        Calendar expirationTime = Calendar.getInstance();
        expirationTime.setTimeInMillis(this.getExpiration());
        long remainingTime = expirationTime.getTimeInMillis() - Calendar.getInstance().getTimeInMillis();
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss.SSS");
        dateFormat.setTimeZone(expirationTime.getTimeZone());
        String expirationTimeString = dateFormat.format(expirationTime.getTime());
        return "LoginAuthenticationToken for " + this.getName() + " issued by " + this.getIssuer() + " expiring at " + expirationTimeString + " [" + this.getExpiration() + " ms, " + remainingTime + " ms remaining]";
    }
}

