/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.x509.ocsp;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.LoadingCache;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.test.GroovyAssert;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Security;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Matcher;
import javax.ws.rs.client.ClientBuilder;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.security.x509.ocsp.CertificateStatusException;
import org.apache.nifi.web.security.x509.ocsp.OcspCertificateValidator;
import org.apache.nifi.web.security.x509.ocsp.OcspRequest;
import org.apache.nifi.web.security.x509.ocsp.OcspStatus;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.powerassert.AssertionRenderer;
import org.codehaus.groovy.runtime.powerassert.ValueRecorder;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OcspCertificateValidatorGroovyTest
implements GroovyObject {
    private static final Logger logger;
    private static final int KEY_SIZE = 2048;
    private static final long YESTERDAY;
    private static final long ONE_YEAR_FROM_NOW;
    private static final String SIGNATURE_ALGORITHM = "SHA256withRSA";
    private static final String PROVIDER = "BC";
    private static final String SUBJECT_DN = "CN=NiFi Test Server,OU=Security,O=Apache,ST=CA,C=US";
    private static final String ISSUER_DN = "CN=NiFi Test CA,OU=Security,O=Apache,ST=CA,C=US";
    private NiFiProperties mockProperties;
    private OcspCertificateValidator certificateValidator;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    public OcspCertificateValidatorGroovyTest() {
        MetaClass metaClass;
        CallSite[] callSiteArray = OcspCertificateValidatorGroovyTest.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @BeforeClass
    public static void setUpOnce() throws Exception {
        CallSite[] callSiteArray = OcspCertificateValidatorGroovyTest.$getCallSiteArray();
        callSiteArray[0].call(Security.class, callSiteArray[1].callConstructor(BouncyCastleProvider.class));
    }

    @Before
    public void setUp() throws Exception {
        CallSite[] callSiteArray = OcspCertificateValidatorGroovyTest.$getCallSiteArray();
        GroovyObject groovyObject = new GroovyObject(this){
            public /* synthetic */ OcspCertificateValidatorGroovyTest this$0;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                MetaClass metaClass;
                OcspCertificateValidatorGroovyTest ocspCertificateValidatorGroovyTest;
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                this.this$0 = ocspCertificateValidatorGroovyTest = p0;
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            public String getProperty(String key) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)callSiteArray[0].call((Object)"value_for_", (Object)key));
            }

            public Set<String> getPropertyKeys() {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                return (Set)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{"A", "set"}), Set.class);
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                return this.this$0.this$dist$invoke$1(name, args);
            }

            public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                return ScriptBytecodeAdapter.invokeMethodN(1.class, OcspCertificateValidatorGroovyTest.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void propertyMissing(String name, Object val) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                this.this$0.this$dist$set$1(name, val);
            }

            public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                Object object = val;
                ScriptBytecodeAdapter.setProperty((Object)object, null, OcspCertificateValidatorGroovyTest.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public /* synthetic */ Object propertyMissing(String name) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                return this.this$0.this$dist$get$1(name);
            }

            public static /* synthetic */ Object $static_propertyMissing(String name) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                return ScriptBytecodeAdapter.getProperty(1.class, OcspCertificateValidatorGroovyTest.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != 1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            @Generated
            @Internal
            public /* synthetic */ MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            @Generated
            @Internal
            public /* synthetic */ void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }

            @Generated
            @Internal
            public /* synthetic */ Object invokeMethod(String string, Object object) {
                return this.getMetaClass().invokeMethod((Object)this, string, object);
            }

            @Generated
            @Internal
            public /* synthetic */ void setProperty(String string, Object object) {
                this.getMetaClass().setProperty((Object)this, string, object);
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "plus";
                return new CallSiteArray(1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = 1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        };
        this.mockProperties = groovyObject;
    }

    @After
    public void tearDown() throws Exception {
        CallSite[] callSiteArray = OcspCertificateValidatorGroovyTest.$getCallSiteArray();
        Object var2_2 = null;
        ScriptBytecodeAdapter.setPropertySafe(var2_2, null, (Object)this.certificateValidator, (String)"metaClass");
    }

    private static KeyPair generateKeyPair() throws NoSuchAlgorithmException {
        CallSite[] callSiteArray = OcspCertificateValidatorGroovyTest.$getCallSiteArray();
        KeyPairGenerator keyPairGenerator = (KeyPairGenerator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[2].call(KeyPairGenerator.class, (Object)"RSA"), KeyPairGenerator.class);
        callSiteArray[3].call((Object)keyPairGenerator, (Object)KEY_SIZE);
        return (KeyPair)ScriptBytecodeAdapter.castToType((Object)callSiteArray[4].call((Object)keyPairGenerator), KeyPair.class);
    }

    private static X509Certificate generateCertificate(String dn) throws IOException, NoSuchAlgorithmException, CertificateException, NoSuchProviderException, SignatureException, InvalidKeyException, OperatorCreationException {
        CallSite[] callSiteArray = OcspCertificateValidatorGroovyTest.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            KeyPair keyPair = (KeyPair)ScriptBytecodeAdapter.castToType((Object)callSiteArray[5].callStatic(OcspCertificateValidatorGroovyTest.class), KeyPair.class);
            return (X509Certificate)ScriptBytecodeAdapter.castToType((Object)callSiteArray[6].callStatic(OcspCertificateValidatorGroovyTest.class, (Object)dn, (Object)keyPair), X509Certificate.class);
        }
        KeyPair keyPair = OcspCertificateValidatorGroovyTest.generateKeyPair();
        return OcspCertificateValidatorGroovyTest.generateCertificate(dn, keyPair);
    }

    private static X509Certificate generateCertificate(String dn, KeyPair keyPair) throws IOException, NoSuchAlgorithmException, CertificateException, NoSuchProviderException, SignatureException, InvalidKeyException, OperatorCreationException {
        CallSite[] callSiteArray = OcspCertificateValidatorGroovyTest.$getCallSiteArray();
        PrivateKey privateKey = (PrivateKey)ScriptBytecodeAdapter.castToType((Object)callSiteArray[7].call((Object)keyPair), PrivateKey.class);
        ContentSigner sigGen = (ContentSigner)ScriptBytecodeAdapter.castToType((Object)callSiteArray[8].call(callSiteArray[9].call(callSiteArray[10].callConstructor(JcaContentSignerBuilder.class, (Object)SIGNATURE_ALGORITHM), (Object)PROVIDER), (Object)privateKey), ContentSigner.class);
        SubjectPublicKeyInfo subPubKeyInfo = (SubjectPublicKeyInfo)ScriptBytecodeAdapter.castToType((Object)callSiteArray[11].call(SubjectPublicKeyInfo.class, callSiteArray[12].call(callSiteArray[13].call((Object)keyPair))), SubjectPublicKeyInfo.class);
        Date startDate = (Date)ScriptBytecodeAdapter.castToType((Object)callSiteArray[14].callConstructor(Date.class, (Object)YESTERDAY), Date.class);
        Date endDate = (Date)ScriptBytecodeAdapter.castToType((Object)callSiteArray[15].callConstructor(Date.class, (Object)ONE_YEAR_FROM_NOW), Date.class);
        X509v3CertificateBuilder certBuilder = (X509v3CertificateBuilder)ScriptBytecodeAdapter.castToType((Object)callSiteArray[16].callConstructor(X509v3CertificateBuilder.class, ArrayUtil.createArray((Object)callSiteArray[17].callConstructor(X500Name.class, (Object)dn), (Object)callSiteArray[18].call(BigInteger.class, callSiteArray[19].call(System.class)), (Object)startDate, (Object)endDate, (Object)callSiteArray[20].callConstructor(X500Name.class, (Object)dn), (Object)subPubKeyInfo)), X509v3CertificateBuilder.class);
        callSiteArray[21].call((Object)certBuilder, callSiteArray[22].callGetProperty(Extension.class), (Object)true, callSiteArray[23].callConstructor(KeyUsage.class, callSiteArray[24].call(callSiteArray[25].call(callSiteArray[26].call(callSiteArray[27].callGetProperty(KeyUsage.class), callSiteArray[28].callGetProperty(KeyUsage.class)), callSiteArray[29].callGetProperty(KeyUsage.class)), callSiteArray[30].callGetProperty(KeyUsage.class))));
        Vector ekUsages = (Vector)ScriptBytecodeAdapter.castToType((Object)callSiteArray[31].callConstructor(Vector.class), Vector.class);
        callSiteArray[32].call((Object)ekUsages, callSiteArray[33].callGetProperty(KeyPurposeId.class));
        callSiteArray[34].call((Object)ekUsages, callSiteArray[35].callGetProperty(KeyPurposeId.class));
        callSiteArray[36].call((Object)certBuilder, callSiteArray[37].callGetProperty(Extension.class), (Object)false, callSiteArray[38].callConstructor(ExtendedKeyUsage.class, (Object)ekUsages));
        X509CertificateHolder certificateHolder = (X509CertificateHolder)ScriptBytecodeAdapter.castToType((Object)callSiteArray[39].call((Object)certBuilder, (Object)sigGen), X509CertificateHolder.class);
        return (X509Certificate)ScriptBytecodeAdapter.castToType((Object)callSiteArray[40].call(callSiteArray[41].call(callSiteArray[42].callConstructor(JcaX509CertificateConverter.class), (Object)PROVIDER), (Object)certificateHolder), X509Certificate.class);
    }

    private static X509Certificate generateIssuedCertificate(String dn, String issuerDn, PrivateKey issuerKey) throws IOException, NoSuchAlgorithmException, CertificateException, NoSuchProviderException, SignatureException, InvalidKeyException, OperatorCreationException {
        CallSite[] callSiteArray = OcspCertificateValidatorGroovyTest.$getCallSiteArray();
        KeyPair keyPair = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[43].callStatic(OcspCertificateValidatorGroovyTest.class);
            keyPair = (KeyPair)ScriptBytecodeAdapter.castToType((Object)object, KeyPair.class);
        } else {
            KeyPair keyPair2;
            keyPair = keyPair2 = OcspCertificateValidatorGroovyTest.generateKeyPair();
        }
        return (X509Certificate)ScriptBytecodeAdapter.castToType((Object)callSiteArray[44].callStatic(OcspCertificateValidatorGroovyTest.class, (Object)dn, callSiteArray[45].call((Object)keyPair), (Object)issuerDn, (Object)issuerKey), X509Certificate.class);
    }

    private static X509Certificate generateIssuedCertificate(String dn, PublicKey publicKey, String issuerDn, PrivateKey issuerKey) throws IOException, NoSuchAlgorithmException, CertificateException, NoSuchProviderException, SignatureException, InvalidKeyException, OperatorCreationException {
        CallSite[] callSiteArray = OcspCertificateValidatorGroovyTest.$getCallSiteArray();
        ContentSigner sigGen = (ContentSigner)ScriptBytecodeAdapter.castToType((Object)callSiteArray[46].call(callSiteArray[47].call(callSiteArray[48].callConstructor(JcaContentSignerBuilder.class, (Object)SIGNATURE_ALGORITHM), (Object)PROVIDER), (Object)issuerKey), ContentSigner.class);
        SubjectPublicKeyInfo subPubKeyInfo = (SubjectPublicKeyInfo)ScriptBytecodeAdapter.castToType((Object)callSiteArray[49].call(SubjectPublicKeyInfo.class, callSiteArray[50].call((Object)publicKey)), SubjectPublicKeyInfo.class);
        Date startDate = (Date)ScriptBytecodeAdapter.castToType((Object)callSiteArray[51].callConstructor(Date.class, (Object)YESTERDAY), Date.class);
        Date endDate = (Date)ScriptBytecodeAdapter.castToType((Object)callSiteArray[52].callConstructor(Date.class, (Object)ONE_YEAR_FROM_NOW), Date.class);
        X509v3CertificateBuilder v3CertGen = (X509v3CertificateBuilder)ScriptBytecodeAdapter.castToType((Object)callSiteArray[53].callConstructor(X509v3CertificateBuilder.class, ArrayUtil.createArray((Object)callSiteArray[54].callConstructor(X500Name.class, (Object)issuerDn), (Object)callSiteArray[55].call(BigInteger.class, callSiteArray[56].call(System.class)), (Object)startDate, (Object)endDate, (Object)callSiteArray[57].callConstructor(X500Name.class, (Object)dn), (Object)subPubKeyInfo)), X509v3CertificateBuilder.class);
        X509CertificateHolder certificateHolder = (X509CertificateHolder)ScriptBytecodeAdapter.castToType((Object)callSiteArray[58].call((Object)v3CertGen, (Object)sigGen), X509CertificateHolder.class);
        return (X509Certificate)ScriptBytecodeAdapter.castToType((Object)callSiteArray[59].call(callSiteArray[60].call(callSiteArray[61].callConstructor(JcaX509CertificateConverter.class), (Object)PROVIDER), (Object)certificateHolder), X509Certificate.class);
    }

    private static X509Certificate[] generateCertificateChain(String dn, String issuerDn) {
        CallSite[] callSiteArray = OcspCertificateValidatorGroovyTest.$getCallSiteArray();
        KeyPair issuerKeyPair = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[62].callStatic(OcspCertificateValidatorGroovyTest.class);
            issuerKeyPair = (KeyPair)ScriptBytecodeAdapter.castToType((Object)object, KeyPair.class);
        } else {
            KeyPair keyPair;
            issuerKeyPair = keyPair = OcspCertificateValidatorGroovyTest.generateKeyPair();
        }
        PrivateKey issuerPrivateKey = (PrivateKey)ScriptBytecodeAdapter.castToType((Object)callSiteArray[63].call((Object)issuerKeyPair), PrivateKey.class);
        X509Certificate issuerCertificate = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[64].callStatic(OcspCertificateValidatorGroovyTest.class, (Object)issuerDn, (Object)issuerKeyPair);
            issuerCertificate = (X509Certificate)ScriptBytecodeAdapter.castToType((Object)object, X509Certificate.class);
        } else {
            X509Certificate x509Certificate;
            issuerCertificate = x509Certificate = OcspCertificateValidatorGroovyTest.generateCertificate(issuerDn, issuerKeyPair);
        }
        X509Certificate certificate = (X509Certificate)ScriptBytecodeAdapter.castToType((Object)callSiteArray[65].callStatic(OcspCertificateValidatorGroovyTest.class, (Object)dn, (Object)issuerDn, (Object)issuerPrivateKey), X509Certificate.class);
        return (X509Certificate[])ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{certificate, issuerCertificate}), X509Certificate[].class);
    }

    @Test
    public void testShouldGenerateCertificate() throws Exception {
        CallSite[] callSiteArray = OcspCertificateValidatorGroovyTest.$getCallSiteArray();
        String testDn = "CN=This is a test";
        X509Certificate certificate = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[66].callStatic(OcspCertificateValidatorGroovyTest.class, (Object)testDn);
            certificate = (X509Certificate)ScriptBytecodeAdapter.castToType((Object)object, X509Certificate.class);
        } else {
            X509Certificate x509Certificate;
            certificate = x509Certificate = OcspCertificateValidatorGroovyTest.generateCertificate(testDn);
        }
        callSiteArray[67].call((Object)logger, (Object)"Generated certificate: \n{}", (Object)certificate);
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            CallSite callSite = callSiteArray[68];
            CallSite callSite2 = callSiteArray[69];
            CallSite callSite3 = callSiteArray[70];
            X509Certificate x509Certificate = certificate;
            valueRecorder.record((Object)x509Certificate, 8);
            Object object = callSite3.call((Object)x509Certificate);
            valueRecorder.record(object, 20);
            Object object2 = callSite2.call(object);
            valueRecorder.record(object2, 35);
            String string = testDn;
            valueRecorder.record((Object)string, 52);
            Object object3 = callSite.call(object2, (Object)string);
            valueRecorder.record(object3, 45);
            if (DefaultTypeTransformation.booleanUnbox((Object)object3)) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert certificate.getSubjectDN().getName().equals(testDn)", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        ValueRecorder valueRecorder2 = new ValueRecorder();
        try {
            CallSite callSite = callSiteArray[71];
            CallSite callSite4 = callSiteArray[72];
            CallSite callSite5 = callSiteArray[73];
            X509Certificate x509Certificate = certificate;
            valueRecorder2.record((Object)x509Certificate, 8);
            Object object = callSite5.call((Object)x509Certificate);
            valueRecorder2.record(object, 20);
            Object object4 = callSite4.call(object);
            valueRecorder2.record(object4, 34);
            String string = testDn;
            valueRecorder2.record((Object)string, 51);
            Object object5 = callSite.call(object4, (Object)string);
            valueRecorder2.record(object5, 44);
            if (DefaultTypeTransformation.booleanUnbox((Object)object5)) {
                valueRecorder2.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert certificate.getIssuerDN().getName().equals(testDn)", (ValueRecorder)valueRecorder2), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder2.clear();
            throw throwable;
        }
        callSiteArray[74].call((Object)certificate, callSiteArray[75].call((Object)certificate));
    }

    @Test
    public void testShouldGenerateCertificateFromKeyPair() throws Exception {
        CallSite[] callSiteArray = OcspCertificateValidatorGroovyTest.$getCallSiteArray();
        String testDn = "CN=This is a test";
        KeyPair keyPair = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[76].callStatic(OcspCertificateValidatorGroovyTest.class);
            keyPair = (KeyPair)ScriptBytecodeAdapter.castToType((Object)object, KeyPair.class);
        } else {
            KeyPair keyPair2;
            keyPair = keyPair2 = OcspCertificateValidatorGroovyTest.generateKeyPair();
        }
        X509Certificate certificate = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[77].callStatic(OcspCertificateValidatorGroovyTest.class, (Object)testDn, (Object)keyPair);
            certificate = (X509Certificate)ScriptBytecodeAdapter.castToType((Object)object, X509Certificate.class);
        } else {
            X509Certificate x509Certificate;
            certificate = x509Certificate = OcspCertificateValidatorGroovyTest.generateCertificate(testDn, keyPair);
        }
        callSiteArray[78].call((Object)logger, (Object)"Generated certificate: \n{}", (Object)certificate);
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            CallSite callSite = callSiteArray[79];
            CallSite callSite2 = callSiteArray[80];
            X509Certificate x509Certificate = certificate;
            valueRecorder.record((Object)x509Certificate, 8);
            Object object = callSite2.call((Object)x509Certificate);
            valueRecorder.record(object, 20);
            CallSite callSite3 = callSiteArray[81];
            KeyPair keyPair3 = keyPair;
            valueRecorder.record((Object)keyPair3, 42);
            Object object2 = callSite3.call((Object)keyPair3);
            valueRecorder.record(object2, 50);
            Object object3 = callSite.call(object, object2);
            valueRecorder.record(object3, 35);
            if (DefaultTypeTransformation.booleanUnbox((Object)object3)) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert certificate.getPublicKey().equals(keyPair.getPublic())", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        ValueRecorder valueRecorder2 = new ValueRecorder();
        try {
            CallSite callSite = callSiteArray[82];
            CallSite callSite4 = callSiteArray[83];
            CallSite callSite5 = callSiteArray[84];
            X509Certificate x509Certificate = certificate;
            valueRecorder2.record((Object)x509Certificate, 8);
            Object object = callSite5.call((Object)x509Certificate);
            valueRecorder2.record(object, 20);
            Object object4 = callSite4.call(object);
            valueRecorder2.record(object4, 35);
            String string = testDn;
            valueRecorder2.record((Object)string, 52);
            Object object5 = callSite.call(object4, (Object)string);
            valueRecorder2.record(object5, 45);
            if (DefaultTypeTransformation.booleanUnbox((Object)object5)) {
                valueRecorder2.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert certificate.getSubjectDN().getName().equals(testDn)", (ValueRecorder)valueRecorder2), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder2.clear();
            throw throwable;
        }
        ValueRecorder valueRecorder3 = new ValueRecorder();
        try {
            CallSite callSite = callSiteArray[85];
            CallSite callSite6 = callSiteArray[86];
            CallSite callSite7 = callSiteArray[87];
            X509Certificate x509Certificate = certificate;
            valueRecorder3.record((Object)x509Certificate, 8);
            Object object = callSite7.call((Object)x509Certificate);
            valueRecorder3.record(object, 20);
            Object object6 = callSite6.call(object);
            valueRecorder3.record(object6, 34);
            String string = testDn;
            valueRecorder3.record((Object)string, 51);
            Object object7 = callSite.call(object6, (Object)string);
            valueRecorder3.record(object7, 44);
            if (DefaultTypeTransformation.booleanUnbox((Object)object7)) {
                valueRecorder3.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert certificate.getIssuerDN().getName().equals(testDn)", (ValueRecorder)valueRecorder3), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder3.clear();
            throw throwable;
        }
        callSiteArray[88].call((Object)certificate, callSiteArray[89].call((Object)certificate));
    }

    @Test
    public void testShouldGenerateIssuedCertificate() throws Exception {
        block23: {
            CallSite[] callSiteArray = OcspCertificateValidatorGroovyTest.$getCallSiteArray();
            String testDn = "CN=This is a signed test";
            String issuerDn = "CN=Issuer CA";
            KeyPair issuerKeyPair = null;
            if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                Object object = callSiteArray[90].callStatic(OcspCertificateValidatorGroovyTest.class);
                issuerKeyPair = (KeyPair)ScriptBytecodeAdapter.castToType((Object)object, KeyPair.class);
            } else {
                KeyPair keyPair;
                issuerKeyPair = keyPair = OcspCertificateValidatorGroovyTest.generateKeyPair();
            }
            PrivateKey issuerPrivateKey = (PrivateKey)ScriptBytecodeAdapter.castToType((Object)callSiteArray[91].call((Object)issuerKeyPair), PrivateKey.class);
            X509Certificate issuerCertificate = null;
            if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                Object object = callSiteArray[92].callStatic(OcspCertificateValidatorGroovyTest.class, (Object)issuerDn, (Object)issuerKeyPair);
                issuerCertificate = (X509Certificate)ScriptBytecodeAdapter.castToType((Object)object, X509Certificate.class);
            } else {
                X509Certificate x509Certificate;
                issuerCertificate = x509Certificate = OcspCertificateValidatorGroovyTest.generateCertificate(issuerDn, issuerKeyPair);
            }
            callSiteArray[93].call((Object)logger, (Object)"Generated issuer certificate: \n{}", (Object)issuerCertificate);
            X509Certificate certificate = (X509Certificate)ScriptBytecodeAdapter.castToType((Object)callSiteArray[94].callStatic(OcspCertificateValidatorGroovyTest.class, (Object)testDn, (Object)issuerDn, (Object)issuerPrivateKey), X509Certificate.class);
            callSiteArray[95].call((Object)logger, (Object)"Generated signed certificate: \n{}", (Object)certificate);
            ValueRecorder valueRecorder = new ValueRecorder();
            try {
                CallSite callSite = callSiteArray[96];
                CallSite callSite2 = callSiteArray[97];
                X509Certificate x509Certificate = issuerCertificate;
                valueRecorder.record((Object)x509Certificate, 8);
                Object object = callSite2.call((Object)x509Certificate);
                valueRecorder.record(object, 26);
                CallSite callSite3 = callSiteArray[98];
                KeyPair keyPair = issuerKeyPair;
                valueRecorder.record((Object)keyPair, 48);
                Object object2 = callSite3.call((Object)keyPair);
                valueRecorder.record(object2, 62);
                Object object3 = callSite.call(object, object2);
                valueRecorder.record(object3, 41);
                if (DefaultTypeTransformation.booleanUnbox((Object)object3)) {
                    valueRecorder.clear();
                } else {
                    ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert issuerCertificate.getPublicKey().equals(issuerKeyPair.getPublic())", (ValueRecorder)valueRecorder), null);
                }
            }
            catch (Throwable throwable) {
                valueRecorder.clear();
                throw throwable;
            }
            ValueRecorder valueRecorder2 = new ValueRecorder();
            try {
                CallSite callSite = callSiteArray[99];
                CallSite callSite4 = callSiteArray[100];
                CallSite callSite5 = callSiteArray[101];
                X509Certificate x509Certificate = certificate;
                valueRecorder2.record((Object)x509Certificate, 8);
                Object object = callSite5.call((Object)x509Certificate);
                valueRecorder2.record(object, 20);
                Object object4 = callSite4.call(object);
                valueRecorder2.record(object4, 46);
                String string = testDn;
                valueRecorder2.record((Object)string, 63);
                Object object5 = callSite.call(object4, (Object)string);
                valueRecorder2.record(object5, 56);
                if (DefaultTypeTransformation.booleanUnbox((Object)object5)) {
                    valueRecorder2.clear();
                } else {
                    ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert certificate.getSubjectX500Principal().getName().equals(testDn)", (ValueRecorder)valueRecorder2), null);
                }
            }
            catch (Throwable throwable) {
                valueRecorder2.clear();
                throw throwable;
            }
            ValueRecorder valueRecorder3 = new ValueRecorder();
            try {
                CallSite callSite = callSiteArray[102];
                CallSite callSite6 = callSiteArray[103];
                CallSite callSite7 = callSiteArray[104];
                X509Certificate x509Certificate = certificate;
                valueRecorder3.record((Object)x509Certificate, 8);
                Object object = callSite7.call((Object)x509Certificate);
                valueRecorder3.record(object, 20);
                Object object6 = callSite6.call(object);
                valueRecorder3.record(object6, 45);
                String string = issuerDn;
                valueRecorder3.record((Object)string, 62);
                Object object7 = callSite.call(object6, (Object)string);
                valueRecorder3.record(object7, 55);
                if (DefaultTypeTransformation.booleanUnbox((Object)object7)) {
                    valueRecorder3.clear();
                } else {
                    ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert certificate.getIssuerX500Principal().getName().equals(issuerDn)", (ValueRecorder)valueRecorder3), null);
                }
            }
            catch (Throwable throwable) {
                valueRecorder3.clear();
                throw throwable;
            }
            callSiteArray[105].call((Object)certificate, callSiteArray[106].call((Object)issuerCertificate));
            try {
                callSiteArray[107].call((Object)certificate, callSiteArray[108].call((Object)certificate));
                callSiteArray[109].callStatic(Assert.class, (Object)"Should have thrown exception");
            }
            catch (Exception e) {
                ValueRecorder valueRecorder4 = new ValueRecorder();
                Exception exception = e;
                valueRecorder4.record((Object)exception, 8);
                boolean bl = exception instanceof SignatureException;
                valueRecorder4.record((Object)bl, 10);
                if (bl) {
                    valueRecorder4.clear();
                } else {
                    ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert e instanceof SignatureException", (ValueRecorder)valueRecorder4), null);
                }
                ValueRecorder valueRecorder5 = new ValueRecorder();
                CallSite callSite = callSiteArray[110];
                CallSite callSite8 = callSiteArray[111];
                Exception exception2 = e;
                valueRecorder5.record((Object)exception2, 8);
                Object object = callSite8.call((Object)exception2);
                valueRecorder5.record(object, 10);
                Object object8 = callSite.call(object, (Object)"certificate does not verify with supplied key");
                valueRecorder5.record(object8, 23);
                if (DefaultTypeTransformation.booleanUnbox((Object)object8)) {
                    valueRecorder5.clear();
                    break block23;
                }
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert e.getMessage().contains(\"certificate does not verify with supplied key\")", (ValueRecorder)valueRecorder5), null);
            }
        }
    }

    @Test
    public void testShouldValidateCertificate() throws Exception {
        CallSite[] callSiteArray = OcspCertificateValidatorGroovyTest.$getCallSiteArray();
        X509Certificate[] certificateChain = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[112].callStatic(OcspCertificateValidatorGroovyTest.class);
            certificateChain = (X509Certificate[])ScriptBytecodeAdapter.castToType((Object)object, X509Certificate[].class);
        } else {
            X509Certificate[] x509CertificateArray;
            certificateChain = x509CertificateArray = OcspCertificateValidatorGroovyTest.generateCertificateChain();
        }
        Object object = callSiteArray[113].callConstructor(OcspCertificateValidator.class, (Object)this.mockProperties);
        this.certificateValidator = (OcspCertificateValidator)ScriptBytecodeAdapter.castToType((Object)object, OcspCertificateValidator.class);
        Object object2 = callSiteArray[114].call(callSiteArray[115].call(ClientBuilder.class));
        ScriptBytecodeAdapter.setProperty((Object)object2, null, (Object)this.certificateValidator, (String)"client");
        OcspRequest revokedRequest = (OcspRequest)ScriptBytecodeAdapter.castToType((Object)callSiteArray[116].callConstructor(OcspRequest.class, callSiteArray[117].call((Object)certificateChain), callSiteArray[118].call((Object)certificateChain)), OcspRequest.class);
        OcspStatus revokedStatus = (OcspStatus)ScriptBytecodeAdapter.castToType((Object)callSiteArray[119].callConstructor(OcspStatus.class), OcspStatus.class);
        Object object3 = callSiteArray[120].callGetProperty(OcspStatus.ResponseStatus.class);
        ScriptBytecodeAdapter.setProperty((Object)object3, null, (Object)revokedStatus, (String)"responseStatus");
        Object object4 = callSiteArray[121].callGetProperty(OcspStatus.ValidationStatus.class);
        ScriptBytecodeAdapter.setProperty((Object)object4, null, (Object)revokedStatus, (String)"validationStatus");
        Object object5 = callSiteArray[122].callGetProperty(OcspStatus.VerificationStatus.class);
        ScriptBytecodeAdapter.setProperty((Object)object5, null, (Object)revokedStatus, (String)"verificationStatus");
        LoadingCache cacheWithRevokedCertificate = (LoadingCache)ScriptBytecodeAdapter.castToType((Object)callSiteArray[123].callCurrent((GroovyObject)this, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{revokedRequest, revokedStatus})), LoadingCache.class);
        LoadingCache loadingCache = cacheWithRevokedCertificate;
        ScriptBytecodeAdapter.setProperty((Object)loadingCache, null, (Object)this.certificateValidator, (String)"ocspCache");
        callSiteArray[124].call((Object)this.certificateValidator, (Object)certificateChain);
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            if (true) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert true", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
    }

    @Ignore(value="To be implemented with Groovy test")
    @Test
    public void testShouldNotValidateEmptyCertificate() throws Exception {
        CallSite[] callSiteArray = OcspCertificateValidatorGroovyTest.$getCallSiteArray();
    }

    @Test
    public void testShouldNotValidateRevokedCertificate() throws Exception {
        CallSite[] callSiteArray = OcspCertificateValidatorGroovyTest.$getCallSiteArray();
        Reference certificateChain = new Reference(null);
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[125].callStatic(OcspCertificateValidatorGroovyTest.class);
            certificateChain.set((Object)((X509Certificate[])ScriptBytecodeAdapter.castToType((Object)object, X509Certificate[].class)));
        } else {
            X509Certificate[] x509CertificateArray = OcspCertificateValidatorGroovyTest.generateCertificateChain();
            certificateChain.set((Object)x509CertificateArray);
        }
        Object object = callSiteArray[126].callConstructor(OcspCertificateValidator.class, (Object)this.mockProperties);
        this.certificateValidator = (OcspCertificateValidator)ScriptBytecodeAdapter.castToType((Object)object, OcspCertificateValidator.class);
        Object object2 = callSiteArray[127].call(callSiteArray[128].call(ClientBuilder.class));
        ScriptBytecodeAdapter.setProperty((Object)object2, null, (Object)this.certificateValidator, (String)"client");
        OcspRequest revokedRequest = (OcspRequest)ScriptBytecodeAdapter.castToType((Object)callSiteArray[129].callConstructor(OcspRequest.class, callSiteArray[130].call((Object)((X509Certificate[])certificateChain.get())), callSiteArray[131].call((Object)((X509Certificate[])certificateChain.get()))), OcspRequest.class);
        OcspStatus revokedStatus = (OcspStatus)ScriptBytecodeAdapter.castToType((Object)callSiteArray[132].callConstructor(OcspStatus.class), OcspStatus.class);
        Object object3 = callSiteArray[133].callGetProperty(OcspStatus.ResponseStatus.class);
        ScriptBytecodeAdapter.setProperty((Object)object3, null, (Object)revokedStatus, (String)"responseStatus");
        Object object4 = callSiteArray[134].callGetProperty(OcspStatus.ValidationStatus.class);
        ScriptBytecodeAdapter.setProperty((Object)object4, null, (Object)revokedStatus, (String)"validationStatus");
        Object object5 = callSiteArray[135].callGetProperty(OcspStatus.VerificationStatus.class);
        ScriptBytecodeAdapter.setProperty((Object)object5, null, (Object)revokedStatus, (String)"verificationStatus");
        LoadingCache cacheWithRevokedCertificate = (LoadingCache)ScriptBytecodeAdapter.castToType((Object)callSiteArray[136].callCurrent((GroovyObject)this, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{revokedRequest, revokedStatus})), LoadingCache.class);
        LoadingCache loadingCache = cacheWithRevokedCertificate;
        ScriptBytecodeAdapter.setProperty((Object)loadingCache, null, (Object)this.certificateValidator, (String)"ocspCache");
        public final class _testShouldNotValidateRevokedCertificate_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference certificateChain;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _testShouldNotValidateRevokedCertificate_closure1(Object _outerInstance, Object _thisObject, Reference certificateChain) {
                Reference reference;
                CallSite[] callSiteArray = _testShouldNotValidateRevokedCertificate_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.certificateChain = reference = certificateChain;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _testShouldNotValidateRevokedCertificate_closure1.$getCallSiteArray();
                return callSiteArray[0].call(callSiteArray[1].callGroovyObjectGetProperty((Object)this), this.certificateChain.get());
            }

            public X509Certificate[] getCertificateChain() {
                CallSite[] callSiteArray = _testShouldNotValidateRevokedCertificate_closure1.$getCallSiteArray();
                return (X509Certificate[])ScriptBytecodeAdapter.castToType((Object)this.certificateChain.get(), X509Certificate[].class);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _testShouldNotValidateRevokedCertificate_closure1.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _testShouldNotValidateRevokedCertificate_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "validate";
                stringArray[1] = "certificateValidator";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _testShouldNotValidateRevokedCertificate_closure1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_testShouldNotValidateRevokedCertificate_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _testShouldNotValidateRevokedCertificate_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Object msg = callSiteArray[137].callStatic(GroovyAssert.class, CertificateStatusException.class, (Object)new _testShouldNotValidateRevokedCertificate_closure1(this, this, certificateChain));
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            Object object6 = msg;
            valueRecorder.record(object6, 8);
            Matcher matcher = ScriptBytecodeAdapter.findRegex((Object)object6, (Object)"is revoked according to the certificate authority");
            valueRecorder.record((Object)matcher, 12);
            if (DefaultTypeTransformation.booleanUnbox((Object)matcher)) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert msg =~ \"is revoked according to the certificate authority\"", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
    }

    public LoadingCache<OcspRequest, OcspStatus> buildCacheWithContents(Map map) {
        Reference map2 = new Reference((Object)map);
        CallSite[] callSiteArray = OcspCertificateValidatorGroovyTest.$getCallSiteArray();
        return (LoadingCache)ScriptBytecodeAdapter.castToType((Object)callSiteArray[138].call(callSiteArray[139].call(CacheBuilder.class), (Object)new GroovyObject(this, map2){
            public /* synthetic */ Reference map;
            public /* synthetic */ OcspCertificateValidatorGroovyTest this$0;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                MetaClass metaClass;
                Reference reference;
                OcspCertificateValidatorGroovyTest ocspCertificateValidatorGroovyTest;
                CallSite[] callSiteArray = 2.$getCallSiteArray();
                this.this$0 = ocspCertificateValidatorGroovyTest = p0;
                this.map = reference = p1;
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            public OcspStatus load(OcspRequest ocspRequest) throws Exception {
                CallSite[] callSiteArray = 2.$getCallSiteArray();
                callSiteArray[0].call(callSiteArray[1].callGetProperty(OcspCertificateValidatorGroovyTest.class), (Object)new GStringImpl(new Object[]{ocspRequest, callSiteArray[2].call(this.map.get(), (Object)ocspRequest)}, new String[]{"Mock cache implementation load(", ") returns ", ""}));
                return (OcspStatus)ScriptBytecodeAdapter.asType((Object)callSiteArray[3].call(this.map.get(), (Object)ocspRequest), OcspStatus.class);
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                CallSite[] callSiteArray = 2.$getCallSiteArray();
                return this.this$0.this$dist$invoke$1(name, args);
            }

            public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
                CallSite[] callSiteArray = 2.$getCallSiteArray();
                return ScriptBytecodeAdapter.invokeMethodN(2.class, OcspCertificateValidatorGroovyTest.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void propertyMissing(String name, Object val) {
                CallSite[] callSiteArray = 2.$getCallSiteArray();
                this.this$0.this$dist$set$1(name, val);
            }

            public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
                CallSite[] callSiteArray = 2.$getCallSiteArray();
                Object object = val;
                ScriptBytecodeAdapter.setProperty((Object)object, null, OcspCertificateValidatorGroovyTest.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public /* synthetic */ Object propertyMissing(String name) {
                CallSite[] callSiteArray = 2.$getCallSiteArray();
                return this.this$0.this$dist$get$1(name);
            }

            public static /* synthetic */ Object $static_propertyMissing(String name) {
                CallSite[] callSiteArray = 2.$getCallSiteArray();
                return ScriptBytecodeAdapter.getProperty(2.class, OcspCertificateValidatorGroovyTest.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != 2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            @Generated
            @Internal
            public /* synthetic */ MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            @Generated
            @Internal
            public /* synthetic */ void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }

            @Generated
            @Internal
            public /* synthetic */ Object invokeMethod(String string, Object object) {
                return this.getMetaClass().invokeMethod((Object)this, string, object);
            }

            @Generated
            @Internal
            public /* synthetic */ Object getProperty(String string) {
                return this.getMetaClass().getProperty((Object)this, string);
            }

            @Generated
            @Internal
            public /* synthetic */ void setProperty(String string, Object object) {
                this.getMetaClass().setProperty((Object)this, string, object);
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "info";
                stringArray[1] = "logger";
                stringArray[2] = "get";
                stringArray[3] = "get";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[4];
                2.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = 2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }), LoadingCache.class);
    }

    @Ignore(value="To be implemented with Groovy test")
    @Test
    public void testValidateShouldHandleUnsignedResponse() throws Exception {
        CallSite[] callSiteArray = OcspCertificateValidatorGroovyTest.$getCallSiteArray();
    }

    @Ignore(value="To be implemented with Groovy test")
    @Test
    public void testValidateShouldHandleResponseWithIncorrectNonce() throws Exception {
        CallSite[] callSiteArray = OcspCertificateValidatorGroovyTest.$getCallSiteArray();
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        CallSite[] callSiteArray = OcspCertificateValidatorGroovyTest.$getCallSiteArray();
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(OcspCertificateValidatorGroovyTest.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        CallSite[] callSiteArray = OcspCertificateValidatorGroovyTest.$getCallSiteArray();
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, OcspCertificateValidatorGroovyTest.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        CallSite[] callSiteArray = OcspCertificateValidatorGroovyTest.$getCallSiteArray();
        return ScriptBytecodeAdapter.getGroovyObjectProperty(OcspCertificateValidatorGroovyTest.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    @Generated
    private static X509Certificate[] generateCertificateChain(String dn) {
        CallSite[] callSiteArray = OcspCertificateValidatorGroovyTest.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return OcspCertificateValidatorGroovyTest.generateCertificateChain(dn, ISSUER_DN);
        }
        return OcspCertificateValidatorGroovyTest.generateCertificateChain(dn, ISSUER_DN);
    }

    @Generated
    private static X509Certificate[] generateCertificateChain() {
        CallSite[] callSiteArray = OcspCertificateValidatorGroovyTest.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return OcspCertificateValidatorGroovyTest.generateCertificateChain(SUBJECT_DN, ISSUER_DN);
        }
        return OcspCertificateValidatorGroovyTest.generateCertificateChain(SUBJECT_DN, ISSUER_DN);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != OcspCertificateValidatorGroovyTest.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Object object = OcspCertificateValidatorGroovyTest.$getCallSiteArray()[140].call(LoggerFactory.class, OcspCertificateValidatorGroovyTest.class);
        logger = (Logger)ScriptBytecodeAdapter.castToType((Object)object, Logger.class);
        if (!BytecodeInterface8.isOrigInt() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object2 = OcspCertificateValidatorGroovyTest.$getCallSiteArray()[141].call(OcspCertificateValidatorGroovyTest.$getCallSiteArray()[142].call(System.class), OcspCertificateValidatorGroovyTest.$getCallSiteArray()[143].call(OcspCertificateValidatorGroovyTest.$getCallSiteArray()[144].call(OcspCertificateValidatorGroovyTest.$getCallSiteArray()[145].call((Object)24, (Object)60), (Object)60), (Object)1000));
            YESTERDAY = DefaultTypeTransformation.longUnbox((Object)object2);
        } else {
            Object object3 = OcspCertificateValidatorGroovyTest.$getCallSiteArray()[146].call(OcspCertificateValidatorGroovyTest.$getCallSiteArray()[147].call(System.class), (Object)(24 * 60 * 60 * 1000));
            YESTERDAY = DefaultTypeTransformation.longUnbox((Object)object3);
        }
        if (!BytecodeInterface8.isOrigInt() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object4 = OcspCertificateValidatorGroovyTest.$getCallSiteArray()[148].call(OcspCertificateValidatorGroovyTest.$getCallSiteArray()[149].call(System.class), OcspCertificateValidatorGroovyTest.$getCallSiteArray()[150].call(OcspCertificateValidatorGroovyTest.$getCallSiteArray()[151].call(OcspCertificateValidatorGroovyTest.$getCallSiteArray()[152].call(OcspCertificateValidatorGroovyTest.$getCallSiteArray()[153].call((Object)365, (Object)24), (Object)60), (Object)60), (Object)1000));
            ONE_YEAR_FROM_NOW = DefaultTypeTransformation.longUnbox((Object)object4);
        } else {
            Object object5 = OcspCertificateValidatorGroovyTest.$getCallSiteArray()[154].call(OcspCertificateValidatorGroovyTest.$getCallSiteArray()[155].call(System.class), (Object)(365 * 24 * 60 * 60 * 1000));
            ONE_YEAR_FROM_NOW = DefaultTypeTransformation.longUnbox((Object)object5);
        }
    }

    @Generated
    public OcspCertificateValidator getCertificateValidator() {
        return this.certificateValidator;
    }

    @Generated
    public void setCertificateValidator(OcspCertificateValidator ocspCertificateValidator) {
        this.certificateValidator = ocspCertificateValidator;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "addProvider";
        stringArray[1] = "<$constructor$>";
        stringArray[2] = "getInstance";
        stringArray[3] = "initialize";
        stringArray[4] = "generateKeyPair";
        stringArray[5] = "generateKeyPair";
        stringArray[6] = "generateCertificate";
        stringArray[7] = "getPrivate";
        stringArray[8] = "build";
        stringArray[9] = "setProvider";
        stringArray[10] = "<$constructor$>";
        stringArray[11] = "getInstance";
        stringArray[12] = "getEncoded";
        stringArray[13] = "getPublic";
        stringArray[14] = "<$constructor$>";
        stringArray[15] = "<$constructor$>";
        stringArray[16] = "<$constructor$>";
        stringArray[17] = "<$constructor$>";
        stringArray[18] = "valueOf";
        stringArray[19] = "currentTimeMillis";
        stringArray[20] = "<$constructor$>";
        stringArray[21] = "addExtension";
        stringArray[22] = "keyUsage";
        stringArray[23] = "<$constructor$>";
        stringArray[24] = "or";
        stringArray[25] = "or";
        stringArray[26] = "or";
        stringArray[27] = "digitalSignature";
        stringArray[28] = "keyEncipherment";
        stringArray[29] = "dataEncipherment";
        stringArray[30] = "keyAgreement";
        stringArray[31] = "<$constructor$>";
        stringArray[32] = "add";
        stringArray[33] = "id_kp_clientAuth";
        stringArray[34] = "add";
        stringArray[35] = "id_kp_serverAuth";
        stringArray[36] = "addExtension";
        stringArray[37] = "extendedKeyUsage";
        stringArray[38] = "<$constructor$>";
        stringArray[39] = "build";
        stringArray[40] = "getCertificate";
        stringArray[41] = "setProvider";
        stringArray[42] = "<$constructor$>";
        stringArray[43] = "generateKeyPair";
        stringArray[44] = "generateIssuedCertificate";
        stringArray[45] = "getPublic";
        stringArray[46] = "build";
        stringArray[47] = "setProvider";
        stringArray[48] = "<$constructor$>";
        stringArray[49] = "getInstance";
        stringArray[50] = "getEncoded";
        stringArray[51] = "<$constructor$>";
        stringArray[52] = "<$constructor$>";
        stringArray[53] = "<$constructor$>";
        stringArray[54] = "<$constructor$>";
        stringArray[55] = "valueOf";
        stringArray[56] = "currentTimeMillis";
        stringArray[57] = "<$constructor$>";
        stringArray[58] = "build";
        stringArray[59] = "getCertificate";
        stringArray[60] = "setProvider";
        stringArray[61] = "<$constructor$>";
        stringArray[62] = "generateKeyPair";
        stringArray[63] = "getPrivate";
        stringArray[64] = "generateCertificate";
        stringArray[65] = "generateIssuedCertificate";
        stringArray[66] = "generateCertificate";
        stringArray[67] = "info";
        stringArray[68] = "equals";
        stringArray[69] = "getName";
        stringArray[70] = "getSubjectDN";
        stringArray[71] = "equals";
        stringArray[72] = "getName";
        stringArray[73] = "getIssuerDN";
        stringArray[74] = "verify";
        stringArray[75] = "getPublicKey";
        stringArray[76] = "generateKeyPair";
        stringArray[77] = "generateCertificate";
        stringArray[78] = "info";
        stringArray[79] = "equals";
        stringArray[80] = "getPublicKey";
        stringArray[81] = "getPublic";
        stringArray[82] = "equals";
        stringArray[83] = "getName";
        stringArray[84] = "getSubjectDN";
        stringArray[85] = "equals";
        stringArray[86] = "getName";
        stringArray[87] = "getIssuerDN";
        stringArray[88] = "verify";
        stringArray[89] = "getPublicKey";
        stringArray[90] = "generateKeyPair";
        stringArray[91] = "getPrivate";
        stringArray[92] = "generateCertificate";
        stringArray[93] = "info";
        stringArray[94] = "generateIssuedCertificate";
        stringArray[95] = "info";
        stringArray[96] = "equals";
        stringArray[97] = "getPublicKey";
        stringArray[98] = "getPublic";
        stringArray[99] = "equals";
        stringArray[100] = "getName";
        stringArray[101] = "getSubjectX500Principal";
        stringArray[102] = "equals";
        stringArray[103] = "getName";
        stringArray[104] = "getIssuerX500Principal";
        stringArray[105] = "verify";
        stringArray[106] = "getPublicKey";
        stringArray[107] = "verify";
        stringArray[108] = "getPublicKey";
        stringArray[109] = "fail";
        stringArray[110] = "contains";
        stringArray[111] = "getMessage";
        stringArray[112] = "generateCertificateChain";
        stringArray[113] = "<$constructor$>";
        stringArray[114] = "build";
        stringArray[115] = "newBuilder";
        stringArray[116] = "<$constructor$>";
        stringArray[117] = "first";
        stringArray[118] = "last";
        stringArray[119] = "<$constructor$>";
        stringArray[120] = "Successful";
        stringArray[121] = "Good";
        stringArray[122] = "Verified";
        stringArray[123] = "buildCacheWithContents";
        stringArray[124] = "validate";
        stringArray[125] = "generateCertificateChain";
        stringArray[126] = "<$constructor$>";
        stringArray[127] = "build";
        stringArray[128] = "newBuilder";
        stringArray[129] = "<$constructor$>";
        stringArray[130] = "first";
        stringArray[131] = "last";
        stringArray[132] = "<$constructor$>";
        stringArray[133] = "Successful";
        stringArray[134] = "Revoked";
        stringArray[135] = "Verified";
        stringArray[136] = "buildCacheWithContents";
        stringArray[137] = "shouldFail";
        stringArray[138] = "build";
        stringArray[139] = "newBuilder";
        stringArray[140] = "getLogger";
        stringArray[141] = "minus";
        stringArray[142] = "currentTimeMillis";
        stringArray[143] = "multiply";
        stringArray[144] = "multiply";
        stringArray[145] = "multiply";
        stringArray[146] = "minus";
        stringArray[147] = "currentTimeMillis";
        stringArray[148] = "plus";
        stringArray[149] = "currentTimeMillis";
        stringArray[150] = "multiply";
        stringArray[151] = "multiply";
        stringArray[152] = "multiply";
        stringArray[153] = "multiply";
        stringArray[154] = "plus";
        stringArray[155] = "currentTimeMillis";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[156];
        OcspCertificateValidatorGroovyTest.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(OcspCertificateValidatorGroovyTest.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = OcspCertificateValidatorGroovyTest.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

