/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.spring;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import groovy.util.GroovyTestCase;
import java.lang.ref.SoftReference;
import java.security.Security;
import java.util.List;
import javax.crypto.Cipher;
import org.apache.nifi.authentication.generated.Property;
import org.apache.nifi.authentication.generated.Provider;
import org.apache.nifi.properties.AESSensitivePropertyProvider;
import org.apache.nifi.web.security.spring.LoginIdentityProviderFactoryBean;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.powerassert.AssertionRenderer;
import org.codehaus.groovy.runtime.powerassert.ValueRecorder;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=JUnit4.class)
public class LoginIdentityProviderFactoryBeanTest
extends GroovyTestCase
implements GroovyObject {
    private static final Logger logger;
    private static final String KEY_HEX_128 = "0123456789ABCDEFFEDCBA9876543210";
    private static final String KEY_HEX_256;
    public static final String KEY_HEX;
    private static final String CIPHER_TEXT_128 = "6pqdM1urBEPHtj+L||ds0Z7RpqOA2321c/+7iPMfxDrqmH5Qx6UwQG0eIYB//3Ng";
    private static final String CIPHER_TEXT_256 = "TepMCD7v3LAMF0KX||ydSRWPRl1/JXgTsZtfzCnDXu7a0lTLysjPL2I06EPUCHzw";
    public static final String CIPHER_TEXT;
    private static final String ENCRYPTION_SCHEME_128 = "aes/gcm/128";
    private static final String ENCRYPTION_SCHEME_256 = "aes/gcm/256";
    public static final String ENCRYPTION_SCHEME;
    private static final String PASSWORD = "thisIsABadPassword";
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    public LoginIdentityProviderFactoryBeanTest() {
        MetaClass metaClass;
        CallSite[] callSiteArray = LoginIdentityProviderFactoryBeanTest.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @BeforeClass
    public static void setUpOnce() throws Exception {
        CallSite[] callSiteArray = LoginIdentityProviderFactoryBeanTest.$getCallSiteArray();
        callSiteArray[0].call(Security.class, callSiteArray[1].callConstructor(BouncyCastleProvider.class));
        public final class _setUpOnce_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _setUpOnce_closure1(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _setUpOnce_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(String name, Object args) {
                CallSite[] callSiteArray = _setUpOnce_closure1.$getCallSiteArray();
                return callSiteArray[0].call(callSiteArray[1].callGetProperty(LoginIdentityProviderFactoryBeanTest.class), (Object)new GStringImpl(new Object[]{callSiteArray[2].callSafe((Object)name), callSiteArray[3].call((Object)((List)ScriptBytecodeAdapter.asType((Object)args, List.class)), (Object)" ")}, new String[]{"[", "] ", ""}));
            }

            public Object call(String name, Object args) {
                CallSite[] callSiteArray = _setUpOnce_closure1.$getCallSiteArray();
                return callSiteArray[4].callCurrent((GroovyObject)this, (Object)name, args);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _setUpOnce_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "info";
                stringArray[1] = "logger";
                stringArray[2] = "toUpperCase";
                stringArray[3] = "join";
                stringArray[4] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[5];
                _setUpOnce_closure1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_setUpOnce_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _setUpOnce_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        _setUpOnce_closure1 _setUpOnce_closure12 = new _setUpOnce_closure1(LoginIdentityProviderFactoryBeanTest.class, LoginIdentityProviderFactoryBeanTest.class);
        ScriptBytecodeAdapter.setProperty((Object)((Object)_setUpOnce_closure12), null, (Object)callSiteArray[2].callGetProperty((Object)logger), (String)"methodMissing");
    }

    @AfterClass
    public static void tearDownOnce() throws Exception {
        CallSite[] callSiteArray = LoginIdentityProviderFactoryBeanTest.$getCallSiteArray();
    }

    @Before
    public void setUp() throws Exception {
        CallSite[] callSiteArray = LoginIdentityProviderFactoryBeanTest.$getCallSiteArray();
        Object object = callSiteArray[3].callConstructor(AESSensitivePropertyProvider.class, (Object)KEY_HEX);
        ScriptBytecodeAdapter.setProperty((Object)object, null, LoginIdentityProviderFactoryBean.class, (String)"SENSITIVE_PROPERTY_PROVIDER");
    }

    @After
    public void tearDown() throws Exception {
        CallSite[] callSiteArray = LoginIdentityProviderFactoryBeanTest.$getCallSiteArray();
        Object var2_2 = null;
        ScriptBytecodeAdapter.setProperty(var2_2, null, LoginIdentityProviderFactoryBean.class, (String)"SENSITIVE_PROPERTY_PROVIDER");
        Object var3_3 = null;
        ScriptBytecodeAdapter.setProperty(var3_3, null, LoginIdentityProviderFactoryBean.class, (String)"SENSITIVE_PROPERTY_PROVIDER_FACTORY");
    }

    private static boolean isUnlimitedStrengthCryptoAvailable() {
        CallSite[] callSiteArray = LoginIdentityProviderFactoryBeanTest.$getCallSiteArray();
        return ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[4].call(Cipher.class, (Object)"AES"), (Object)128);
    }

    private static int getKeyLength(String keyHex) {
        CallSite[] callSiteArray = LoginIdentityProviderFactoryBeanTest.$getCallSiteArray();
        return DefaultTypeTransformation.intUnbox((Object)callSiteArray[5].call(callSiteArray[6].callSafe((Object)keyHex), (Object)4));
    }

    @Ignore(value="Can't test without overloading static metaClass method")
    @Test
    public void testShouldInitializeSensitivePropertyProvider() {
        CallSite[] callSiteArray = LoginIdentityProviderFactoryBeanTest.$getCallSiteArray();
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            Object object = callSiteArray[7].callGetProperty(LoginIdentityProviderFactoryBean.class);
            valueRecorder.record(object, 42);
            boolean bl = !DefaultTypeTransformation.booleanUnbox((Object)object);
            valueRecorder.record((Object)bl, 8);
            if (bl) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert !LoginIdentityProviderFactoryBean.SENSITIVE_PROPERTY_PROVIDER", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        ValueRecorder valueRecorder2 = new ValueRecorder();
        try {
            Object object = callSiteArray[8].callGetProperty(LoginIdentityProviderFactoryBean.class);
            valueRecorder2.record(object, 42);
            boolean bl = !DefaultTypeTransformation.booleanUnbox((Object)object);
            valueRecorder2.record((Object)bl, 8);
            if (bl) {
                valueRecorder2.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert !LoginIdentityProviderFactoryBean.SENSITIVE_PROPERTY_PROVIDER_FACTORY", (ValueRecorder)valueRecorder2), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder2.clear();
            throw throwable;
        }
        callSiteArray[9].call((Object)logger, (Object)new GStringImpl(new Object[]{ENCRYPTION_SCHEME}, new String[]{"Encryption scheme: ", ""}));
        callSiteArray[10].call(LoginIdentityProviderFactoryBean.class, (Object)ENCRYPTION_SCHEME);
        ValueRecorder valueRecorder3 = new ValueRecorder();
        try {
            Object object = callSiteArray[11].callGetProperty(LoginIdentityProviderFactoryBean.class);
            valueRecorder3.record(object, 41);
            if (DefaultTypeTransformation.booleanUnbox((Object)object)) {
                valueRecorder3.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert LoginIdentityProviderFactoryBean.SENSITIVE_PROPERTY_PROVIDER", (ValueRecorder)valueRecorder3), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder3.clear();
            throw throwable;
        }
        ValueRecorder valueRecorder4 = new ValueRecorder();
        try {
            Object object = callSiteArray[12].callGetProperty(LoginIdentityProviderFactoryBean.class);
            valueRecorder4.record(object, 41);
            if (DefaultTypeTransformation.booleanUnbox((Object)object)) {
                valueRecorder4.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert LoginIdentityProviderFactoryBean.SENSITIVE_PROPERTY_PROVIDER_FACTORY", (ValueRecorder)valueRecorder4), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder4.clear();
            throw throwable;
        }
        ValueRecorder valueRecorder5 = new ValueRecorder();
        try {
            CallSite callSite = callSiteArray[13];
            Object object = callSiteArray[14].callGetProperty(LoginIdentityProviderFactoryBean.class);
            valueRecorder5.record(object, 41);
            Object object2 = callSite.call(object);
            valueRecorder5.record(object2, 69);
            String string = ENCRYPTION_SCHEME;
            valueRecorder5.record((Object)string, 91);
            valueRecorder5.record((Object)string, 91);
            boolean bl = ScriptBytecodeAdapter.compareEqual((Object)object2, (Object)string);
            valueRecorder5.record((Object)bl, 88);
            if (bl) {
                valueRecorder5.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert LoginIdentityProviderFactoryBean.SENSITIVE_PROPERTY_PROVIDER.getIdentifierKey() == ENCRYPTION_SCHEME", (ValueRecorder)valueRecorder5), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder5.clear();
            throw throwable;
        }
    }

    @Test
    public void testShouldDecryptValue() {
        CallSite[] callSiteArray = LoginIdentityProviderFactoryBeanTest.$getCallSiteArray();
        callSiteArray[15].call((Object)logger, (Object)new GStringImpl(new Object[]{ENCRYPTION_SCHEME}, new String[]{"Encryption scheme: ", ""}));
        callSiteArray[16].call((Object)logger, (Object)new GStringImpl(new Object[]{CIPHER_TEXT}, new String[]{"Cipher text: ", ""}));
        String decrypted = ShortTypeHandling.castToString((Object)callSiteArray[17].call(callSiteArray[18].callConstructor(LoginIdentityProviderFactoryBean.class), (Object)CIPHER_TEXT, (Object)ENCRYPTION_SCHEME));
        callSiteArray[19].call((Object)logger, (Object)new GStringImpl(new Object[]{CIPHER_TEXT, decrypted}, new String[]{"Decrypted ", " -> ", ""}));
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            String string = decrypted;
            valueRecorder.record((Object)string, 8);
            String string2 = PASSWORD;
            valueRecorder.record((Object)string2, 21);
            valueRecorder.record((Object)string2, 21);
            boolean bl = ScriptBytecodeAdapter.compareEqual((Object)string, (Object)string2);
            valueRecorder.record((Object)bl, 18);
            if (bl) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert decrypted == PASSWORD", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
    }

    @Test
    public void testShouldLoadEncryptedLoginIdentityProviderConfiguration() {
        CallSite[] callSiteArray = LoginIdentityProviderFactoryBeanTest.$getCallSiteArray();
        Provider encryptedProvider = (Provider)ScriptBytecodeAdapter.castToType((Object)callSiteArray[20].callConstructor(Provider.class), Provider.class);
        String string = "ldap-provider";
        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)encryptedProvider, (String)"identifier");
        String string2 = "org.apache.nifi.ldap.LdapProvider";
        ScriptBytecodeAdapter.setProperty((Object)string2, null, (Object)encryptedProvider, (String)"clazz");
        String managerPasswordName = "Manager Password";
        Property managerPasswordProperty = (Property)ScriptBytecodeAdapter.castToType((Object)callSiteArray[21].callConstructor(Property.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", managerPasswordName, "value", CIPHER_TEXT, "encryption", ENCRYPTION_SCHEME})), Property.class);
        List list = ScriptBytecodeAdapter.createList((Object[])new Object[]{managerPasswordProperty});
        ScriptBytecodeAdapter.setProperty((Object)list, null, (Object)encryptedProvider, (String)"property");
        callSiteArray[22].call((Object)logger, (Object)new GStringImpl(new Object[]{callSiteArray[23].call((Object)managerPasswordProperty)}, new String[]{"Manager Password property: ", ""}));
        Object bean = callSiteArray[24].callConstructor(LoginIdentityProviderFactoryBean.class);
        Object context = callSiteArray[25].call(bean, (Object)encryptedProvider);
        callSiteArray[26].call((Object)logger, (Object)new GStringImpl(new Object[]{callSiteArray[27].call(context)}, new String[]{"Loaded context: ", ""}));
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            CallSite callSite = callSiteArray[28];
            Object object = context;
            valueRecorder.record(object, 8);
            String string3 = managerPasswordName;
            valueRecorder.record((Object)string3, 28);
            Object object2 = callSite.call(object, (Object)string3);
            valueRecorder.record(object2, 16);
            String string4 = PASSWORD;
            valueRecorder.record((Object)string4, 52);
            valueRecorder.record((Object)string4, 52);
            boolean bl = ScriptBytecodeAdapter.compareEqual((Object)object2, (Object)string4);
            valueRecorder.record((Object)bl, 49);
            if (bl) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert context.getProperty(managerPasswordName) == PASSWORD", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
    }

    @Generated
    private static int getKeyLength() {
        CallSite[] callSiteArray = LoginIdentityProviderFactoryBeanTest.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return LoginIdentityProviderFactoryBeanTest.getKeyLength(KEY_HEX);
        }
        return LoginIdentityProviderFactoryBeanTest.getKeyLength(KEY_HEX);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != LoginIdentityProviderFactoryBeanTest.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        Object object = LoginIdentityProviderFactoryBeanTest.$getCallSiteArray()[29].call(LoggerFactory.class, LoginIdentityProviderFactoryBeanTest.class);
        logger = (Logger)ScriptBytecodeAdapter.castToType((Object)object, Logger.class);
        Object object2 = LoginIdentityProviderFactoryBeanTest.$getCallSiteArray()[30].call((Object)KEY_HEX_128, (Object)2);
        KEY_HEX_256 = ShortTypeHandling.castToString((Object)object2);
        KEY_HEX = __$stMC || BytecodeInterface8.disabledStandardMetaClass() ? (string6 = DefaultTypeTransformation.booleanUnbox((Object)LoginIdentityProviderFactoryBeanTest.$getCallSiteArray()[31].callStatic(LoginIdentityProviderFactoryBeanTest.class)) ? KEY_HEX_256 : KEY_HEX_128) : (string5 = LoginIdentityProviderFactoryBeanTest.isUnlimitedStrengthCryptoAvailable() ? KEY_HEX_256 : KEY_HEX_128);
        CIPHER_TEXT = __$stMC || BytecodeInterface8.disabledStandardMetaClass() ? (string4 = DefaultTypeTransformation.booleanUnbox((Object)LoginIdentityProviderFactoryBeanTest.$getCallSiteArray()[32].callStatic(LoginIdentityProviderFactoryBeanTest.class)) ? CIPHER_TEXT_256 : CIPHER_TEXT_128) : (string3 = LoginIdentityProviderFactoryBeanTest.isUnlimitedStrengthCryptoAvailable() ? CIPHER_TEXT_256 : CIPHER_TEXT_128);
        ENCRYPTION_SCHEME = __$stMC || BytecodeInterface8.disabledStandardMetaClass() ? (string2 = DefaultTypeTransformation.booleanUnbox((Object)LoginIdentityProviderFactoryBeanTest.$getCallSiteArray()[33].callStatic(LoginIdentityProviderFactoryBeanTest.class)) ? ENCRYPTION_SCHEME_256 : ENCRYPTION_SCHEME_128) : (string = LoginIdentityProviderFactoryBeanTest.isUnlimitedStrengthCryptoAvailable() ? ENCRYPTION_SCHEME_256 : ENCRYPTION_SCHEME_128);
    }

    public /* synthetic */ void super$3$setUp() {
        super.setUp();
    }

    public /* synthetic */ void super$3$tearDown() {
        super.tearDown();
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "addProvider";
        stringArray[1] = "<$constructor$>";
        stringArray[2] = "metaClass";
        stringArray[3] = "<$constructor$>";
        stringArray[4] = "getMaxAllowedKeyLength";
        stringArray[5] = "multiply";
        stringArray[6] = "size";
        stringArray[7] = "SENSITIVE_PROPERTY_PROVIDER";
        stringArray[8] = "SENSITIVE_PROPERTY_PROVIDER_FACTORY";
        stringArray[9] = "info";
        stringArray[10] = "initializeSensitivePropertyProvider";
        stringArray[11] = "SENSITIVE_PROPERTY_PROVIDER";
        stringArray[12] = "SENSITIVE_PROPERTY_PROVIDER_FACTORY";
        stringArray[13] = "getIdentifierKey";
        stringArray[14] = "SENSITIVE_PROPERTY_PROVIDER";
        stringArray[15] = "info";
        stringArray[16] = "info";
        stringArray[17] = "decryptValue";
        stringArray[18] = "<$constructor$>";
        stringArray[19] = "info";
        stringArray[20] = "<$constructor$>";
        stringArray[21] = "<$constructor$>";
        stringArray[22] = "info";
        stringArray[23] = "dump";
        stringArray[24] = "<$constructor$>";
        stringArray[25] = "loadLoginIdentityProviderConfiguration";
        stringArray[26] = "info";
        stringArray[27] = "dump";
        stringArray[28] = "getProperty";
        stringArray[29] = "getLogger";
        stringArray[30] = "multiply";
        stringArray[31] = "isUnlimitedStrengthCryptoAvailable";
        stringArray[32] = "isUnlimitedStrengthCryptoAvailable";
        stringArray[33] = "isUnlimitedStrengthCryptoAvailable";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[34];
        LoginIdentityProviderFactoryBeanTest.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(LoginIdentityProviderFactoryBeanTest.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = LoginIdentityProviderFactoryBeanTest.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

