/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.otp;

import java.util.concurrent.TimeUnit;
import org.apache.nifi.web.security.otp.OtpAuthenticationException;
import org.apache.nifi.web.security.otp.OtpService;
import org.apache.nifi.web.security.token.OtpAuthenticationToken;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class OtpServiceTest {
    private static final String USER_1 = "user-identity-1";
    private OtpService otpService;

    @Before
    public void setUp() throws Exception {
        this.otpService = new OtpService();
    }

    @Test
    public void testGetAuthenticationForValidDownloadToken() throws Exception {
        OtpAuthenticationToken authenticationToken = new OtpAuthenticationToken(USER_1);
        String downloadToken = this.otpService.generateDownloadToken(authenticationToken);
        String authenticatedUser = this.otpService.getAuthenticationFromDownloadToken(downloadToken);
        Assert.assertNotNull((Object)authenticatedUser);
        Assert.assertEquals((Object)USER_1, (Object)authenticatedUser);
        try {
            this.otpService.getAuthenticationFromDownloadToken(downloadToken);
            Assert.fail();
        }
        catch (OtpAuthenticationException otpAuthenticationException) {
            // empty catch block
        }
    }

    @Test
    public void testGetAuthenticationForValidUiExtensionToken() throws Exception {
        OtpAuthenticationToken authenticationToken = new OtpAuthenticationToken(USER_1);
        String uiExtensionToken = this.otpService.generateUiExtensionToken(authenticationToken);
        String authenticatedUser = this.otpService.getAuthenticationFromUiExtensionToken(uiExtensionToken);
        Assert.assertNotNull((Object)authenticatedUser);
        Assert.assertEquals((Object)USER_1, (Object)authenticatedUser);
        try {
            this.otpService.getAuthenticationFromUiExtensionToken(uiExtensionToken);
            Assert.fail();
        }
        catch (OtpAuthenticationException otpAuthenticationException) {
            // empty catch block
        }
    }

    @Test(expected=OtpAuthenticationException.class)
    public void testGetNonExistentDownloadToken() throws Exception {
        this.otpService.getAuthenticationFromDownloadToken("Not a real download token");
    }

    @Test(expected=OtpAuthenticationException.class)
    public void testGetNonExistentUiExtensionToken() throws Exception {
        this.otpService.getAuthenticationFromUiExtensionToken("Not a real ui extension token");
    }

    @Test(expected=IllegalStateException.class)
    public void testMaxDownloadTokenLimit() throws Exception {
        for (int i = 1; i < 110; ++i) {
            try {
                OtpAuthenticationToken authenticationToken = new OtpAuthenticationToken("user-identity-" + i);
                this.otpService.generateDownloadToken(authenticationToken);
                continue;
            }
            catch (IllegalStateException iae) {
                Assert.assertEquals((long)101L, (long)i);
                throw iae;
            }
        }
    }

    @Test(expected=IllegalStateException.class)
    public void testMaxUiExtensionTokenLimit() throws Exception {
        for (int i = 1; i < 110; ++i) {
            try {
                OtpAuthenticationToken authenticationToken = new OtpAuthenticationToken("user-identity-" + i);
                this.otpService.generateUiExtensionToken(authenticationToken);
                continue;
            }
            catch (IllegalStateException iae) {
                Assert.assertEquals((long)101L, (long)i);
                throw iae;
            }
        }
    }

    @Test(expected=NullPointerException.class)
    public void testNullTimeUnits() throws Exception {
        new OtpService(0, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNegativeExpiration() throws Exception {
        new OtpService(-1, TimeUnit.MINUTES);
    }

    @Test(expected=OtpAuthenticationException.class)
    public void testUiExtensionTokenExpiration() throws Exception {
        OtpService otpServiceWithTightExpiration = new OtpService(2, TimeUnit.SECONDS);
        OtpAuthenticationToken authenticationToken = new OtpAuthenticationToken(USER_1);
        String downloadToken = otpServiceWithTightExpiration.generateUiExtensionToken(authenticationToken);
        Thread.sleep(4000L);
        otpServiceWithTightExpiration.getAuthenticationFromUiExtensionToken(downloadToken);
    }

    @Test(expected=OtpAuthenticationException.class)
    public void testDownloadTokenExpiration() throws Exception {
        OtpService otpServiceWithTightExpiration = new OtpService(2, TimeUnit.SECONDS);
        OtpAuthenticationToken authenticationToken = new OtpAuthenticationToken(USER_1);
        String downloadToken = otpServiceWithTightExpiration.generateDownloadToken(authenticationToken);
        Thread.sleep(4000L);
        otpServiceWithTightExpiration.getAuthenticationFromDownloadToken(downloadToken);
    }
}

