/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.otp;

import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.user.NiFiUserDetails;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.security.otp.OtpAuthenticationException;
import org.apache.nifi.web.security.otp.OtpAuthenticationProvider;
import org.apache.nifi.web.security.otp.OtpAuthenticationRequestToken;
import org.apache.nifi.web.security.otp.OtpService;
import org.apache.nifi.web.security.token.NiFiAuthenticationToken;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.springframework.security.core.Authentication;

public class OtpAuthenticationProviderTest {
    private static final String UI_EXTENSION_AUTHENTICATED_USER = "ui-extension-token-authenticated-user";
    private static final String UI_EXTENSION_TOKEN = "ui-extension-token";
    private static final String DOWNLOAD_AUTHENTICATED_USER = "download-token-authenticated-user";
    private static final String DOWNLOAD_TOKEN = "download-token";
    private OtpService otpService;
    private OtpAuthenticationProvider otpAuthenticationProvider;
    private NiFiProperties nifiProperties;

    @Before
    public void setUp() throws Exception {
        this.otpService = (OtpService)Mockito.mock(OtpService.class);
        ((OtpService)Mockito.doAnswer((Answer)new Answer<String>(){

            public String answer(InvocationOnMock invocation) throws Throwable {
                Object[] args = invocation.getArguments();
                String downloadToken = (String)args[0];
                if (OtpAuthenticationProviderTest.DOWNLOAD_TOKEN.equals(downloadToken)) {
                    return OtpAuthenticationProviderTest.DOWNLOAD_AUTHENTICATED_USER;
                }
                throw new OtpAuthenticationException("Invalid token");
            }
        }).when((Object)this.otpService)).getAuthenticationFromDownloadToken(ArgumentMatchers.anyString());
        ((OtpService)Mockito.doAnswer((Answer)new Answer<String>(){

            public String answer(InvocationOnMock invocation) throws Throwable {
                Object[] args = invocation.getArguments();
                String uiExtensionToken = (String)args[0];
                if (OtpAuthenticationProviderTest.UI_EXTENSION_TOKEN.equals(uiExtensionToken)) {
                    return OtpAuthenticationProviderTest.UI_EXTENSION_AUTHENTICATED_USER;
                }
                throw new OtpAuthenticationException("Invalid token");
            }
        }).when((Object)this.otpService)).getAuthenticationFromUiExtensionToken(ArgumentMatchers.anyString());
        this.otpAuthenticationProvider = new OtpAuthenticationProvider(this.otpService, (NiFiProperties)Mockito.mock(NiFiProperties.class), (Authorizer)Mockito.mock(Authorizer.class));
    }

    @Test
    public void testUiExtensionPath() throws Exception {
        OtpAuthenticationRequestToken request = new OtpAuthenticationRequestToken(UI_EXTENSION_TOKEN, false, null);
        NiFiAuthenticationToken result = (NiFiAuthenticationToken)this.otpAuthenticationProvider.authenticate((Authentication)request);
        NiFiUserDetails details = (NiFiUserDetails)result.getPrincipal();
        Assert.assertEquals((Object)UI_EXTENSION_AUTHENTICATED_USER, (Object)details.getUsername());
        ((OtpService)Mockito.verify((Object)this.otpService, (VerificationMode)Mockito.times((int)1))).getAuthenticationFromUiExtensionToken(UI_EXTENSION_TOKEN);
        ((OtpService)Mockito.verify((Object)this.otpService, (VerificationMode)Mockito.never())).getAuthenticationFromDownloadToken(ArgumentMatchers.anyString());
    }

    @Test
    public void testDownload() throws Exception {
        OtpAuthenticationRequestToken request = new OtpAuthenticationRequestToken(DOWNLOAD_TOKEN, true, null);
        NiFiAuthenticationToken result = (NiFiAuthenticationToken)this.otpAuthenticationProvider.authenticate((Authentication)request);
        NiFiUserDetails details = (NiFiUserDetails)result.getPrincipal();
        Assert.assertEquals((Object)DOWNLOAD_AUTHENTICATED_USER, (Object)details.getUsername());
        ((OtpService)Mockito.verify((Object)this.otpService, (VerificationMode)Mockito.never())).getAuthenticationFromUiExtensionToken(ArgumentMatchers.anyString());
        ((OtpService)Mockito.verify((Object)this.otpService, (VerificationMode)Mockito.times((int)1))).getAuthenticationFromDownloadToken(DOWNLOAD_TOKEN);
    }
}

