/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.otp;

import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.apache.nifi.web.security.otp.OtpAuthenticationFilter;
import org.apache.nifi.web.security.otp.OtpAuthenticationRequestToken;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class OtpAuthenticationFilterTest {
    private static final String UI_EXTENSION_AUTHENTICATED_USER = "ui-extension-token-authenticated-user";
    private static final String UI_EXTENSION_TOKEN = "ui-extension-token";
    private static final String DOWNLOAD_AUTHENTICATED_USER = "download-token-authenticated-user";
    private static final String DOWNLOAD_TOKEN = "download-token";
    private OtpAuthenticationFilter otpAuthenticationFilter;

    @Before
    public void setUp() throws Exception {
        this.otpAuthenticationFilter = new OtpAuthenticationFilter();
    }

    @Test
    public void testInsecureHttp() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.isSecure()).thenReturn((Object)false);
        Assert.assertNull((Object)this.otpAuthenticationFilter.attemptAuthentication(request));
    }

    @Test
    public void testNoAccessToken() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.isSecure()).thenReturn((Object)true);
        Mockito.when((Object)request.getParameter("access_token")).thenReturn(null);
        Assert.assertNull((Object)this.otpAuthenticationFilter.attemptAuthentication(request));
    }

    @Test
    public void testUnsupportedDownloadPath() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.isSecure()).thenReturn((Object)true);
        Mockito.when((Object)request.getParameter("access_token")).thenReturn((Object)"my-access-token");
        Mockito.when((Object)request.getContextPath()).thenReturn((Object)"/nifi-api");
        Mockito.when((Object)request.getPathInfo()).thenReturn((Object)"/flow/cluster/summary");
        Assert.assertNull((Object)this.otpAuthenticationFilter.attemptAuthentication(request));
    }

    @Test
    public void testUiExtensionPath() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.isSecure()).thenReturn((Object)true);
        Mockito.when((Object)request.getParameter("access_token")).thenReturn((Object)UI_EXTENSION_TOKEN);
        Mockito.when((Object)request.getContextPath()).thenReturn((Object)"/nifi-update-attribute-ui");
        OtpAuthenticationRequestToken result = (OtpAuthenticationRequestToken)this.otpAuthenticationFilter.attemptAuthentication(request);
        Assert.assertEquals((Object)UI_EXTENSION_TOKEN, (Object)result.getToken());
        Assert.assertFalse((boolean)result.isDownloadToken());
    }

    @Test
    public void testProvenanceInputContentDownload() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.isSecure()).thenReturn((Object)true);
        Mockito.when((Object)request.getParameter("access_token")).thenReturn((Object)DOWNLOAD_TOKEN);
        Mockito.when((Object)request.getContextPath()).thenReturn((Object)"/nifi-api");
        Mockito.when((Object)request.getPathInfo()).thenReturn((Object)"/provenance-events/0/content/input");
        OtpAuthenticationRequestToken result = (OtpAuthenticationRequestToken)this.otpAuthenticationFilter.attemptAuthentication(request);
        Assert.assertEquals((Object)DOWNLOAD_TOKEN, (Object)result.getToken());
        Assert.assertTrue((boolean)result.isDownloadToken());
    }

    @Test
    public void testProvenanceOutputContentDownload() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.isSecure()).thenReturn((Object)true);
        Mockito.when((Object)request.getParameter("access_token")).thenReturn((Object)DOWNLOAD_TOKEN);
        Mockito.when((Object)request.getContextPath()).thenReturn((Object)"/nifi-api");
        Mockito.when((Object)request.getPathInfo()).thenReturn((Object)"/provenance-events/0/content/output");
        OtpAuthenticationRequestToken result = (OtpAuthenticationRequestToken)this.otpAuthenticationFilter.attemptAuthentication(request);
        Assert.assertEquals((Object)DOWNLOAD_TOKEN, (Object)result.getToken());
        Assert.assertTrue((boolean)result.isDownloadToken());
    }

    @Test
    public void testFlowFileContentDownload() throws Exception {
        String uuid = UUID.randomUUID().toString();
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.isSecure()).thenReturn((Object)true);
        Mockito.when((Object)request.getParameter("access_token")).thenReturn((Object)DOWNLOAD_TOKEN);
        Mockito.when((Object)request.getContextPath()).thenReturn((Object)"/nifi-api");
        Mockito.when((Object)request.getPathInfo()).thenReturn((Object)String.format("/flowfile-queues/%s/flowfiles/%s/content", uuid, uuid));
        OtpAuthenticationRequestToken result = (OtpAuthenticationRequestToken)this.otpAuthenticationFilter.attemptAuthentication(request);
        Assert.assertEquals((Object)DOWNLOAD_TOKEN, (Object)result.getToken());
        Assert.assertTrue((boolean)result.isDownloadToken());
    }

    @Test
    public void testTemplateDownload() throws Exception {
        String uuid = UUID.randomUUID().toString();
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.isSecure()).thenReturn((Object)true);
        Mockito.when((Object)request.getParameter("access_token")).thenReturn((Object)DOWNLOAD_TOKEN);
        Mockito.when((Object)request.getContextPath()).thenReturn((Object)"/nifi-api");
        Mockito.when((Object)request.getPathInfo()).thenReturn((Object)String.format("/templates/%s/download", uuid));
        OtpAuthenticationRequestToken result = (OtpAuthenticationRequestToken)this.otpAuthenticationFilter.attemptAuthentication(request);
        Assert.assertEquals((Object)DOWNLOAD_TOKEN, (Object)result.getToken());
        Assert.assertTrue((boolean)result.isDownloadToken());
    }
}

