/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.oidc;

import com.nimbusds.oauth2.sdk.AuthorizationCode;
import com.nimbusds.oauth2.sdk.AuthorizationCodeGrant;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.id.State;
import java.net.URI;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.web.security.oidc.OidcIdentityProvider;
import org.apache.nifi.web.security.oidc.OidcService;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class OidcServiceTest {
    public static final String TEST_REQUEST_IDENTIFIER = "test-request-identifier";
    public static final String TEST_STATE = "test-state";

    @Test(expected=IllegalStateException.class)
    public void testOidcNotEnabledCreateState() throws Exception {
        OidcService service = this.getServiceWithNoOidcSupport();
        service.createState(TEST_REQUEST_IDENTIFIER);
    }

    @Test(expected=IllegalStateException.class)
    public void testCreateStateMultipleInvocations() throws Exception {
        OidcService service = this.getServiceWithOidcSupport();
        service.createState(TEST_REQUEST_IDENTIFIER);
        service.createState(TEST_REQUEST_IDENTIFIER);
    }

    @Test(expected=IllegalStateException.class)
    public void testOidcNotEnabledValidateState() throws Exception {
        OidcService service = this.getServiceWithNoOidcSupport();
        service.isStateValid(TEST_REQUEST_IDENTIFIER, new State(TEST_STATE));
    }

    @Test
    public void testOidcUnknownState() throws Exception {
        OidcService service = this.getServiceWithOidcSupport();
        Assert.assertFalse((boolean)service.isStateValid(TEST_REQUEST_IDENTIFIER, new State(TEST_STATE)));
    }

    @Test
    public void testValidateState() throws Exception {
        OidcService service = this.getServiceWithOidcSupport();
        State state = service.createState(TEST_REQUEST_IDENTIFIER);
        Assert.assertTrue((boolean)service.isStateValid(TEST_REQUEST_IDENTIFIER, state));
    }

    @Test
    public void testValidateStateExpiration() throws Exception {
        OidcService service = this.getServiceWithOidcSupportAndCustomExpiration(1, TimeUnit.SECONDS);
        State state = service.createState(TEST_REQUEST_IDENTIFIER);
        Thread.sleep(3000L);
        Assert.assertFalse((boolean)service.isStateValid(TEST_REQUEST_IDENTIFIER, state));
    }

    @Test(expected=IllegalStateException.class)
    public void testOidcNotEnabledExchangeCode() throws Exception {
        OidcService service = this.getServiceWithNoOidcSupport();
        service.exchangeAuthorizationCode(TEST_REQUEST_IDENTIFIER, (AuthorizationGrant)this.getAuthorizationCodeGrant());
    }

    @Test(expected=IllegalStateException.class)
    public void testExchangeCodeMultipleInvocation() throws Exception {
        OidcService service = this.getServiceWithOidcSupport();
        service.exchangeAuthorizationCode(TEST_REQUEST_IDENTIFIER, (AuthorizationGrant)this.getAuthorizationCodeGrant());
        service.exchangeAuthorizationCode(TEST_REQUEST_IDENTIFIER, (AuthorizationGrant)this.getAuthorizationCodeGrant());
    }

    @Test(expected=IllegalStateException.class)
    public void testOidcNotEnabledGetJwt() throws Exception {
        OidcService service = this.getServiceWithNoOidcSupport();
        service.getJwt(TEST_REQUEST_IDENTIFIER);
    }

    @Test
    public void testGetJwt() throws Exception {
        OidcService service = this.getServiceWithOidcSupport();
        service.exchangeAuthorizationCode(TEST_REQUEST_IDENTIFIER, (AuthorizationGrant)this.getAuthorizationCodeGrant());
        Assert.assertNotNull((Object)service.getJwt(TEST_REQUEST_IDENTIFIER));
    }

    @Test
    public void testGetJwtExpiration() throws Exception {
        OidcService service = this.getServiceWithOidcSupportAndCustomExpiration(1, TimeUnit.SECONDS);
        service.exchangeAuthorizationCode(TEST_REQUEST_IDENTIFIER, (AuthorizationGrant)this.getAuthorizationCodeGrant());
        Thread.sleep(3000L);
        Assert.assertNull((Object)service.getJwt(TEST_REQUEST_IDENTIFIER));
    }

    private OidcService getServiceWithNoOidcSupport() {
        OidcIdentityProvider provider = (OidcIdentityProvider)Mockito.mock(OidcIdentityProvider.class);
        Mockito.when((Object)provider.isOidcEnabled()).thenReturn((Object)false);
        OidcService service = new OidcService(provider);
        Assert.assertFalse((boolean)service.isOidcEnabled());
        return service;
    }

    private OidcService getServiceWithOidcSupport() throws Exception {
        OidcIdentityProvider provider = (OidcIdentityProvider)Mockito.mock(OidcIdentityProvider.class);
        Mockito.when((Object)provider.isOidcEnabled()).thenReturn((Object)true);
        Mockito.when((Object)provider.exchangeAuthorizationCode((AuthorizationGrant)ArgumentMatchers.any())).then(invocation -> UUID.randomUUID().toString());
        OidcService service = new OidcService(provider);
        Assert.assertTrue((boolean)service.isOidcEnabled());
        return service;
    }

    private OidcService getServiceWithOidcSupportAndCustomExpiration(int duration, TimeUnit units) throws Exception {
        OidcIdentityProvider provider = (OidcIdentityProvider)Mockito.mock(OidcIdentityProvider.class);
        Mockito.when((Object)provider.isOidcEnabled()).thenReturn((Object)true);
        Mockito.when((Object)provider.exchangeAuthorizationCode((AuthorizationGrant)ArgumentMatchers.any())).then(invocation -> UUID.randomUUID().toString());
        OidcService service = new OidcService(provider, duration, units);
        Assert.assertTrue((boolean)service.isOidcEnabled());
        return service;
    }

    private AuthorizationCodeGrant getAuthorizationCodeGrant() {
        return new AuthorizationCodeGrant(new AuthorizationCode("code"), URI.create("http://localhost:8080/nifi"));
    }
}

