/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.jwt;

import io.jsonwebtoken.JwtException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.LinkedHashMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.nifi.admin.service.AdministrationException;
import org.apache.nifi.admin.service.KeyService;
import org.apache.nifi.authorization.user.NiFiUserDetails;
import org.apache.nifi.authorization.user.StandardNiFiUser;
import org.apache.nifi.key.Key;
import org.apache.nifi.web.security.jwt.JwtService;
import org.apache.nifi.web.security.token.LoginAuthenticationToken;
import org.codehaus.jettison.json.JSONObject;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

public class JwtServiceTest {
    private static final Logger logger = LoggerFactory.getLogger(JwtServiceTest.class);
    private static final String VALID_SIGNED_TOKEN = "eyJhbGciOiJIUzI1NiJ9.eyJzdWIiOiJhbG9wcmVzdG8iLCJpc3MiOiJNb2NrSWRlbnRpdHlQcm92aWRlciIsImF1ZCI6Ik1vY2tJZGVudGl0eVByb3ZpZGVyIiwicHJlZmVycmVkX3VzZXJuYW1lIjoiYWxvcHJlc3RvIiwia2lkIjoxLCJleHAiOjI0NDc4MDg3NjEsImlhdCI6MTQ0NzgwODcwMX0.r6aGZ6FNNYMOpcXW8BK2VYaQeX1uO0Aw1KJfjB3Q1DU";
    private static final String INVALID_SIGNED_TOKEN = "eyJhbGciOiJIUzI1NiJ9.eyJzdWIiOiIiLCJpc3MiOiJNb2NrSWRlbnRpdHlQcm92aWRlciIsImF1ZCI6Ik1vY2tJZGVudGl0eVByb3ZpZGVyIiwicHJlZmVycmVkX3VzZXJuYW1lIjoiYWxvcHJlc3RvIiwia2lkIjoxLCJleHAiOjI0NDc4MDg3NjEsImlhdCI6MTQ0NzgwODcwMX0.x_1p2M6E0vwWHWMujIUnSL3GkFoDqqICllRxo2SMNaw";
    private static final String VALID_UNSIGNED_TOKEN = "eyJhbGciOiJIUzI1NiJ9.eyJzdWIiOiJhbG9wcmVzdG8iLCJpc3MiOiJNb2NrSWRlbnRpdHlQcm92aWRlciIsImF1ZCI6Ik1vY2tJZGVudGl0eVByb3ZpZGVyIiwicHJlZmVycmVkX3VzZXJuYW1lIjoiYWxvcHJlc3RvIiwia2lkIjoiYWxvcHJlc3RvIiwiZXhwIjoyNDQ3ODA4NzYxLCJpYXQiOjE0NDc4MDg3MDF9";
    private static final String INVALID_UNSIGNED_TOKEN = "eyJhbGciOiJIUzI1NiJ9.eyJzdWIiOiIiLCJpc3MiOiJNb2NrSWRlbnRpdHlQcm92aWRlciIsImF1ZCI6Ik1vY2tJZGVudGl0eVByb3ZpZGVyIiwicHJlZmVycmVkX3VzZXJuYW1lIjoiYWxvcHJlc3RvIiwia2lkIjoiYWxvcHJlc3RvIiwiZXhwIjoyNDQ3ODA4NzYxLCJpYXQiOjE0NDc4MDg3MDF9";
    private static final String VALID_MALSIGNED_TOKEN = "eyJhbGciOiJub25lIn0.eyJzdWIiOiJhbG9wcmVzdG8iLCJpc3MiOiJNb2NrSWRlbnRpdHlQcm92aWRlciIsImF1ZCI6Ik1vY2tJZGVudGl0eVByb3ZpZGVyIiwicHJlZmVycmVkX3VzZXJuYW1lIjoiYWxvcHJlc3RvIiwia2lkIjoiYWxvcHJlc3RvIiwiZXhwIjoxNDQ3ODA4NzYxLCJpYXQiOjE0NDc4MDg3MDF9.mPO_wMNMl_zjMNevhNvUoXbSJ9Kx6jAe5OxDIAzKQbI";
    private static final String VALID_MALSIGNED_NO_SIG_TOKEN = "eyJhbGciOiJub25lIn0.eyJzdWIiOiJhbG9wcmVzdG8iLCJpc3MiOiJNb2NrSWRlbnRpdHlQcm92aWRlciIsImF1ZCI6Ik1vY2tJZGVudGl0eVByb3ZpZGVyIiwicHJlZmVycmVkX3VzZXJuYW1lIjoiYWxvcHJlc3RvIiwia2lkIjoiYWxvcHJlc3RvIiwiZXhwIjoyNDQ3ODA4NzYxLCJpYXQiOjE0NDc4MDg3MDF9.";
    private static final String INVALID_MALSIGNED_TOKEN = "eyJhbGciOiJIUzI1NiJ9.eyJzdWIiOiIiLCJpc3MiOiJNb2NrSWRlbnRpdHlQcm92aWRlciIsImF1ZCI6Ik1vY2tJZGVudGl0eVByb3ZpZGVyIiwicHJlZmVycmVkX3VzZXJuYW1lIjoiYWxvcHJlc3RvIiwia2lkIjoiYWxvcHJlc3RvIiwiZXhwIjoxNDQ3ODA4NzYxLCJpYXQiOjE0NDc4MDg3MDF9.WAwmUY4KHKV2oARNodkqDkbZsfRXGZfD2Ccy64GX9QF";
    private static final String EXPIRED_SIGNED_TOKEN = "eyJhbGciOiJIUzI1NiJ9.eyJzdWIiOiIiLCJpc3MiOiJNb2NrSWRlbnRpdHlQcm92aWRlciIsImF1ZCI6Ik1vY2tJZGVudGl0eVByb3ZpZGVyIiwicHJlZmVycmVkX3VzZXJuYW1lIjoiYWxvcHJlc3RvIiwia2lkIjoxLCJleHAiOjE0NDc4MDg3NjEsImlhdCI6MTQ0NzgwODcwMX0.ZPDIhNKuL89vTGXcuztOYaGifwcrQy_gid4j8Sspmto";
    private static final String IMPOSTER_SIGNED_TOKEN = "eyJhbGciOiJIUzI1NiJ9.eyJzdWIiOiJtZ2lsbWFuIiwiaXNzIjoiTW9ja0lkZW50aXR5UHJvdmlkZXIiLCJhdWQiOiJNb2NrSWRlbnRpdHlQcm92aWRlciIsInByZWZlcnJlZF91c2VybmFtZSI6ImFsb3ByZXN0byIsImtpZCI6MSwiZXhwIjoyNDQ3ODA4NzYxLCJpYXQiOjE0NDc4MDg3MDF9.aw5OAvLTnb_sHmSQOQzW-A7NImiZgXJ2ngbbNL2Ymkc";
    private static final String UNKNOWN_ISSUER_TOKEN = "eyJhbGciOiJIUzI1NiJ9.eyJzdWIiOiJhbG9wcmVzdG8iLCJpc3MiOiJVbmtub3duSWRlbnRpdHlQcm92aWRlciIsImF1ZCI6Ik1vY2tJZGVudGl0eVByb3ZpZGVyIiwicHJlZmVycmVkX3VzZXJuYW1lIjoiYWxvcHJlc3RvIiwia2lkIjoiYWxvcHJlc3RvIiwiZXhwIjoyNDQ3ODA4NzYxLCJpYXQiOjE0NDc4MDg3MDF9.SAd9tyNwSaijWet9wvAWSNmpxmPSK4XQuLx7h3ARqBo";
    private static final String NO_ISSUER_TOKEN = "eyJhbGciOiJIUzI1NiJ9.eyJzdWIiOiJhbG9wcmVzdG8iLCJhdWQiOiJNb2NrSWRlbnRpdHlQcm92aWRlciIsInByZWZlcnJlZF91c2VybmFtZSI6ImFsb3ByZXN0byIsImtpZCI6MSwiZXhwIjoyNDQ3ODA4NzYxLCJpYXQiOjE0NDc4MDg3MDF9.6kDjDanAg0NQDb3C8FmgbBAYDoIfMAEkF4WMVALsbJA";
    private static final String DEFAULT_HEADER = "{\"alg\":\"HS256\"}";
    private static final String DEFAULT_IDENTITY = "alopresto";
    private static final String TOKEN_DELIMITER = ".";
    private static final String HMAC_SECRET = "test_hmac_shared_secret";
    private KeyService mockKeyService;
    private JwtService jwtService;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    public static String generateHS256Token(String rawHeader, String rawPayload, boolean isValid, boolean isSigned) {
        return JwtServiceTest.generateHS256Token(rawHeader, rawPayload, HMAC_SECRET, isValid, isSigned);
    }

    private static String generateHS256Token(String rawHeader, String rawPayload, String hmacSecret, boolean isValid, boolean isSigned) {
        try {
            logger.info("Generating token for " + rawHeader + " + " + rawPayload);
            String base64Header = Base64.encodeBase64URLSafeString((byte[])rawHeader.getBytes(StandardCharsets.UTF_8));
            String base64Payload = Base64.encodeBase64URLSafeString((byte[])rawPayload.getBytes(StandardCharsets.UTF_8));
            String body = base64Header + TOKEN_DELIMITER + base64Payload;
            String signature = JwtServiceTest.generateHMAC(hmacSecret, body);
            return body + TOKEN_DELIMITER + signature;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            String errorMessage = "Could not generate the token";
            logger.error("Could not generate the token", (Throwable)e);
            Assert.fail((String)"Could not generate the token");
            return null;
        }
    }

    private static String generateHMAC(String hmacSecret, String body) throws NoSuchAlgorithmException, InvalidKeyException {
        Mac hmacSHA256 = Mac.getInstance("HmacSHA256");
        SecretKeySpec secret_key = new SecretKeySpec(hmacSecret.getBytes(StandardCharsets.UTF_8), "HmacSHA256");
        hmacSHA256.init(secret_key);
        return Base64.encodeBase64URLSafeString((byte[])hmacSHA256.doFinal(body.getBytes(StandardCharsets.UTF_8)));
    }

    @Before
    public void setUp() throws Exception {
        final Key key = new Key();
        key.setId(1);
        key.setIdentity(DEFAULT_IDENTITY);
        key.setKey(HMAC_SECRET);
        Answer<Key> keyAnswer = new Answer<Key>(){
            Key answerKey;
            {
                this.answerKey = key;
            }

            public Key answer(InvocationOnMock invocation) throws Throwable {
                if (invocation.getMethod().equals(KeyService.class.getMethod("deleteKey", String.class))) {
                    this.answerKey = null;
                }
                return this.answerKey;
            }
        };
        StandardNiFiUser nifiUser = (StandardNiFiUser)Mockito.mock(StandardNiFiUser.class);
        Mockito.when((Object)nifiUser.getIdentity()).thenReturn((Object)DEFAULT_IDENTITY);
        NiFiUserDetails nifiUserDetails = (NiFiUserDetails)Mockito.mock(NiFiUserDetails.class);
        Mockito.when((Object)nifiUserDetails.getNiFiUser()).thenReturn((Object)nifiUser);
        Authentication authentication = (Authentication)Mockito.mock(Authentication.class);
        SecurityContext securityContext = (SecurityContext)Mockito.mock(SecurityContext.class);
        Mockito.when((Object)securityContext.getAuthentication()).thenReturn((Object)authentication);
        SecurityContextHolder.setContext((SecurityContext)securityContext);
        Mockito.when((Object)SecurityContextHolder.getContext().getAuthentication().getPrincipal()).thenReturn((Object)nifiUserDetails);
        this.mockKeyService = (KeyService)Mockito.mock(KeyService.class);
        Mockito.when((Object)this.mockKeyService.getKey(ArgumentMatchers.anyInt())).thenAnswer((Answer)keyAnswer);
        Mockito.when((Object)this.mockKeyService.getOrCreateKey(ArgumentMatchers.anyString())).thenReturn((Object)key);
        ((KeyService)Mockito.doAnswer((Answer)keyAnswer).when((Object)this.mockKeyService)).deleteKey(ArgumentMatchers.anyString());
        this.jwtService = new JwtService(this.mockKeyService);
    }

    @After
    public void tearDown() throws Exception {
        this.jwtService = null;
    }

    @Test
    public void testShouldGetAuthenticationForValidToken() throws Exception {
        String token = VALID_SIGNED_TOKEN;
        String identity = this.jwtService.getAuthenticationFromToken(token);
        logger.debug("Extracted identity: " + identity);
        Assert.assertEquals((String)"Identity", (Object)DEFAULT_IDENTITY, (Object)identity);
    }

    @Test(expected=JwtException.class)
    public void testShouldNotGetAuthenticationForInvalidToken() throws Exception {
        String token = INVALID_SIGNED_TOKEN;
        String identity = this.jwtService.getAuthenticationFromToken(token);
        logger.debug("Extracted identity: " + identity);
    }

    @Test(expected=JwtException.class)
    public void testShouldNotGetAuthenticationForEmptyToken() throws Exception {
        String token = "";
        String identity = this.jwtService.getAuthenticationFromToken(token);
        logger.debug("Extracted identity: " + identity);
    }

    @Test(expected=JwtException.class)
    public void testShouldNotGetAuthenticationForUnsignedToken() throws Exception {
        String token = VALID_UNSIGNED_TOKEN;
        String identity = this.jwtService.getAuthenticationFromToken(token);
        logger.debug("Extracted identity: " + identity);
    }

    @Test(expected=JwtException.class)
    public void testShouldNotGetAuthenticationForMalsignedToken() throws Exception {
        String token = VALID_MALSIGNED_TOKEN;
        String identity = this.jwtService.getAuthenticationFromToken(token);
        logger.debug("Extracted identity: " + identity);
    }

    @Test(expected=JwtException.class)
    public void testShouldNotGetAuthenticationForTokenWithWrongAlgorithm() throws Exception {
        String token = VALID_MALSIGNED_TOKEN;
        String identity = this.jwtService.getAuthenticationFromToken(token);
        logger.debug("Extracted identity: " + identity);
    }

    @Test(expected=JwtException.class)
    public void testShouldNotGetAuthenticationForTokenWithWrongAlgorithmAndNoSignature() throws Exception {
        String token = VALID_MALSIGNED_NO_SIG_TOKEN;
        String identity = this.jwtService.getAuthenticationFromToken(token);
        logger.debug("Extracted identity: " + identity);
    }

    @Ignore(value="Not yet implemented")
    @Test(expected=JwtException.class)
    public void testShouldNotGetAuthenticationForTokenFromUnknownIdentityProvider() throws Exception {
        String token = UNKNOWN_ISSUER_TOKEN;
        String identity = this.jwtService.getAuthenticationFromToken(token);
        logger.debug("Extracted identity: " + identity);
    }

    @Test(expected=JwtException.class)
    public void testShouldNotGetAuthenticationForTokenFromEmptyIdentityProvider() throws Exception {
        String token = NO_ISSUER_TOKEN;
        String identity = this.jwtService.getAuthenticationFromToken(token);
        logger.debug("Extracted identity: " + identity);
    }

    @Test(expected=JwtException.class)
    public void testShouldNotGetAuthenticationForExpiredToken() throws Exception {
        String token = EXPIRED_SIGNED_TOKEN;
        String identity = this.jwtService.getAuthenticationFromToken(token);
        logger.debug("Extracted identity: " + identity);
    }

    @Test(expected=JwtException.class)
    public void testShouldNotGetAuthenticationForImposterToken() throws Exception {
        String token = IMPOSTER_SIGNED_TOKEN;
        String identity = this.jwtService.getAuthenticationFromToken(token);
        logger.debug("Extracted identity: " + identity);
    }

    @Test
    public void testShouldGenerateSignedToken() throws Exception {
        int EXPIRATION_MILLIS = 60000;
        LoginAuthenticationToken loginAuthenticationToken = new LoginAuthenticationToken(DEFAULT_IDENTITY, 60000L, "MockIdentityProvider");
        logger.debug("Generating token for " + loginAuthenticationToken);
        String EXPECTED_HEADER = DEFAULT_HEADER;
        long TOKEN_EXPIRATION_SEC = (long)((double)loginAuthenticationToken.getExpiration() / 1000.0);
        String token = this.jwtService.generateSignedToken(loginAuthenticationToken);
        logger.debug("Generated JWT: " + token);
        String DECODED_PAYLOAD = new String(Base64.decodeBase64((byte[])token.split("\\.")[1].getBytes()));
        long ISSUED_AT_SEC = Long.valueOf(DECODED_PAYLOAD.substring(DECODED_PAYLOAD.lastIndexOf(":") + 1, DECODED_PAYLOAD.length() - 1));
        logger.trace("Actual token was issued at " + ISSUED_AT_SEC);
        LinkedHashMap<String, Object> claims = new LinkedHashMap<String, Object>();
        claims.put("sub", DEFAULT_IDENTITY);
        claims.put("iss", "MockIdentityProvider");
        claims.put("aud", "MockIdentityProvider");
        claims.put("preferred_username", DEFAULT_IDENTITY);
        claims.put("kid", 1);
        claims.put("exp", TOKEN_EXPIRATION_SEC);
        claims.put("iat", ISSUED_AT_SEC);
        logger.trace("JSON Object to String: " + new JSONObject(claims).toString());
        String EXPECTED_PAYLOAD = new JSONObject(claims).toString();
        String EXPECTED_TOKEN_STRING = JwtServiceTest.generateHS256Token(DEFAULT_HEADER, EXPECTED_PAYLOAD, true, true);
        logger.debug("Expected JWT: " + EXPECTED_TOKEN_STRING);
        Assert.assertEquals((String)"JWT token", (Object)EXPECTED_TOKEN_STRING, (Object)token);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testShouldNotGenerateTokenWithNullAuthenticationToken() throws Exception {
        LoginAuthenticationToken nullLoginAuthenticationToken = null;
        logger.debug("Generating token for " + nullLoginAuthenticationToken);
        this.jwtService.generateSignedToken(nullLoginAuthenticationToken);
    }

    @Test(expected=JwtException.class)
    public void testShouldNotGenerateTokenWithEmptyIdentity() throws Exception {
        int EXPIRATION_MILLIS = 60000;
        LoginAuthenticationToken emptyIdentityLoginAuthenticationToken = new LoginAuthenticationToken("", 60000L, "MockIdentityProvider");
        logger.debug("Generating token for " + emptyIdentityLoginAuthenticationToken);
        this.jwtService.generateSignedToken(emptyIdentityLoginAuthenticationToken);
    }

    @Test(expected=JwtException.class)
    public void testShouldNotGenerateTokenWithNullIdentity() throws Exception {
        int EXPIRATION_MILLIS = 60000;
        LoginAuthenticationToken nullIdentityLoginAuthenticationToken = new LoginAuthenticationToken(null, 60000L, "MockIdentityProvider");
        logger.debug("Generating token for " + nullIdentityLoginAuthenticationToken);
        this.jwtService.generateSignedToken(nullIdentityLoginAuthenticationToken);
    }

    @Test(expected=JwtException.class)
    public void testShouldNotGenerateTokenWithMissingKey() throws Exception {
        int EXPIRATION_MILLIS = 60000;
        LoginAuthenticationToken loginAuthenticationToken = new LoginAuthenticationToken(DEFAULT_IDENTITY, 60000L, "MockIdentityProvider");
        logger.debug("Generating token for " + loginAuthenticationToken);
        KeyService missingKeyService = (KeyService)Mockito.mock(KeyService.class);
        Mockito.when((Object)missingKeyService.getOrCreateKey(ArgumentMatchers.anyString())).thenThrow(new Throwable[]{new AdministrationException("Could not find a key for that user")});
        this.jwtService = new JwtService(missingKeyService);
        this.jwtService.generateSignedToken(loginAuthenticationToken);
    }

    @Test
    public void testShouldLogOutUser() throws Exception {
        this.expectedException.expect(JwtException.class);
        this.expectedException.expectMessage("Unable to validate the access token.");
        int EXPIRATION_MILLIS = 60000;
        LoginAuthenticationToken loginAuthenticationToken = new LoginAuthenticationToken(DEFAULT_IDENTITY, 60000L, "MockIdentityProvider");
        logger.debug("Generating token for " + loginAuthenticationToken);
        String token = this.jwtService.generateSignedToken(loginAuthenticationToken);
        logger.debug("Generated JWT: " + token);
        String authID = this.jwtService.getAuthenticationFromToken(token);
        Assert.assertEquals((Object)DEFAULT_IDENTITY, (Object)authID);
        logger.debug("Logging out user: alopresto");
        this.jwtService.logOut(token);
        logger.debug("Logged out user: alopresto");
        this.jwtService.getAuthenticationFromToken(token);
    }

    @Test
    public void testLogoutWhenAuthTokenIsEmptyShouldThrowError() throws Exception {
        this.expectedException.expect(JwtException.class);
        this.expectedException.expectMessage("Log out failed: The user identity was not present in the request token to log out user.");
        this.jwtService.logOut(null);
    }
}

