/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.jwt;

import groovy.json.JsonOutput;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import groovy.util.GroovyTestCase;
import java.lang.ref.SoftReference;
import java.math.BigDecimal;
import java.util.Calendar;
import org.apache.nifi.web.security.InvalidAuthenticationException;
import org.apache.nifi.web.security.jwt.JwtAuthenticationFilter;
import org.apache.nifi.web.security.jwt.JwtServiceTest;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class JwtAuthenticationFilterTest
extends GroovyTestCase
implements GroovyObject {
    public static String jwtString;
    @Rule
    public ExpectedException expectedException;
    private static /* synthetic */ BigDecimal $const$0;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    public JwtAuthenticationFilterTest() {
        MetaClass metaClass;
        CallSite[] callSiteArray = JwtAuthenticationFilterTest.$getCallSiteArray();
        Object object = callSiteArray[0].call(ExpectedException.class);
        this.expectedException = (ExpectedException)ScriptBytecodeAdapter.castToType((Object)object, ExpectedException.class);
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @BeforeClass
    public static void setUpOnce() throws Exception {
        long l;
        long l2;
        long l3;
        long l4;
        CallSite[] callSiteArray = JwtAuthenticationFilterTest.$getCallSiteArray();
        String ALG_HEADER = "{\"alg\":\"HS256\"}";
        int EXPIRATION_SECONDS = 500;
        Calendar now = (Calendar)ScriptBytecodeAdapter.castToType((Object)callSiteArray[1].call(Calendar.class), Calendar.class);
        long currentTime = 0L;
        currentTime = !BytecodeInterface8.isOrigL() || __$stMC || BytecodeInterface8.disabledStandardMetaClass() ? (l4 = DefaultTypeTransformation.longUnbox((Object)callSiteArray[2].call(callSiteArray[3].call((Object)now), (Object)$const$0))) : (l3 = DefaultTypeTransformation.longUnbox((Object)callSiteArray[4].call(callSiteArray[5].call((Object)now), (Object)$const$0)));
        long TOKEN_ISSUED_AT = 0L;
        TOKEN_ISSUED_AT = !BytecodeInterface8.isOrigL() || __$stMC || BytecodeInterface8.disabledStandardMetaClass() ? (l2 = currentTime) : (l = currentTime);
        long TOKEN_EXPIRATION_SECONDS = 0L;
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigL() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[6].call((Object)currentTime, (Object)EXPIRATION_SECONDS);
            TOKEN_EXPIRATION_SECONDS = DefaultTypeTransformation.longUnbox((Object)object);
        } else {
            long l5;
            TOKEN_EXPIRATION_SECONDS = l5 = currentTime + (long)EXPIRATION_SECONDS;
        }
        String EXPECTED_PAYLOAD = ShortTypeHandling.castToString((Object)callSiteArray[7].call(JsonOutput.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"sub", "unknownuser", "iss", "MockIdentityProvider", "aud", "MockIdentityProvider", "preferred_username", "unknownuser", "kid", 1, "exp", TOKEN_EXPIRATION_SECONDS, "iat", TOKEN_ISSUED_AT})));
        Object object = callSiteArray[8].call(JwtServiceTest.class, (Object)ALG_HEADER, (Object)EXPECTED_PAYLOAD, (Object)true, (Object)true);
        jwtString = ShortTypeHandling.castToString((Object)object);
    }

    @AfterClass
    public static void tearDownOnce() throws Exception {
        CallSite[] callSiteArray = JwtAuthenticationFilterTest.$getCallSiteArray();
    }

    @Before
    public void setUp() throws Exception {
        CallSite[] callSiteArray = JwtAuthenticationFilterTest.$getCallSiteArray();
    }

    @After
    public void tearDown() throws Exception {
        CallSite[] callSiteArray = JwtAuthenticationFilterTest.$getCallSiteArray();
    }

    @Test
    public void testValidAuthenticationHeaderString() {
        CallSite[] callSiteArray = JwtAuthenticationFilterTest.$getCallSiteArray();
        String authenticationHeader = ShortTypeHandling.castToString((Object)callSiteArray[9].call((Object)"Bearer ", (Object)jwtString));
        boolean isValidHeader = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[10].call(callSiteArray[11].callConstructor(JwtAuthenticationFilter.class), (Object)authenticationHeader));
        callSiteArray[12].callStatic(JwtAuthenticationFilterTest.class, (Object)isValidHeader);
    }

    @Test
    public void testMissingBearer() {
        CallSite[] callSiteArray = JwtAuthenticationFilterTest.$getCallSiteArray();
        boolean isValidHeader = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[13].call(callSiteArray[14].callConstructor(JwtAuthenticationFilter.class), (Object)jwtString));
        callSiteArray[15].callStatic(JwtAuthenticationFilterTest.class, (Object)isValidHeader);
    }

    @Test
    public void testExtraCharactersAtBeginningOfToken() {
        CallSite[] callSiteArray = JwtAuthenticationFilterTest.$getCallSiteArray();
        String authenticationHeader = ShortTypeHandling.castToString((Object)callSiteArray[16].call((Object)"xBearer ", (Object)jwtString));
        boolean isValidToken = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[17].call(callSiteArray[18].callConstructor(JwtAuthenticationFilter.class), (Object)authenticationHeader));
        callSiteArray[19].callStatic(JwtAuthenticationFilterTest.class, (Object)isValidToken);
    }

    @Test
    public void testBadTokenFormat() {
        CallSite[] callSiteArray = JwtAuthenticationFilterTest.$getCallSiteArray();
        Object[] tokenStrings = (String[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[20].call((Object)jwtString, (Object)"\\."), String[].class);
        String badToken = null;
        if (!BytecodeInterface8.isOrigInt() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[21].call(callSiteArray[22].call((Object)"Bearer ", callSiteArray[23].call((Object)tokenStrings, (Object)1)), callSiteArray[24].call((Object)tokenStrings, (Object)2));
            badToken = ShortTypeHandling.castToString((Object)object);
        } else {
            Object object = callSiteArray[25].call(callSiteArray[26].call((Object)"Bearer ", BytecodeInterface8.objectArrayGet((Object[])tokenStrings, (int)1)), BytecodeInterface8.objectArrayGet((Object[])tokenStrings, (int)2));
            badToken = ShortTypeHandling.castToString((Object)object);
        }
        boolean isValidToken = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[27].call(callSiteArray[28].callConstructor(JwtAuthenticationFilter.class), (Object)badToken));
        callSiteArray[29].callStatic(JwtAuthenticationFilterTest.class, (Object)isValidToken);
    }

    @Test
    public void testMultipleTokenInvalid() {
        CallSite[] callSiteArray = JwtAuthenticationFilterTest.$getCallSiteArray();
        String authenticationHeader = ShortTypeHandling.castToString((Object)callSiteArray[30].call((Object)"Bearer ", (Object)jwtString));
        Object object = callSiteArray[31].call(callSiteArray[32].call((Object)authenticationHeader, (Object)" "), (Object)authenticationHeader);
        authenticationHeader = ShortTypeHandling.castToString((Object)object);
        boolean isValidToken = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[33].call(callSiteArray[34].callConstructor(JwtAuthenticationFilter.class), (Object)authenticationHeader));
        callSiteArray[35].callStatic(JwtAuthenticationFilterTest.class, (Object)isValidToken);
    }

    @Test
    public void testExtractToken() {
        CallSite[] callSiteArray = JwtAuthenticationFilterTest.$getCallSiteArray();
        String authenticationHeader = ShortTypeHandling.castToString((Object)callSiteArray[36].call((Object)"Bearer ", (Object)jwtString));
        String extractedToken = ShortTypeHandling.castToString((Object)callSiteArray[37].call(callSiteArray[38].callConstructor(JwtAuthenticationFilter.class), (Object)authenticationHeader));
        callSiteArray[39].callStatic(JwtAuthenticationFilterTest.class, (Object)jwtString, (Object)extractedToken);
    }

    @Test
    public void testMultipleTokenDottedInvalid() {
        CallSite[] callSiteArray = JwtAuthenticationFilterTest.$getCallSiteArray();
        String authenticationHeader = ShortTypeHandling.castToString((Object)callSiteArray[40].call((Object)"Bearer ", (Object)jwtString));
        Object object = callSiteArray[41].call(callSiteArray[42].call((Object)authenticationHeader, (Object)"."), (Object)authenticationHeader);
        authenticationHeader = ShortTypeHandling.castToString((Object)object);
        boolean isValidToken = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[43].call(callSiteArray[44].callConstructor(JwtAuthenticationFilter.class), (Object)authenticationHeader));
        callSiteArray[45].callStatic(JwtAuthenticationFilterTest.class, (Object)isValidToken);
    }

    @Test
    public void testMultipleTokenNotExtracted() {
        CallSite[] callSiteArray = JwtAuthenticationFilterTest.$getCallSiteArray();
        callSiteArray[46].call((Object)this.expectedException, InvalidAuthenticationException.class);
        callSiteArray[47].call((Object)this.expectedException, (Object)"JWT did not match expected pattern.");
        String authenticationHeader = ShortTypeHandling.castToString((Object)callSiteArray[48].call((Object)"Bearer ", (Object)jwtString));
        Object object = callSiteArray[49].call(callSiteArray[50].call((Object)authenticationHeader, (Object)" "), (Object)authenticationHeader);
        authenticationHeader = ShortTypeHandling.castToString((Object)object);
        String token = ShortTypeHandling.castToString((Object)callSiteArray[51].call(callSiteArray[52].callConstructor(JwtAuthenticationFilter.class), (Object)authenticationHeader));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != JwtAuthenticationFilterTest.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    public static /* synthetic */ void __$swapInit() {
        BigDecimal bigDecimal;
        CallSite[] callSiteArray = JwtAuthenticationFilterTest.$getCallSiteArray();
        $callSiteArray = null;
        $const$0 = bigDecimal = new BigDecimal("1000.0");
    }

    static {
        JwtAuthenticationFilterTest.__$swapInit();
    }

    public /* synthetic */ void super$3$setUp() {
        super.setUp();
    }

    public /* synthetic */ void super$3$tearDown() {
        super.tearDown();
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "none";
        stringArray[1] = "getInstance";
        stringArray[2] = "div";
        stringArray[3] = "getTimeInMillis";
        stringArray[4] = "div";
        stringArray[5] = "getTimeInMillis";
        stringArray[6] = "plus";
        stringArray[7] = "toJson";
        stringArray[8] = "generateHS256Token";
        stringArray[9] = "plus";
        stringArray[10] = "validJwtFormat";
        stringArray[11] = "<$constructor$>";
        stringArray[12] = "assertTrue";
        stringArray[13] = "validJwtFormat";
        stringArray[14] = "<$constructor$>";
        stringArray[15] = "assertFalse";
        stringArray[16] = "plus";
        stringArray[17] = "validJwtFormat";
        stringArray[18] = "<$constructor$>";
        stringArray[19] = "assertFalse";
        stringArray[20] = "split";
        stringArray[21] = "plus";
        stringArray[22] = "plus";
        stringArray[23] = "getAt";
        stringArray[24] = "getAt";
        stringArray[25] = "plus";
        stringArray[26] = "plus";
        stringArray[27] = "validJwtFormat";
        stringArray[28] = "<$constructor$>";
        stringArray[29] = "assertFalse";
        stringArray[30] = "plus";
        stringArray[31] = "plus";
        stringArray[32] = "plus";
        stringArray[33] = "validJwtFormat";
        stringArray[34] = "<$constructor$>";
        stringArray[35] = "assertFalse";
        stringArray[36] = "plus";
        stringArray[37] = "getTokenFromHeader";
        stringArray[38] = "<$constructor$>";
        stringArray[39] = "assertEquals";
        stringArray[40] = "plus";
        stringArray[41] = "plus";
        stringArray[42] = "plus";
        stringArray[43] = "validJwtFormat";
        stringArray[44] = "<$constructor$>";
        stringArray[45] = "assertFalse";
        stringArray[46] = "expect";
        stringArray[47] = "expectMessage";
        stringArray[48] = "plus";
        stringArray[49] = "plus";
        stringArray[50] = "plus";
        stringArray[51] = "getTokenFromHeader";
        stringArray[52] = "<$constructor$>";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[53];
        JwtAuthenticationFilterTest.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(JwtAuthenticationFilterTest.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = JwtAuthenticationFilterTest.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

