/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.headers;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.nifi.web.security.headers.ContentSecurityPolicyFilter;
import org.apache.nifi.web.security.headers.StrictTransportSecurityFilter;
import org.apache.nifi.web.security.headers.XFrameOptionsFilter;
import org.apache.nifi.web.security.headers.XSSProtectionFilter;
import org.eclipse.jetty.servlet.FilterHolder;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.springframework.mock.web.MockHttpServletResponse;

public class HTTPHeaderFiltersTest {
    @Test
    public void testCSPHeaderApplied() throws ServletException, IOException {
        FilterHolder originFilter = new FilterHolder((Filter)new ContentSecurityPolicyFilter());
        HttpServletRequest mockRequest = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        MockHttpServletResponse mockResponse = new MockHttpServletResponse();
        FilterChain mockFilterChain = (FilterChain)Mockito.mock(FilterChain.class);
        originFilter.getFilter().doFilter((ServletRequest)mockRequest, (ServletResponse)mockResponse, mockFilterChain);
        Assert.assertEquals((Object)"frame-ancestors 'self'", (Object)mockResponse.getHeader("Content-Security-Policy"));
    }

    @Test
    public void testCSPHeaderAppliedOnlyOnce() throws ServletException, IOException {
        FilterHolder originFilter = new FilterHolder((Filter)new ContentSecurityPolicyFilter());
        HttpServletRequest mockRequest = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        MockHttpServletResponse mockResponse = new MockHttpServletResponse();
        FilterChain mockFilterChain = (FilterChain)Mockito.mock(FilterChain.class);
        originFilter.getFilter().doFilter((ServletRequest)mockRequest, (ServletResponse)mockResponse, mockFilterChain);
        originFilter.getFilter().doFilter((ServletRequest)mockRequest, (ServletResponse)mockResponse, mockFilterChain);
        Assert.assertEquals((Object)"frame-ancestors 'self'", (Object)mockResponse.getHeader("Content-Security-Policy"));
    }

    @Test
    public void testXFrameOptionsHeaderApplied() throws ServletException, IOException {
        FilterHolder xfoFilter = new FilterHolder((Filter)new XFrameOptionsFilter());
        HttpServletRequest mockRequest = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        MockHttpServletResponse mockResponse = new MockHttpServletResponse();
        FilterChain mockFilterChain = (FilterChain)Mockito.mock(FilterChain.class);
        xfoFilter.getFilter().doFilter((ServletRequest)mockRequest, (ServletResponse)mockResponse, mockFilterChain);
        Assert.assertEquals((Object)"SAMEORIGIN", (Object)mockResponse.getHeader("X-Frame-Options"));
    }

    @Test
    public void testHSTSHeaderApplied() throws ServletException, IOException {
        FilterHolder hstsFilter = new FilterHolder((Filter)new StrictTransportSecurityFilter());
        HttpServletRequest mockRequest = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        MockHttpServletResponse mockResponse = new MockHttpServletResponse();
        FilterChain mockFilterChain = (FilterChain)Mockito.mock(FilterChain.class);
        hstsFilter.getFilter().doFilter((ServletRequest)mockRequest, (ServletResponse)mockResponse, mockFilterChain);
        Assert.assertEquals((Object)"max-age=31540000", (Object)mockResponse.getHeader("Strict-Transport-Security"));
    }

    @Test
    public void testXSSProtectionHeaderApplied() throws ServletException, IOException {
        FilterHolder xssFilter = new FilterHolder((Filter)new XSSProtectionFilter());
        HttpServletRequest mockRequest = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        MockHttpServletResponse mockResponse = new MockHttpServletResponse();
        FilterChain mockFilterChain = (FilterChain)Mockito.mock(FilterChain.class);
        xssFilter.getFilter().doFilter((ServletRequest)mockRequest, (ServletResponse)mockResponse, mockFilterChain);
        Assert.assertEquals((Object)"1; mode=block", (Object)mockResponse.getHeader("X-XSS-Protection"));
    }
}

