/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.lang.ref.SoftReference;
import java.util.List;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.web.security.ProxiedEntitiesUtils;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.powerassert.AssertionRenderer;
import org.codehaus.groovy.runtime.powerassert.ValueRecorder;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=JUnit4.class)
public class ProxiedEntitiesUtilsTest
implements GroovyObject {
    private static final Logger logger;
    private static final String SAFE_USER_NAME_ANDY = "alopresto";
    private static final String SAFE_USER_DN_ANDY;
    private static final String SAFE_USER_NAME_JOHN = "jdoe";
    private static final String SAFE_USER_DN_JOHN;
    private static final String SAFE_USER_NAME_PROXY_1 = "proxy1.nifi.apache.org";
    private static final String SAFE_USER_DN_PROXY_1;
    private static final String SAFE_USER_NAME_PROXY_2 = "proxy2.nifi.apache.org";
    private static final String SAFE_USER_DN_PROXY_2;
    private static final String MALICIOUS_USER_NAME_JOHN;
    private static final String MALICIOUS_USER_DN_JOHN;
    private static final String MALICIOUS_USER_NAME_JOHN_ESCAPED;
    private static final String MALICIOUS_USER_DN_JOHN_ESCAPED;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    public ProxiedEntitiesUtilsTest() {
        MetaClass metaClass;
        CallSite[] callSiteArray = ProxiedEntitiesUtilsTest.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @BeforeClass
    public static void setUpOnce() throws Exception {
        CallSite[] callSiteArray = ProxiedEntitiesUtilsTest.$getCallSiteArray();
        public final class _setUpOnce_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _setUpOnce_closure1(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _setUpOnce_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(String name, Object args) {
                CallSite[] callSiteArray = _setUpOnce_closure1.$getCallSiteArray();
                return callSiteArray[0].call(callSiteArray[1].callGetProperty(ProxiedEntitiesUtilsTest.class), (Object)new GStringImpl(new Object[]{callSiteArray[2].callSafe((Object)name), callSiteArray[3].call((Object)((List)ScriptBytecodeAdapter.asType((Object)args, List.class)), (Object)" ")}, new String[]{"[", "] ", ""}));
            }

            public Object call(String name, Object args) {
                CallSite[] callSiteArray = _setUpOnce_closure1.$getCallSiteArray();
                return callSiteArray[4].callCurrent((GroovyObject)this, (Object)name, args);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _setUpOnce_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "info";
                stringArray[1] = "logger";
                stringArray[2] = "toUpperCase";
                stringArray[3] = "join";
                stringArray[4] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[5];
                _setUpOnce_closure1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_setUpOnce_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _setUpOnce_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        _setUpOnce_closure1 _setUpOnce_closure12 = new _setUpOnce_closure1(ProxiedEntitiesUtilsTest.class, ProxiedEntitiesUtilsTest.class);
        ScriptBytecodeAdapter.setProperty((Object)((Object)_setUpOnce_closure12), null, (Object)callSiteArray[0].callGetProperty((Object)logger), (String)"methodMissing");
    }

    @Before
    public void setUp() {
        CallSite[] callSiteArray = ProxiedEntitiesUtilsTest.$getCallSiteArray();
    }

    @After
    public void tearDown() {
        CallSite[] callSiteArray = ProxiedEntitiesUtilsTest.$getCallSiteArray();
    }

    private static String sanitizeDn(String dn) {
        CallSite[] callSiteArray = ProxiedEntitiesUtilsTest.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[1].call(callSiteArray[2].call((Object)dn, (Object)">", (Object)"\\\\>"), (Object)"<", (Object)"\\\\<"));
    }

    private static String printUnicodeString(String raw) {
        CallSite[] callSiteArray = ProxiedEntitiesUtilsTest.$getCallSiteArray();
        StringBuilder sb = (StringBuilder)ScriptBytecodeAdapter.castToType((Object)callSiteArray[3].callConstructor(StringBuilder.class), StringBuilder.class);
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            int i = 0;
            while (ScriptBytecodeAdapter.compareLessThan((Object)i, (Object)callSiteArray[4].call((Object)raw))) {
                int codePoint = DefaultTypeTransformation.intUnbox((Object)callSiteArray[5].call(Character.class, (Object)raw, (Object)i));
                int charCount = DefaultTypeTransformation.intUnbox((Object)callSiteArray[6].call(Character.class, (Object)codePoint));
                if (charCount > 1) {
                    i = DefaultTypeTransformation.intUnbox((Object)callSiteArray[7].call((Object)i, callSiteArray[8].call((Object)charCount, (Object)1)));
                    if (ScriptBytecodeAdapter.compareGreaterThanEqual((Object)i, (Object)callSiteArray[9].call((Object)raw))) {
                        throw (Throwable)callSiteArray[10].callConstructor(IllegalArgumentException.class, (Object)"Code point indicated more characters than available");
                    }
                }
                callSiteArray[11].call((Object)sb, callSiteArray[12].call(String.class, (Object)"\\u%04x ", (Object)codePoint));
                int n = i;
                i = DefaultTypeTransformation.intUnbox((Object)callSiteArray[13].call((Object)n));
            }
        } else {
            int i = 0;
            while (ScriptBytecodeAdapter.compareLessThan((Object)i, (Object)callSiteArray[14].call((Object)raw))) {
                int codePoint = DefaultTypeTransformation.intUnbox((Object)callSiteArray[15].call(Character.class, (Object)raw, (Object)i));
                int charCount = DefaultTypeTransformation.intUnbox((Object)callSiteArray[16].call(Character.class, (Object)codePoint));
                if (charCount > 1) {
                    i = i + (charCount - 1);
                    if (ScriptBytecodeAdapter.compareGreaterThanEqual((Object)i, (Object)callSiteArray[17].call((Object)raw))) {
                        throw (Throwable)callSiteArray[18].callConstructor(IllegalArgumentException.class, (Object)"Code point indicated more characters than available");
                    }
                }
                callSiteArray[19].call((Object)sb, callSiteArray[20].call(String.class, (Object)"\\u%04x ", (Object)codePoint));
                int n = i;
                int cfr_ignored_0 = n + 1;
            }
        }
        return ShortTypeHandling.castToString((Object)callSiteArray[21].call(callSiteArray[22].call((Object)sb)));
    }

    @Test
    public void testSanitizeDnShouldHandleFuzzing() throws Exception {
        CallSite[] callSiteArray = ProxiedEntitiesUtilsTest.$getCallSiteArray();
        Reference DESIRED_NAME = new Reference((Object)SAFE_USER_NAME_JOHN);
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[23].call((Object)logger, (Object)new GStringImpl(new Object[]{(String)DESIRED_NAME.get(), callSiteArray[24].callStatic(ProxiedEntitiesUtilsTest.class, (Object)((String)DESIRED_NAME.get()))}, new String[]{"  Desired name: ", " |  ", ""}));
        } else {
            callSiteArray[25].call((Object)logger, (Object)new GStringImpl(new Object[]{(String)DESIRED_NAME.get(), ProxiedEntitiesUtilsTest.printUnicodeString((String)DESIRED_NAME.get())}, new String[]{"  Desired name: ", " |  ", ""}));
        }
        List MALICIOUS_NAMES = ScriptBytecodeAdapter.createList((Object[])new Object[]{MALICIOUS_USER_NAME_JOHN, callSiteArray[26].call((Object)SAFE_USER_NAME_JOHN, (Object)">"), callSiteArray[27].call((Object)SAFE_USER_NAME_JOHN, (Object)"><>"), callSiteArray[28].call((Object)SAFE_USER_NAME_JOHN, (Object)"\\>"), callSiteArray[29].call((Object)SAFE_USER_NAME_JOHN, (Object)">"), callSiteArray[30].call((Object)SAFE_USER_NAME_JOHN, (Object)"\\>"), callSiteArray[31].call((Object)SAFE_USER_NAME_JOHN, (Object)"\u0000"), callSiteArray[32].call((Object)SAFE_USER_NAME_JOHN, (Object)"\bn")});
        public final class _testSanitizeDnShouldHandleFuzzing_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference DESIRED_NAME;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _testSanitizeDnShouldHandleFuzzing_closure2(Object _outerInstance, Object _thisObject, Reference DESIRED_NAME) {
                Reference reference;
                CallSite[] callSiteArray = _testSanitizeDnShouldHandleFuzzing_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.DESIRED_NAME = reference = DESIRED_NAME;
            }

            public Object doCall(String name) {
                CallSite[] callSiteArray = _testSanitizeDnShouldHandleFuzzing_closure2.$getCallSiteArray();
                callSiteArray[0].call(callSiteArray[1].callGetProperty(ProxiedEntitiesUtilsTest.class), (Object)new GStringImpl(new Object[]{name, callSiteArray[2].callStatic(ProxiedEntitiesUtilsTest.class, (Object)name)}, new String[]{"      Raw name: ", " | ", ""}));
                String sanitizedName = ShortTypeHandling.castToString((Object)callSiteArray[3].call(ProxiedEntitiesUtils.class, (Object)name));
                callSiteArray[4].call(callSiteArray[5].callGetProperty(ProxiedEntitiesUtilsTest.class), (Object)new GStringImpl(new Object[]{sanitizedName, callSiteArray[6].callStatic(ProxiedEntitiesUtilsTest.class, (Object)sanitizedName)}, new String[]{"Sanitized name: ", " | ", ""}));
                ValueRecorder valueRecorder = new ValueRecorder();
                try {
                    String string = sanitizedName;
                    valueRecorder.record((Object)string, 8);
                    Object object = this.DESIRED_NAME.get();
                    valueRecorder.record(object, 25);
                    valueRecorder.record(object, 25);
                    boolean bl = ScriptBytecodeAdapter.compareNotEqual((Object)string, (Object)object);
                    valueRecorder.record((Object)bl, 22);
                    if (bl) {
                        valueRecorder.clear();
                    } else {
                        ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert sanitizedName != DESIRED_NAME", (ValueRecorder)valueRecorder), null);
                    }
                }
                catch (Throwable throwable) {
                    valueRecorder.clear();
                    throw throwable;
                }
                return null;
            }

            public Object call(String name) {
                CallSite[] callSiteArray = _testSanitizeDnShouldHandleFuzzing_closure2.$getCallSiteArray();
                if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    return callSiteArray[7].callCurrent((GroovyObject)this, (Object)name);
                }
                return this.doCall(name);
            }

            public String getDESIRED_NAME() {
                CallSite[] callSiteArray = _testSanitizeDnShouldHandleFuzzing_closure2.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.DESIRED_NAME.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _testSanitizeDnShouldHandleFuzzing_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "info";
                stringArray[1] = "logger";
                stringArray[2] = "printUnicodeString";
                stringArray[3] = "sanitizeDn";
                stringArray[4] = "info";
                stringArray[5] = "logger";
                stringArray[6] = "printUnicodeString";
                stringArray[7] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[8];
                _testSanitizeDnShouldHandleFuzzing_closure2.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_testSanitizeDnShouldHandleFuzzing_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _testSanitizeDnShouldHandleFuzzing_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[33].call((Object)MALICIOUS_NAMES, (Object)new _testSanitizeDnShouldHandleFuzzing_closure2(this, this, DESIRED_NAME));
    }

    @Test
    public void testShouldFormatProxyDn() throws Exception {
        CallSite[] callSiteArray = ProxiedEntitiesUtilsTest.$getCallSiteArray();
        String DN = SAFE_USER_DN_JOHN;
        callSiteArray[34].call((Object)logger, (Object)new GStringImpl(new Object[]{DN}, new String[]{" Provided proxy DN: ", ""}));
        String EXPECTED_PROXY_DN = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{DN}, new String[]{"<", ">"}));
        callSiteArray[35].call((Object)logger, (Object)new GStringImpl(new Object[]{EXPECTED_PROXY_DN}, new String[]{" Expected proxy DN: ", ""}));
        String forjohnedProxyDn = ShortTypeHandling.castToString((Object)callSiteArray[36].call(ProxiedEntitiesUtils.class, (Object)DN));
        callSiteArray[37].call((Object)logger, (Object)new GStringImpl(new Object[]{forjohnedProxyDn}, new String[]{"Forjohned proxy DN: ", ""}));
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            String string = forjohnedProxyDn;
            valueRecorder.record((Object)string, 8);
            String string2 = EXPECTED_PROXY_DN;
            valueRecorder.record((Object)string2, 28);
            boolean bl = ScriptBytecodeAdapter.compareEqual((Object)string, (Object)string2);
            valueRecorder.record((Object)bl, 25);
            if (bl) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert forjohnedProxyDn == EXPECTED_PROXY_DN", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
    }

    @Test
    public void testFormatProxyDnShouldHandleMaliciousInput() throws Exception {
        CallSite[] callSiteArray = ProxiedEntitiesUtilsTest.$getCallSiteArray();
        String DN = MALICIOUS_USER_DN_JOHN;
        callSiteArray[38].call((Object)logger, (Object)new GStringImpl(new Object[]{DN}, new String[]{" Provided proxy DN: ", ""}));
        String SANITIZED_DN = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[39].callStatic(ProxiedEntitiesUtilsTest.class, (Object)DN);
            SANITIZED_DN = ShortTypeHandling.castToString((Object)object);
        } else {
            String string;
            SANITIZED_DN = string = ProxiedEntitiesUtilsTest.sanitizeDn(DN);
        }
        String EXPECTED_PROXY_DN = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{SANITIZED_DN}, new String[]{"<", ">"}));
        callSiteArray[40].call((Object)logger, (Object)new GStringImpl(new Object[]{EXPECTED_PROXY_DN}, new String[]{" Expected proxy DN: ", ""}));
        String forjohnedProxyDn = ShortTypeHandling.castToString((Object)callSiteArray[41].call(ProxiedEntitiesUtils.class, (Object)DN));
        callSiteArray[42].call((Object)logger, (Object)new GStringImpl(new Object[]{forjohnedProxyDn}, new String[]{"Forjohned proxy DN: ", ""}));
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            String string = forjohnedProxyDn;
            valueRecorder.record((Object)string, 8);
            String string2 = EXPECTED_PROXY_DN;
            valueRecorder.record((Object)string2, 28);
            boolean bl = ScriptBytecodeAdapter.compareEqual((Object)string, (Object)string2);
            valueRecorder.record((Object)bl, 25);
            if (bl) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert forjohnedProxyDn == EXPECTED_PROXY_DN", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
    }

    @Test
    public void testShouldBuildProxyChain() throws Exception {
        CallSite[] callSiteArray = ProxiedEntitiesUtilsTest.$getCallSiteArray();
        public final class _testShouldBuildProxyChain_closure3
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _testShouldBuildProxyChain_closure3(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _testShouldBuildProxyChain_closure3.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _testShouldBuildProxyChain_closure3.$getCallSiteArray();
                return callSiteArray[0].callGetProperty(ProxiedEntitiesUtilsTest.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _testShouldBuildProxyChain_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "SAFE_USER_NAME_PROXY_1";
                return new CallSiteArray(_testShouldBuildProxyChain_closure3.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _testShouldBuildProxyChain_closure3.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        public final class _testShouldBuildProxyChain_closure4
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _testShouldBuildProxyChain_closure4(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _testShouldBuildProxyChain_closure4.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _testShouldBuildProxyChain_closure4.$getCallSiteArray();
                return null;
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _testShouldBuildProxyChain_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_testShouldBuildProxyChain_closure4.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _testShouldBuildProxyChain_closure4.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        public final class _testShouldBuildProxyChain_closure5
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _testShouldBuildProxyChain_closure5(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _testShouldBuildProxyChain_closure5.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _testShouldBuildProxyChain_closure5.$getCallSiteArray();
                return false;
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _testShouldBuildProxyChain_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_testShouldBuildProxyChain_closure5.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _testShouldBuildProxyChain_closure5.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Reference mockProxy1 = new Reference((Object)((NiFiUser)ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"getIdentity", new _testShouldBuildProxyChain_closure3(this, this), "getChain", new _testShouldBuildProxyChain_closure4(this, this), "isAnonymous", new _testShouldBuildProxyChain_closure5(this, this)}), NiFiUser.class)));
        public final class _testShouldBuildProxyChain_closure6
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _testShouldBuildProxyChain_closure6(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _testShouldBuildProxyChain_closure6.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _testShouldBuildProxyChain_closure6.$getCallSiteArray();
                return callSiteArray[0].callGetProperty(ProxiedEntitiesUtilsTest.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _testShouldBuildProxyChain_closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "SAFE_USER_NAME_JOHN";
                return new CallSiteArray(_testShouldBuildProxyChain_closure6.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _testShouldBuildProxyChain_closure6.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        public final class _testShouldBuildProxyChain_closure7
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference mockProxy1;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _testShouldBuildProxyChain_closure7(Object _outerInstance, Object _thisObject, Reference mockProxy1) {
                Reference reference;
                CallSite[] callSiteArray = _testShouldBuildProxyChain_closure7.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.mockProxy1 = reference = mockProxy1;
            }

            public Object doCall() {
                CallSite[] callSiteArray = _testShouldBuildProxyChain_closure7.$getCallSiteArray();
                return this.mockProxy1.get();
            }

            public Object getMockProxy1() {
                CallSite[] callSiteArray = _testShouldBuildProxyChain_closure7.$getCallSiteArray();
                return this.mockProxy1.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _testShouldBuildProxyChain_closure7.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_testShouldBuildProxyChain_closure7.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _testShouldBuildProxyChain_closure7.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        public final class _testShouldBuildProxyChain_closure8
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _testShouldBuildProxyChain_closure8(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _testShouldBuildProxyChain_closure8.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _testShouldBuildProxyChain_closure8.$getCallSiteArray();
                return false;
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _testShouldBuildProxyChain_closure8.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_testShouldBuildProxyChain_closure8.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _testShouldBuildProxyChain_closure8.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        NiFiUser mockJohn = (NiFiUser)ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"getIdentity", new _testShouldBuildProxyChain_closure6(this, this), "getChain", new _testShouldBuildProxyChain_closure7(this, this, mockProxy1), "isAnonymous", new _testShouldBuildProxyChain_closure8(this, this)}), NiFiUser.class);
        String proxiedEntitiesChain = ShortTypeHandling.castToString((Object)callSiteArray[43].call(ProxiedEntitiesUtils.class, (Object)mockJohn));
        callSiteArray[44].call((Object)logger, (Object)new GStringImpl(new Object[]{proxiedEntitiesChain}, new String[]{"Proxied entities chain: ", ""}));
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            String string = proxiedEntitiesChain;
            valueRecorder.record((Object)string, 8);
            Object[] objectArray = new Object[2];
            String string2 = SAFE_USER_NAME_JOHN;
            valueRecorder.record((Object)string2, 36);
            valueRecorder.record((Object)string2, 36);
            objectArray[0] = string2;
            String string3 = SAFE_USER_NAME_PROXY_1;
            valueRecorder.record((Object)string3, 60);
            valueRecorder.record((Object)string3, 60);
            objectArray[1] = string3;
            boolean bl = ScriptBytecodeAdapter.compareEqual((Object)string, (Object)((String)ScriptBytecodeAdapter.asType((Object)new GStringImpl(objectArray, new String[]{"<", "><", ">"}), String.class)));
            valueRecorder.record((Object)bl, 29);
            if (bl) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert proxiedEntitiesChain == \"<${SAFE_USER_NAME_JOHN}><${SAFE_USER_NAME_PROXY_1}>\" as String", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
    }

    @Test
    public void testBuildProxyChainFromNullUserShouldBeAnonymous() throws Exception {
        CallSite[] callSiteArray = ProxiedEntitiesUtilsTest.$getCallSiteArray();
        String proxiedEntitiesChain = ShortTypeHandling.castToString((Object)callSiteArray[45].call(ProxiedEntitiesUtils.class, null));
        callSiteArray[46].call((Object)logger, (Object)new GStringImpl(new Object[]{proxiedEntitiesChain}, new String[]{"Proxied entities chain: ", ""}));
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            String string = proxiedEntitiesChain;
            valueRecorder.record((Object)string, 8);
            boolean bl = ScriptBytecodeAdapter.compareEqual((Object)string, (Object)"<>");
            valueRecorder.record((Object)bl, 29);
            if (bl) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert proxiedEntitiesChain == \"<>\"", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
    }

    @Test
    public void testBuildProxyChainFromAnonymousUserShouldBeAnonymous() throws Exception {
        CallSite[] callSiteArray = ProxiedEntitiesUtilsTest.$getCallSiteArray();
        public final class _testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure9
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure9(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure9.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure9.$getCallSiteArray();
                return callSiteArray[0].callGetProperty(ProxiedEntitiesUtilsTest.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure9.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "SAFE_USER_NAME_PROXY_1";
                return new CallSiteArray(_testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure9.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure9.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        public final class _testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure10
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure10(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure10.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure10.$getCallSiteArray();
                return null;
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure10.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure10.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure10.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        public final class _testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure11
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure11(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure11.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure11.$getCallSiteArray();
                return false;
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure11.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure11.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure11.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Reference mockProxy1 = new Reference((Object)((NiFiUser)ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"getIdentity", new _testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure9(this, this), "getChain", new _testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure10(this, this), "isAnonymous", new _testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure11(this, this)}), NiFiUser.class)));
        public final class _testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure12
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure12(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure12.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure12.$getCallSiteArray();
                return "anonymous";
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure12.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure12.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure12.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        public final class _testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure13
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference mockProxy1;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure13(Object _outerInstance, Object _thisObject, Reference mockProxy1) {
                Reference reference;
                CallSite[] callSiteArray = _testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure13.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.mockProxy1 = reference = mockProxy1;
            }

            public Object doCall() {
                CallSite[] callSiteArray = _testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure13.$getCallSiteArray();
                return this.mockProxy1.get();
            }

            public Object getMockProxy1() {
                CallSite[] callSiteArray = _testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure13.$getCallSiteArray();
                return this.mockProxy1.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure13.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure13.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure13.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        public final class _testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure14
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure14(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure14.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure14.$getCallSiteArray();
                return true;
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure14.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure14.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure14.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        NiFiUser mockAnonymous = (NiFiUser)ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"getIdentity", new _testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure12(this, this), "getChain", new _testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure13(this, this, mockProxy1), "isAnonymous", new _testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure14(this, this)}), NiFiUser.class);
        String proxiedEntitiesChain = ShortTypeHandling.castToString((Object)callSiteArray[47].call(ProxiedEntitiesUtils.class, (Object)mockAnonymous));
        callSiteArray[48].call((Object)logger, (Object)new GStringImpl(new Object[]{proxiedEntitiesChain}, new String[]{"Proxied entities chain: ", ""}));
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            String string = proxiedEntitiesChain;
            valueRecorder.record((Object)string, 8);
            Object[] objectArray = new Object[1];
            String string2 = SAFE_USER_NAME_PROXY_1;
            valueRecorder.record((Object)string2, 38);
            valueRecorder.record((Object)string2, 38);
            objectArray[0] = string2;
            boolean bl = ScriptBytecodeAdapter.compareEqual((Object)string, (Object)((String)ScriptBytecodeAdapter.asType((Object)new GStringImpl(objectArray, new String[]{"<><", ">"}), String.class)));
            valueRecorder.record((Object)bl, 29);
            if (bl) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert proxiedEntitiesChain == \"<><${SAFE_USER_NAME_PROXY_1}>\" as String", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
    }

    @Test
    public void testBuildProxyChainShouldHandleMaliciousUser() throws Exception {
        CallSite[] callSiteArray = ProxiedEntitiesUtilsTest.$getCallSiteArray();
        public final class _testBuildProxyChainShouldHandleMaliciousUser_closure15
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _testBuildProxyChainShouldHandleMaliciousUser_closure15(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _testBuildProxyChainShouldHandleMaliciousUser_closure15.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _testBuildProxyChainShouldHandleMaliciousUser_closure15.$getCallSiteArray();
                return callSiteArray[0].callGetProperty(ProxiedEntitiesUtilsTest.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _testBuildProxyChainShouldHandleMaliciousUser_closure15.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "SAFE_USER_NAME_PROXY_1";
                return new CallSiteArray(_testBuildProxyChainShouldHandleMaliciousUser_closure15.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _testBuildProxyChainShouldHandleMaliciousUser_closure15.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        public final class _testBuildProxyChainShouldHandleMaliciousUser_closure16
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _testBuildProxyChainShouldHandleMaliciousUser_closure16(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _testBuildProxyChainShouldHandleMaliciousUser_closure16.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _testBuildProxyChainShouldHandleMaliciousUser_closure16.$getCallSiteArray();
                return null;
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _testBuildProxyChainShouldHandleMaliciousUser_closure16.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_testBuildProxyChainShouldHandleMaliciousUser_closure16.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _testBuildProxyChainShouldHandleMaliciousUser_closure16.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        public final class _testBuildProxyChainShouldHandleMaliciousUser_closure17
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _testBuildProxyChainShouldHandleMaliciousUser_closure17(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _testBuildProxyChainShouldHandleMaliciousUser_closure17.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _testBuildProxyChainShouldHandleMaliciousUser_closure17.$getCallSiteArray();
                return false;
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _testBuildProxyChainShouldHandleMaliciousUser_closure17.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_testBuildProxyChainShouldHandleMaliciousUser_closure17.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _testBuildProxyChainShouldHandleMaliciousUser_closure17.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Reference mockProxy1 = new Reference((Object)((NiFiUser)ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"getIdentity", new _testBuildProxyChainShouldHandleMaliciousUser_closure15(this, this), "getChain", new _testBuildProxyChainShouldHandleMaliciousUser_closure16(this, this), "isAnonymous", new _testBuildProxyChainShouldHandleMaliciousUser_closure17(this, this)}), NiFiUser.class)));
        public final class _testBuildProxyChainShouldHandleMaliciousUser_closure18
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _testBuildProxyChainShouldHandleMaliciousUser_closure18(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _testBuildProxyChainShouldHandleMaliciousUser_closure18.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _testBuildProxyChainShouldHandleMaliciousUser_closure18.$getCallSiteArray();
                return callSiteArray[0].callGetProperty(ProxiedEntitiesUtilsTest.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _testBuildProxyChainShouldHandleMaliciousUser_closure18.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "MALICIOUS_USER_NAME_JOHN";
                return new CallSiteArray(_testBuildProxyChainShouldHandleMaliciousUser_closure18.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _testBuildProxyChainShouldHandleMaliciousUser_closure18.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        public final class _testBuildProxyChainShouldHandleMaliciousUser_closure19
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference mockProxy1;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _testBuildProxyChainShouldHandleMaliciousUser_closure19(Object _outerInstance, Object _thisObject, Reference mockProxy1) {
                Reference reference;
                CallSite[] callSiteArray = _testBuildProxyChainShouldHandleMaliciousUser_closure19.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.mockProxy1 = reference = mockProxy1;
            }

            public Object doCall() {
                CallSite[] callSiteArray = _testBuildProxyChainShouldHandleMaliciousUser_closure19.$getCallSiteArray();
                return this.mockProxy1.get();
            }

            public Object getMockProxy1() {
                CallSite[] callSiteArray = _testBuildProxyChainShouldHandleMaliciousUser_closure19.$getCallSiteArray();
                return this.mockProxy1.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _testBuildProxyChainShouldHandleMaliciousUser_closure19.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_testBuildProxyChainShouldHandleMaliciousUser_closure19.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _testBuildProxyChainShouldHandleMaliciousUser_closure19.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        public final class _testBuildProxyChainShouldHandleMaliciousUser_closure20
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _testBuildProxyChainShouldHandleMaliciousUser_closure20(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _testBuildProxyChainShouldHandleMaliciousUser_closure20.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _testBuildProxyChainShouldHandleMaliciousUser_closure20.$getCallSiteArray();
                return false;
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _testBuildProxyChainShouldHandleMaliciousUser_closure20.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_testBuildProxyChainShouldHandleMaliciousUser_closure20.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _testBuildProxyChainShouldHandleMaliciousUser_closure20.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        NiFiUser mockJohn = (NiFiUser)ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"getIdentity", new _testBuildProxyChainShouldHandleMaliciousUser_closure18(this, this), "getChain", new _testBuildProxyChainShouldHandleMaliciousUser_closure19(this, this, mockProxy1), "isAnonymous", new _testBuildProxyChainShouldHandleMaliciousUser_closure20(this, this)}), NiFiUser.class);
        String proxiedEntitiesChain = ShortTypeHandling.castToString((Object)callSiteArray[49].call(ProxiedEntitiesUtils.class, (Object)mockJohn));
        callSiteArray[50].call((Object)logger, (Object)new GStringImpl(new Object[]{proxiedEntitiesChain}, new String[]{"Proxied entities chain: ", ""}));
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            String string = proxiedEntitiesChain;
            valueRecorder.record((Object)string, 8);
            Object[] objectArray = new Object[2];
            String string2 = MALICIOUS_USER_NAME_JOHN_ESCAPED;
            valueRecorder.record((Object)string2, 36);
            valueRecorder.record((Object)string2, 36);
            objectArray[0] = string2;
            String string3 = SAFE_USER_NAME_PROXY_1;
            valueRecorder.record((Object)string3, 73);
            valueRecorder.record((Object)string3, 73);
            objectArray[1] = string3;
            boolean bl = ScriptBytecodeAdapter.compareEqual((Object)string, (Object)((String)ScriptBytecodeAdapter.asType((Object)new GStringImpl(objectArray, new String[]{"<", "><", ">"}), String.class)));
            valueRecorder.record((Object)bl, 29);
            if (bl) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert proxiedEntitiesChain == \"<${MALICIOUS_USER_NAME_JOHN_ESCAPED}><${SAFE_USER_NAME_PROXY_1}>\" as String", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
    }

    @Test
    public void testShouldTokenizeProxiedEntitiesChainWithUserNames() throws Exception {
        CallSite[] callSiteArray = ProxiedEntitiesUtilsTest.$getCallSiteArray();
        List NAMES = ScriptBytecodeAdapter.createList((Object[])new Object[]{SAFE_USER_NAME_JOHN, SAFE_USER_NAME_PROXY_1, SAFE_USER_NAME_PROXY_2});
        String RAW_PROXY_CHAIN = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{callSiteArray[51].call((Object)NAMES, (Object)"><")}, new String[]{"<", ">"}));
        callSiteArray[52].call((Object)logger, (Object)new GStringImpl(new Object[]{RAW_PROXY_CHAIN}, new String[]{" Provided proxy chain: ", ""}));
        Object tokenizedNames = callSiteArray[53].call(ProxiedEntitiesUtils.class, (Object)RAW_PROXY_CHAIN);
        callSiteArray[54].call((Object)logger, (Object)new GStringImpl(new Object[]{tokenizedNames}, new String[]{"Tokenized proxy chain: ", ""}));
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            Object object = tokenizedNames;
            valueRecorder.record(object, 8);
            List list = NAMES;
            valueRecorder.record((Object)list, 26);
            boolean bl = ScriptBytecodeAdapter.compareEqual((Object)object, (Object)list);
            valueRecorder.record((Object)bl, 23);
            if (bl) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert tokenizedNames == NAMES", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
    }

    @Test
    public void testShouldTokenizeProxiedEntitiesChainWithDNs() throws Exception {
        CallSite[] callSiteArray = ProxiedEntitiesUtilsTest.$getCallSiteArray();
        List DNS = ScriptBytecodeAdapter.createList((Object[])new Object[]{SAFE_USER_DN_JOHN, SAFE_USER_DN_PROXY_1, SAFE_USER_DN_PROXY_2});
        String RAW_PROXY_CHAIN = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{callSiteArray[55].call((Object)DNS, (Object)"><")}, new String[]{"<", ">"}));
        callSiteArray[56].call((Object)logger, (Object)new GStringImpl(new Object[]{RAW_PROXY_CHAIN}, new String[]{" Provided proxy chain: ", ""}));
        Object tokenizedDns = callSiteArray[57].call(ProxiedEntitiesUtils.class, (Object)RAW_PROXY_CHAIN);
        public final class _testShouldTokenizeProxiedEntitiesChainWithDNs_closure21
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _testShouldTokenizeProxiedEntitiesChainWithDNs_closure21(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _testShouldTokenizeProxiedEntitiesChainWithDNs_closure21.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _testShouldTokenizeProxiedEntitiesChainWithDNs_closure21.$getCallSiteArray();
                return new GStringImpl(new Object[]{it}, new String[]{"\"", "\""});
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _testShouldTokenizeProxiedEntitiesChainWithDNs_closure21.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _testShouldTokenizeProxiedEntitiesChainWithDNs_closure21.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_testShouldTokenizeProxiedEntitiesChainWithDNs_closure21.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _testShouldTokenizeProxiedEntitiesChainWithDNs_closure21.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[58].call((Object)logger, (Object)new GStringImpl(new Object[]{callSiteArray[59].call(tokenizedDns, (Object)new _testShouldTokenizeProxiedEntitiesChainWithDNs_closure21(this, this))}, new String[]{"Tokenized proxy chain: ", ""}));
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            Object object = tokenizedDns;
            valueRecorder.record(object, 8);
            List list = DNS;
            valueRecorder.record((Object)list, 24);
            boolean bl = ScriptBytecodeAdapter.compareEqual((Object)object, (Object)list);
            valueRecorder.record((Object)bl, 21);
            if (bl) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert tokenizedDns == DNS", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
    }

    @Test
    public void testShouldTokenizeProxiedEntitiesChainWithAnonymousUser() throws Exception {
        CallSite[] callSiteArray = ProxiedEntitiesUtilsTest.$getCallSiteArray();
        List NAMES = ScriptBytecodeAdapter.createList((Object[])new Object[]{"", SAFE_USER_NAME_PROXY_1, SAFE_USER_NAME_PROXY_2});
        String RAW_PROXY_CHAIN = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{callSiteArray[60].call((Object)NAMES, (Object)"><")}, new String[]{"<", ">"}));
        callSiteArray[61].call((Object)logger, (Object)new GStringImpl(new Object[]{RAW_PROXY_CHAIN}, new String[]{" Provided proxy chain: ", ""}));
        Object tokenizedNames = callSiteArray[62].call(ProxiedEntitiesUtils.class, (Object)RAW_PROXY_CHAIN);
        callSiteArray[63].call((Object)logger, (Object)new GStringImpl(new Object[]{tokenizedNames}, new String[]{"Tokenized proxy chain: ", ""}));
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            Object object = tokenizedNames;
            valueRecorder.record(object, 8);
            List list = NAMES;
            valueRecorder.record((Object)list, 26);
            boolean bl = ScriptBytecodeAdapter.compareEqual((Object)object, (Object)list);
            valueRecorder.record((Object)bl, 23);
            if (bl) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert tokenizedNames == NAMES", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
    }

    @Test
    public void testTokenizeProxiedEntitiesChainShouldHandleMaliciousUser() throws Exception {
        CallSite[] callSiteArray = ProxiedEntitiesUtilsTest.$getCallSiteArray();
        List NAMES = ScriptBytecodeAdapter.createList((Object[])new Object[]{MALICIOUS_USER_NAME_JOHN, SAFE_USER_NAME_PROXY_1, SAFE_USER_NAME_PROXY_2});
        public final class _testTokenizeProxiedEntitiesChainShouldHandleMaliciousUser_closure22
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _testTokenizeProxiedEntitiesChainShouldHandleMaliciousUser_closure22(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _testTokenizeProxiedEntitiesChainShouldHandleMaliciousUser_closure22.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _testTokenizeProxiedEntitiesChainShouldHandleMaliciousUser_closure22.$getCallSiteArray();
                return callSiteArray[0].callStatic(ProxiedEntitiesUtilsTest.class, it);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _testTokenizeProxiedEntitiesChainShouldHandleMaliciousUser_closure22.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _testTokenizeProxiedEntitiesChainShouldHandleMaliciousUser_closure22.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "sanitizeDn";
                return new CallSiteArray(_testTokenizeProxiedEntitiesChainShouldHandleMaliciousUser_closure22.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _testTokenizeProxiedEntitiesChainShouldHandleMaliciousUser_closure22.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        String RAW_PROXY_CHAIN = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{callSiteArray[64].call(callSiteArray[65].call((Object)NAMES, (Object)new _testTokenizeProxiedEntitiesChainShouldHandleMaliciousUser_closure22(this, this)), (Object)"><")}, new String[]{"<", ">"}));
        callSiteArray[66].call((Object)logger, (Object)new GStringImpl(new Object[]{RAW_PROXY_CHAIN}, new String[]{" Provided proxy chain: ", ""}));
        Object tokenizedNames = callSiteArray[67].call(ProxiedEntitiesUtils.class, (Object)RAW_PROXY_CHAIN);
        public final class _testTokenizeProxiedEntitiesChainShouldHandleMaliciousUser_closure23
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _testTokenizeProxiedEntitiesChainShouldHandleMaliciousUser_closure23(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _testTokenizeProxiedEntitiesChainShouldHandleMaliciousUser_closure23.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _testTokenizeProxiedEntitiesChainShouldHandleMaliciousUser_closure23.$getCallSiteArray();
                return new GStringImpl(new Object[]{it}, new String[]{"\"", "\""});
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _testTokenizeProxiedEntitiesChainShouldHandleMaliciousUser_closure23.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _testTokenizeProxiedEntitiesChainShouldHandleMaliciousUser_closure23.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_testTokenizeProxiedEntitiesChainShouldHandleMaliciousUser_closure23.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _testTokenizeProxiedEntitiesChainShouldHandleMaliciousUser_closure23.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[68].call((Object)logger, (Object)new GStringImpl(new Object[]{callSiteArray[69].call(tokenizedNames, (Object)new _testTokenizeProxiedEntitiesChainShouldHandleMaliciousUser_closure23(this, this))}, new String[]{"Tokenized proxy chain: ", ""}));
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            Object object = tokenizedNames;
            valueRecorder.record(object, 8);
            List list = NAMES;
            valueRecorder.record((Object)list, 26);
            boolean bl = ScriptBytecodeAdapter.compareEqual((Object)object, (Object)list);
            valueRecorder.record((Object)bl, 23);
            if (bl) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert tokenizedNames == NAMES", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        ValueRecorder valueRecorder2 = new ValueRecorder();
        try {
            CallSite callSite = callSiteArray[70];
            Object object = tokenizedNames;
            valueRecorder2.record(object, 8);
            Object object2 = callSite.call(object);
            valueRecorder2.record(object2, 23);
            CallSite callSite2 = callSiteArray[71];
            List list = NAMES;
            valueRecorder2.record((Object)list, 33);
            Object object3 = callSite2.call((Object)list);
            valueRecorder2.record(object3, 39);
            boolean bl = ScriptBytecodeAdapter.compareEqual((Object)object2, (Object)object3);
            valueRecorder2.record((Object)bl, 30);
            if (bl) {
                valueRecorder2.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert tokenizedNames.size() == NAMES.size()", (ValueRecorder)valueRecorder2), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder2.clear();
            throw throwable;
        }
        ValueRecorder valueRecorder3 = new ValueRecorder();
        try {
            CallSite callSite = callSiteArray[72];
            Object object = tokenizedNames;
            valueRecorder3.record(object, 9);
            String string = SAFE_USER_NAME_JOHN;
            valueRecorder3.record((Object)string, 33);
            valueRecorder3.record((Object)string, 33);
            Object object4 = callSite.call(object, (Object)string);
            valueRecorder3.record(object4, 24);
            boolean bl = !DefaultTypeTransformation.booleanUnbox((Object)object4);
            valueRecorder3.record((Object)bl, 8);
            if (bl) {
                valueRecorder3.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert !tokenizedNames.contains(SAFE_USER_NAME_JOHN)", (ValueRecorder)valueRecorder3), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder3.clear();
            throw throwable;
        }
    }

    @Generated
    private static String sanitizeDn() {
        CallSite[] callSiteArray = ProxiedEntitiesUtilsTest.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return ProxiedEntitiesUtilsTest.sanitizeDn("");
        }
        return ProxiedEntitiesUtilsTest.sanitizeDn("");
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ProxiedEntitiesUtilsTest.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Object object = ProxiedEntitiesUtilsTest.$getCallSiteArray()[73].call(LoggerFactory.class, ProxiedEntitiesUtils.class);
        logger = (Logger)ScriptBytecodeAdapter.castToType((Object)object, Logger.class);
        GStringImpl gStringImpl = new GStringImpl(new Object[]{SAFE_USER_NAME_ANDY}, new String[]{"CN=", ", OU=Apache NiFi"});
        SAFE_USER_DN_ANDY = ShortTypeHandling.castToString((Object)gStringImpl);
        GStringImpl gStringImpl2 = new GStringImpl(new Object[]{SAFE_USER_NAME_JOHN}, new String[]{"CN=", ", OU=Apache NiFi"});
        SAFE_USER_DN_JOHN = ShortTypeHandling.castToString((Object)gStringImpl2);
        GStringImpl gStringImpl3 = new GStringImpl(new Object[]{SAFE_USER_NAME_PROXY_1}, new String[]{"CN=", ", OU=Apache NiFi"});
        SAFE_USER_DN_PROXY_1 = ShortTypeHandling.castToString((Object)gStringImpl3);
        GStringImpl gStringImpl4 = new GStringImpl(new Object[]{SAFE_USER_NAME_PROXY_2}, new String[]{"CN=", ", OU=Apache NiFi"});
        SAFE_USER_DN_PROXY_2 = ShortTypeHandling.castToString((Object)gStringImpl4);
        GStringImpl gStringImpl5 = new GStringImpl(new Object[]{SAFE_USER_NAME_JOHN, SAFE_USER_NAME_PROXY_1}, new String[]{"", ", OU=Apache NiFi><CN=", ""});
        MALICIOUS_USER_NAME_JOHN = ShortTypeHandling.castToString((Object)gStringImpl5);
        GStringImpl gStringImpl6 = new GStringImpl(new Object[]{MALICIOUS_USER_NAME_JOHN}, new String[]{"CN=", ", OU=Apache NiFi"});
        MALICIOUS_USER_DN_JOHN = ShortTypeHandling.castToString((Object)gStringImpl6);
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object2 = ProxiedEntitiesUtilsTest.$getCallSiteArray()[74].callStatic(ProxiedEntitiesUtilsTest.class, (Object)MALICIOUS_USER_NAME_JOHN);
            MALICIOUS_USER_NAME_JOHN_ESCAPED = ShortTypeHandling.castToString((Object)object2);
        } else {
            String string;
            MALICIOUS_USER_NAME_JOHN_ESCAPED = string = ProxiedEntitiesUtilsTest.sanitizeDn(MALICIOUS_USER_NAME_JOHN);
        }
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object3 = ProxiedEntitiesUtilsTest.$getCallSiteArray()[75].callStatic(ProxiedEntitiesUtilsTest.class, (Object)MALICIOUS_USER_DN_JOHN);
            MALICIOUS_USER_DN_JOHN_ESCAPED = ShortTypeHandling.castToString((Object)object3);
        } else {
            String string;
            MALICIOUS_USER_DN_JOHN_ESCAPED = string = ProxiedEntitiesUtilsTest.sanitizeDn(MALICIOUS_USER_DN_JOHN);
        }
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "metaClass";
        stringArray[1] = "replaceAll";
        stringArray[2] = "replaceAll";
        stringArray[3] = "<$constructor$>";
        stringArray[4] = "size";
        stringArray[5] = "codePointAt";
        stringArray[6] = "charCount";
        stringArray[7] = "plus";
        stringArray[8] = "minus";
        stringArray[9] = "length";
        stringArray[10] = "<$constructor$>";
        stringArray[11] = "append";
        stringArray[12] = "format";
        stringArray[13] = "next";
        stringArray[14] = "size";
        stringArray[15] = "codePointAt";
        stringArray[16] = "charCount";
        stringArray[17] = "length";
        stringArray[18] = "<$constructor$>";
        stringArray[19] = "append";
        stringArray[20] = "format";
        stringArray[21] = "trim";
        stringArray[22] = "toString";
        stringArray[23] = "info";
        stringArray[24] = "printUnicodeString";
        stringArray[25] = "info";
        stringArray[26] = "plus";
        stringArray[27] = "plus";
        stringArray[28] = "plus";
        stringArray[29] = "plus";
        stringArray[30] = "plus";
        stringArray[31] = "plus";
        stringArray[32] = "plus";
        stringArray[33] = "each";
        stringArray[34] = "info";
        stringArray[35] = "info";
        stringArray[36] = "formatProxyDn";
        stringArray[37] = "info";
        stringArray[38] = "info";
        stringArray[39] = "sanitizeDn";
        stringArray[40] = "info";
        stringArray[41] = "formatProxyDn";
        stringArray[42] = "info";
        stringArray[43] = "buildProxiedEntitiesChainString";
        stringArray[44] = "info";
        stringArray[45] = "buildProxiedEntitiesChainString";
        stringArray[46] = "info";
        stringArray[47] = "buildProxiedEntitiesChainString";
        stringArray[48] = "info";
        stringArray[49] = "buildProxiedEntitiesChainString";
        stringArray[50] = "info";
        stringArray[51] = "join";
        stringArray[52] = "info";
        stringArray[53] = "tokenizeProxiedEntitiesChain";
        stringArray[54] = "info";
        stringArray[55] = "join";
        stringArray[56] = "info";
        stringArray[57] = "tokenizeProxiedEntitiesChain";
        stringArray[58] = "info";
        stringArray[59] = "collect";
        stringArray[60] = "join";
        stringArray[61] = "info";
        stringArray[62] = "tokenizeProxiedEntitiesChain";
        stringArray[63] = "info";
        stringArray[64] = "join";
        stringArray[65] = "collect";
        stringArray[66] = "info";
        stringArray[67] = "tokenizeProxiedEntitiesChain";
        stringArray[68] = "info";
        stringArray[69] = "collect";
        stringArray[70] = "size";
        stringArray[71] = "size";
        stringArray[72] = "contains";
        stringArray[73] = "getLogger";
        stringArray[74] = "sanitizeDn";
        stringArray[75] = "sanitizeDn";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[76];
        ProxiedEntitiesUtilsTest.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(ProxiedEntitiesUtilsTest.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = ProxiedEntitiesUtilsTest.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

