/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security;

import java.util.List;
import java.util.Properties;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.util.IdentityMapping;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.security.NiFiAuthenticationProvider;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;

public class NiFiAuthenticationProviderTest {
    @Test
    public void testValidPropertiesProvided() {
        String pattern = "^cn=(.*?),dc=(.*?),dc=(.*?)$";
        String value = "$1@$2.$3";
        Properties properties = new Properties();
        properties.setProperty("nifi.security.identity.mapping.pattern.dn", "^cn=(.*?),dc=(.*?),dc=(.*?)$");
        properties.setProperty("nifi.security.identity.mapping.value.dn", "$1@$2.$3");
        NiFiProperties nifiProperties = this.getNiFiProperties(properties);
        TestableNiFiAuthenticationProvider provider = new TestableNiFiAuthenticationProvider(nifiProperties);
        List mappings = provider.getMappings();
        Assert.assertEquals((long)1L, (long)mappings.size());
        Assert.assertEquals((Object)"dn", (Object)((IdentityMapping)mappings.get(0)).getKey());
        Assert.assertEquals((Object)"^cn=(.*?),dc=(.*?),dc=(.*?)$", (Object)((IdentityMapping)mappings.get(0)).getPattern().pattern());
        Assert.assertEquals((Object)"$1@$2.$3", (Object)((IdentityMapping)mappings.get(0)).getReplacementValue());
    }

    @Test
    public void testNoMappings() {
        Properties properties = new Properties();
        NiFiProperties nifiProperties = this.getNiFiProperties(properties);
        TestableNiFiAuthenticationProvider provider = new TestableNiFiAuthenticationProvider(nifiProperties);
        List mappings = provider.getMappings();
        Assert.assertEquals((long)0L, (long)mappings.size());
        String identity = "john";
        Assert.assertEquals((Object)"john", (Object)provider.mapIdentity("john"));
    }

    @Test
    public void testPatternPropertyWithNoValue() {
        Properties properties = new Properties();
        properties.setProperty("nifi.security.identity.mapping.pattern.dn", "");
        properties.setProperty("nifi.security.identity.mapping.value.dn", "value");
        NiFiProperties nifiProperties = this.getNiFiProperties(properties);
        TestableNiFiAuthenticationProvider provider = new TestableNiFiAuthenticationProvider(nifiProperties);
        List mappings = provider.getMappings();
        Assert.assertEquals((long)0L, (long)mappings.size());
    }

    @Test
    public void testPatternPropertyWithNoCorrespondingValueProperty() {
        Properties properties = new Properties();
        properties.setProperty("nifi.security.identity.mapping.pattern.dn", "");
        NiFiProperties nifiProperties = this.getNiFiProperties(properties);
        TestableNiFiAuthenticationProvider provider = new TestableNiFiAuthenticationProvider(nifiProperties);
        List mappings = provider.getMappings();
        Assert.assertEquals((long)0L, (long)mappings.size());
    }

    @Test
    public void testMultipleMappings() {
        Properties properties = new Properties();
        properties.setProperty("nifi.security.identity.mapping.pattern.1", "pattern1");
        properties.setProperty("nifi.security.identity.mapping.value.1", "value1");
        properties.setProperty("nifi.security.identity.mapping.pattern.2", "pattern2");
        properties.setProperty("nifi.security.identity.mapping.value.2", "value2");
        properties.setProperty("nifi.security.identity.mapping.pattern.3", "pattern3");
        properties.setProperty("nifi.security.identity.mapping.value.3", "value3");
        NiFiProperties nifiProperties = this.getNiFiProperties(properties);
        TestableNiFiAuthenticationProvider provider = new TestableNiFiAuthenticationProvider(nifiProperties);
        List mappings = provider.getMappings();
        Assert.assertEquals((long)3L, (long)mappings.size());
    }

    @Test
    public void testMapIdentityWithSingleMapping() {
        Properties properties = new Properties();
        properties.setProperty("nifi.security.identity.mapping.pattern.dn", "^cn=(.*?),dc=(.*?),dc=(.*?)$");
        properties.setProperty("nifi.security.identity.mapping.value.dn", "$1@$2.$3");
        NiFiProperties nifiProperties = this.getNiFiProperties(properties);
        TestableNiFiAuthenticationProvider provider = new TestableNiFiAuthenticationProvider(nifiProperties);
        String identity = "cn=jsmith,dc=aaa,dc=bbb";
        String mappedIdentity = provider.mapIdentity("cn=jsmith,dc=aaa,dc=bbb");
        Assert.assertEquals((Object)"jsmith@aaa.bbb", (Object)mappedIdentity);
    }

    @Test
    public void testMapIdentityWithIncorrectGroupReference() {
        Properties properties = new Properties();
        properties.setProperty("nifi.security.identity.mapping.pattern.dn", "^cn=(.*?),dc=(.*?),dc=(.*?)$");
        properties.setProperty("nifi.security.identity.mapping.value.dn", "$1@$2.$4");
        NiFiProperties nifiProperties = this.getNiFiProperties(properties);
        TestableNiFiAuthenticationProvider provider = new TestableNiFiAuthenticationProvider(nifiProperties);
        String identity = "cn=jsmith,dc=aaa,dc=bbb";
        String mappedIdentity = provider.mapIdentity("cn=jsmith,dc=aaa,dc=bbb");
        Assert.assertEquals((Object)"jsmith@aaa.$4", (Object)mappedIdentity);
    }

    @Test
    public void testMapIdentityWithNoGroupReference() {
        Properties properties = new Properties();
        properties.setProperty("nifi.security.identity.mapping.pattern.dn", "^cn=(.*?),dc=(.*?),dc=(.*?)$");
        properties.setProperty("nifi.security.identity.mapping.value.dn", "this makes no sense");
        NiFiProperties nifiProperties = this.getNiFiProperties(properties);
        TestableNiFiAuthenticationProvider provider = new TestableNiFiAuthenticationProvider(nifiProperties);
        String identity = "cn=jsmith,dc=aaa,dc=bbb";
        String mappedIdentity = provider.mapIdentity("cn=jsmith,dc=aaa,dc=bbb");
        Assert.assertEquals((Object)"this makes no sense", (Object)mappedIdentity);
    }

    @Test
    public void testMapIdentityWithMultipleMatchingPatterns() {
        Properties properties = new Properties();
        properties.setProperty("nifi.security.identity.mapping.pattern.dn2", "^cn=(.*?),dc=(.*?),dc=(.*?)$");
        properties.setProperty("nifi.security.identity.mapping.value.dn2", "$1_$2_$3");
        properties.setProperty("nifi.security.identity.mapping.pattern.dn1", "^cn=(.*?),dc=(.*?),dc=(.*?)$");
        properties.setProperty("nifi.security.identity.mapping.value.dn1", "$1 $2 $3");
        NiFiProperties nifiProperties = this.getNiFiProperties(properties);
        TestableNiFiAuthenticationProvider provider = new TestableNiFiAuthenticationProvider(nifiProperties);
        String identity = "cn=jsmith,dc=aaa,dc=bbb";
        String mappedIdentity = provider.mapIdentity("cn=jsmith,dc=aaa,dc=bbb");
        Assert.assertEquals((Object)"jsmith aaa bbb", (Object)mappedIdentity);
    }

    private NiFiProperties getNiFiProperties(final Properties properties) {
        NiFiProperties nifiProperties = (NiFiProperties)Mockito.mock(NiFiProperties.class);
        Mockito.when((Object)nifiProperties.getPropertyKeys()).thenReturn(properties.stringPropertyNames());
        Mockito.when((Object)nifiProperties.getProperty(Mockito.anyString())).then((Answer)new Answer<String>(){

            public String answer(InvocationOnMock invocationOnMock) throws Throwable {
                return properties.getProperty((String)invocationOnMock.getArguments()[0]);
            }
        });
        return nifiProperties;
    }

    private static class TestableNiFiAuthenticationProvider
    extends NiFiAuthenticationProvider {
        public TestableNiFiAuthenticationProvider(NiFiProperties properties) {
            super(properties, (Authorizer)Mockito.mock(Authorizer.class));
        }

        public Authentication authenticate(Authentication authentication) throws AuthenticationException {
            return null;
        }

        public boolean supports(Class<?> authentication) {
            return false;
        }
    }
}

